/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.lang.reflect.Field;
import oms3.annotations.In;
import oms3.annotations.Out;
import oms3.annotations.Range;
import oms3.annotations.Role;

public class Annotations {
    private Annotations() {
    }

    public static boolean playsAll(Role role, String ... r) {
        if (role == null) {
            return false;
        }
        for (String s : r) {
            if (role.value().contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean plays(Role role, String r) {
        if (r == null) {
            throw new IllegalArgumentException("null role");
        }
        if (role == null) {
            return false;
        }
        return role.value().contains(r);
    }

    public static boolean isIn(Field f) {
        return f.getAnnotation(In.class) != null;
    }

    public static boolean isOut(Field f) {
        return f.getAnnotation(Out.class) != null;
    }

    public static boolean isInOut(Field f) {
        return Annotations.isIn(f) && Annotations.isOut(f);
    }

    public static boolean inRange(Range range, double val) {
        return val >= range.min() && val <= range.max();
    }
}

