/*
 * Decompiled with CFR 0.152.
 */
package oms3.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oms3.Conversions;
import oms3.io.CSProperties;
import oms3.io.CSTable;
import oms3.io.CSVParser;
import oms3.io.CSVStrategy;
import oms3.io.MemoryTable;
import oms3.io.TableIterator;

public class DataIO {
    private static final String P = "@";
    public static final String TABLE = "@T";
    public static final String HEADER = "@H";
    public static final String PROPERTIES = "@S";
    public static final String PROPERTY = "@P";
    public static final String TABLE1 = "@Table";
    public static final String HEADER1 = "@Header";
    public static final String PROPERTIES1 = "@Properties";
    public static final String PROPERTY1 = "@Property";
    public static final String CSPROPERTIES_EXT = "csp";
    public static final String CSTABLE_EXT = "cst";
    private static final String ROOT_ANN = "___root___";
    private static final String COMMENT = "#";
    private static final Map<String, String> NOINFO = Collections.unmodifiableMap(new HashMap());
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^$}]+)\\}");
    private static final String ISO8601 = "yyyy-MM-dd'T'hh:mm:ss";
    public static final String KEY_CONVERTED_FROM = "converted_from";
    public static final String DATE_FORMAT = "date_format";
    public static final String DATE_START = "date_start";
    public static final String DATE_END = "date_end";
    public static final String KEY_CREATED_AT = "created_at";
    public static final String KEY_CREATED_BY = "created_by";
    public static final String KEY_UNIT = "unit";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_TYPE = "type";
    public static final String KEY_NAME = "name";
    public static final String KEY_MISSING_VAL = "missing_value";
    public static final String KEY_FC_START = "forecast_start";
    public static final String KEY_FC_DAYS = "forecast_days";
    public static final String KEY_HIST_YEAR = "historical_year";
    public static final String KEY_DIGEST = "digest";
    public static final String VAL_DATE = "Date";
    public static final int DAILY = 0;
    public static final int MEAN_MONTHLY = 1;
    public static final int MONTHLY_MEAN = 2;
    public static final int ANNUAL_MEAN = 3;
    public static final int PERIOD_MEAN = 4;
    public static final int PERIOD_MEDIAN = 5;
    public static final int PERIOD_STANDARD_DEVIATION = 6;
    public static final int PERIOD_MIN = 7;
    public static final int PERIOD_MAX = 8;

    public static double[] getColumnDoubleValuesInterval(Date start, Date end, CSTable t, String columnName, int timeStep) {
        int col = DataIO.columnIndex(t, columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        SimpleDateFormat fmt = DataIO.lookupDateFormat(t, 1);
        boolean useOrigDaily = false;
        switch (timeStep) {
            case 0: {
                if (useOrigDaily) {
                    ArrayList<Double> l = new ArrayList<Double>();
                    for (String[] row : t.rows()) {
                        try {
                            Date d = fmt.parse(row[1]);
                            if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                            l.add(new Double(row[col]));
                        }
                        catch (ParseException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    double[] arr = new double[l.size()];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (Double)l.get(i);
                    }
                    return arr;
                }
            }
            case 2: 
            case 3: 
            case 4: {
                int previousMonth = -1;
                int previousYear = -1;
                int previousDay = -1;
                boolean previousValid = false;
                boolean lastRow = false;
                boolean useYear = timeStep == 0 || timeStep == 2 || timeStep == 3;
                boolean useMonth = timeStep == 0 || timeStep == 2;
                boolean useDay = timeStep == 0;
                ArrayList<Double> l = new ArrayList<Double>();
                double sum = 0.0;
                int count = 0;
                for (String[] row : t.rows()) {
                    try {
                        boolean newEntry;
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        int month = d.getMonth();
                        int year = d.getYear();
                        int day = d.getDay();
                        double data = Double.parseDouble(row[col]);
                        boolean bl = newEntry = previousValid && (useYear && year != previousYear || useMonth && month != previousMonth || useDay && day != previousDay);
                        if (newEntry) {
                            l.add(sum / (double)count);
                            sum = 0.0;
                            count = 0;
                        }
                        sum += data;
                        ++count;
                        previousValid = true;
                        previousDay = day;
                        previousMonth = month;
                        previousYear = year;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                l.add(sum / (double)count);
                double[] arr = new double[l.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (Double)l.get(i);
                }
                return arr;
            }
            case 1: {
                double[] arr = new double[12];
                int[] count = new int[12];
                for (int i = 0; i < 12; ++i) {
                    arr[i] = 0.0;
                    count[i] = 0;
                }
                for (String[] row : t.rows()) {
                    try {
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        int month = d.getMonth();
                        double data = Double.parseDouble(row[col]);
                        arr[month] = arr[month] + data;
                        count[month] = count[month] + 1;
                        if (month <= 11) continue;
                        throw new RuntimeException("Month > 11 = " + month);
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                for (int i = 0; i < 12; ++i) {
                    arr[i] = arr[i] / (double)count[i];
                }
                return arr;
            }
            case 7: 
            case 8: {
                double min = -1.0;
                double max = -1.0;
                boolean previousValid = false;
                for (String[] row : t.rows()) {
                    try {
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        double data = Double.parseDouble(row[col]);
                        if (!previousValid) {
                            min = data;
                            max = data;
                        } else if (timeStep == 7 && data < min) {
                            min = data;
                        } else if (timeStep == 8 && data > max) {
                            max = data;
                        }
                        previousValid = true;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                double[] arr = new double[]{timeStep == 7 ? min : max};
                return arr;
            }
            case 5: {
                double median;
                ArrayList<Double> l = new ArrayList<Double>();
                for (String[] row : t.rows()) {
                    try {
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        l.add(new Double(row[col]));
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                int lSize = l.size();
                if (lSize == 0) {
                    throw new RuntimeException("No data in file matched the specified period " + start + " to " + end);
                }
                double[] arr = new double[lSize];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (Double)l.get(i);
                }
                l.clear();
                Arrays.sort(arr);
                if (lSize % 2 == 1) {
                    median = arr[(lSize + 1) / 2 - 1];
                } else {
                    double lower = arr[lSize / 2 - 1];
                    double upper = arr[lSize / 2];
                    median = (lower + upper) / 2.0;
                }
                double[] arr2 = new double[]{median};
                return arr2;
            }
            case 6: {
                double sum = 0.0;
                double sq_sum = 0.0;
                double data = 0.0;
                int count = 0;
                for (String[] row : t.rows()) {
                    try {
                        Date d = fmt.parse(row[1]);
                        if (!d.equals(start) && !d.after(start) || !d.equals(end) && !d.before(end)) continue;
                        data = Double.parseDouble(row[col]);
                        sum += data;
                        sq_sum += data * data;
                        ++count;
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                double mean = sum / (double)count;
                double variance = sq_sum / (double)count - mean * mean;
                double standardDeviation = Math.sqrt(variance);
                double[] arr = new double[]{standardDeviation};
                return arr;
            }
        }
        throw new IllegalArgumentException("timeStep " + timeStep + "not supported.");
    }

    public static SimpleDateFormat lookupDateFormat(CSTable table, int col) {
        if (col < 0 || col > table.getColumnCount()) {
            throw new IllegalArgumentException("invalid column: " + col);
        }
        String format = table.getColumnInfo(col).get(KEY_FORMAT);
        if (format == null) {
            format = table.getInfo().get(DATE_FORMAT);
        }
        if (format == null) {
            format = Conversions.ISO().toPattern();
        }
        return new SimpleDateFormat(format);
    }

    public static int findRowByDate(Date date, int dateColumn, CSTable table) {
        String type = table.getColumnInfo(dateColumn).get(KEY_TYPE);
        if (type == null || !type.equalsIgnoreCase(VAL_DATE)) {
            throw new IllegalArgumentException();
        }
        SimpleDateFormat fmt = DataIO.lookupDateFormat(table, dateColumn);
        int rowNo = 0;
        for (String[] row : table.rows()) {
            try {
                Date d = fmt.parse(row[dateColumn]);
                if (d.equals(date)) {
                    return rowNo;
                }
                ++rowNo;
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalArgumentException(date.toString());
    }

    public static CSTable synthESPInput(CSTable table, Date iniStart, Date iniEnd, int fcDays, int year) {
        int start;
        int dateColumn = 1;
        SimpleDateFormat hfmt = DataIO.lookupDateFormat(table, dateColumn);
        GregorianCalendar fcStartCal = new GregorianCalendar();
        fcStartCal.setTime(iniEnd);
        ((Calendar)fcStartCal).add(5, 1);
        Date fcStart = fcStartCal.getTime();
        MemoryTable t = new MemoryTable(table);
        int iniStartRow = DataIO.findRowByDate(iniStart, dateColumn, t);
        int iniEndRow = DataIO.findRowByDate(iniEnd, dateColumn, t);
        List<String[]> iniRows = t.getRows(iniStartRow, iniEndRow);
        GregorianCalendar histStart = new GregorianCalendar();
        histStart.setTime(fcStart);
        histStart.set(1, year);
        int histStartRow = DataIO.findRowByDate(histStart.getTime(), dateColumn, t);
        int histEndRow = histStartRow + (fcDays - 1);
        List<String[]> histRows = t.getRows(histStartRow, histEndRow);
        MemoryTable espTable = new MemoryTable(table);
        espTable.getInfo().put(DATE_START, hfmt.format(iniStart));
        espTable.getInfo().put(KEY_FC_START, hfmt.format(fcStart));
        espTable.getInfo().put(KEY_FC_DAYS, Integer.toString(fcDays));
        espTable.getInfo().put(KEY_HIST_YEAR, Integer.toString(year));
        espTable.clearRows();
        espTable.addRows(iniRows);
        espTable.addRows(histRows);
        GregorianCalendar fcCurrent = new GregorianCalendar();
        fcCurrent.setTime(fcStart);
        List<String[]> espRows = espTable.getRows();
        for (int i = start = iniRows.size(); i <= start + (fcDays - 1); ++i) {
            espRows.get((int)i)[1] = hfmt.format(fcCurrent.getTime());
            ((Calendar)fcCurrent).add(5, 1);
        }
        ((Calendar)fcCurrent).add(5, -1);
        espTable.getInfo().put(DATE_END, hfmt.format(fcCurrent.getTime()));
        return espTable;
    }

    public static int[] sliceByTime(CSTable table, int timeCol, Date start, Date end) {
        if (end.before(start)) {
            throw new IllegalArgumentException("end<start");
        }
        if (timeCol < 0) {
            throw new IllegalArgumentException("timeCol :" + timeCol);
        }
        int s = -1;
        int e = -1;
        int i = -1;
        for (String[] col : table.rows()) {
            ++i;
            Date d = Conversions.convert(col[timeCol], Date.class);
            if (s == -1 && (start.before(d) || start.equals(d))) {
                s = i;
            }
            if (e != -1 || !end.before(d) && !end.equals(d)) continue;
            e = i;
            break;
        }
        return new int[]{s, e};
    }

    public static TableModel createTableModel(final CSTable src) {
        final ArrayList<String[]> rows = new ArrayList<String[]>();
        for (String[] row : src.rows()) {
            rows.add(row);
        }
        return new TableModel(){

            @Override
            public int getColumnCount() {
                return src.getColumnCount();
            }

            @Override
            public String getColumnName(int column) {
                return src.getColumnName(column);
            }

            @Override
            public int getRowCount() {
                return rows.size();
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((String[])rows.get(rowIndex))[columnIndex];
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }
        };
    }

    public static AbstractTableModel getProperties(final CSProperties p) {
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return p.keySet().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return " " + p.keySet().toArray()[rowIndex];
                }
                return p.values().toArray()[rowIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    String[] keys = p.keySet().toArray(new String[0]);
                    p.put(keys[rowIndex], aValue.toString());
                }
            }

            @Override
            public String getColumnName(int column) {
                return column == 0 ? "Name" : "Value";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static AbstractTableModel get2DBounded(final CSProperties p, final String pname) throws ParseException {
        String m = p.getInfo(pname).get("bound");
        String[] dims = m.split(",");
        final int rows = DataIO.getInt(p, dims[0].trim());
        final int cols = DataIO.getInt(p, dims[1].trim());
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return rows;
            }

            @Override
            public int getColumnCount() {
                return cols;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public Object getValueAt(int row, int col) {
                String[][] d = Conversions.convert(p.get(pname), String[][].class);
                return d[row][col].trim();
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                String[][] d = Conversions.convert(p.get(pname), String[][].class);
                d[rowIndex][columnIndex] = aValue.toString().trim();
                String s = DataIO.toArrayString(d);
                p.put(pname, s);
            }

            @Override
            public String getColumnName(int column) {
                return Integer.toString(column);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static boolean playsRole(CSProperties p, String key, String role) {
        String r = p.getInfo(key).get("role");
        if (r == null) {
            return false;
        }
        return r.contains(role);
    }

    public static boolean isBound(CSProperties p, String key, int dim) {
        String bound = p.getInfo(key).get("bound");
        if (bound == null) {
            return false;
        }
        StringTokenizer t = new StringTokenizer(bound, ",");
        return t.countTokens() == dim;
    }

    public static CSTable getTable(CSProperties p, String boundName) {
        MemoryTable m = new MemoryTable();
        List<String> arr = DataIO.keysByMeta(p, "bound", boundName);
        for (String a : arr) {
        }
        return m;
    }

    public static AbstractTableModel getBoundProperties(final CSProperties p, String boundName) throws ParseException {
        final int rows = DataIO.getInt(p, boundName);
        final List<String> arr = DataIO.keysByMeta(p, "bound", boundName);
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return rows;
            }

            @Override
            public int getColumnCount() {
                return arr.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String colname = (String)arr.get(columnIndex);
                String[] d = Conversions.convert(p.get(colname), String[].class);
                return d[rowIndex].trim();
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                String colname = (String)arr.get(columnIndex);
                String[] d = Conversions.convert(p.get(colname), String[].class);
                d[rowIndex] = aValue.toString().trim();
                String s = DataIO.toArrayString(d);
                p.put(colname, s);
            }

            @Override
            public String getColumnName(int column) {
                return (String)arr.get(column);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static AbstractTableModel getUnBoundProperties(final CSProperties p) throws ParseException {
        final List<String> arr = DataIO.keysByNotMeta(p, "bound");
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return arr.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return arr.get(rowIndex);
                }
                return p.get(arr.get(rowIndex));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                p.put(arr.get(rowIndex), aValue.toString());
            }

            @Override
            public String getColumnName(int column) {
                return column == 0 ? "Key" : "Value";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
    }

    public static String toArrayString(String[] arr) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < arr.length; ++i) {
            b.append(arr[i]);
            if (i >= arr.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public static String toArrayString(String[][] arr) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < arr.length; ++i) {
            b.append('{');
            for (int j = 0; j < arr[i].length; ++j) {
                b.append(arr[i][j]);
                if (j >= arr[i].length - 1) continue;
                b.append(',');
            }
            b.append('}');
            if (i >= arr.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public static TableModel fromCSP(CSProperties p, final int dim) {
        List<String> dims = DataIO.keysByMeta(p, "role", "dimension");
        if (dims.isEmpty()) {
            return null;
        }
        for (String d : dims) {
            if (Integer.parseInt(p.get(d).toString()) != dim) continue;
            final List<String> bounds = DataIO.keysByMeta(p, "bound", d);
            final ArrayList<double[]> columns = new ArrayList<double[]>(bounds.size());
            for (String bound : bounds) {
                columns.add(Conversions.convert(p.get(bound), double[].class));
            }
            return new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return dim;
                }

                @Override
                public int getColumnCount() {
                    return bounds.size();
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return Array.get(columns.get(columnIndex), rowIndex);
                }

                @Override
                public String getColumnName(int column) {
                    return (String)bounds.get(column);
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return Double.class;
                }
            };
        }
        return null;
    }

    public static List<String> keysByMeta(CSProperties csp, String mkey, String mval) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            String role;
            if (!csp.getInfo(key).keySet().contains(mkey) || !(role = csp.getInfo(key).get(mkey)).equals(mval)) continue;
            l.add(key);
        }
        return l;
    }

    public static List<String> keysForBounds(CSProperties csp, int boundCount) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            String bound;
            StringTokenizer t;
            if (!csp.getInfo(key).keySet().contains("bound") || (t = new StringTokenizer(bound = csp.getInfo(key).get("bound"), ",")).countTokens() != boundCount) continue;
            l.add(key);
        }
        return l;
    }

    public static List<String> keysByNotMeta(CSProperties csp, String mkey) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            if (csp.getInfo(key).keySet().contains(mkey)) continue;
            l.add(key);
        }
        return l;
    }

    public static Date[] getColumnDateValues(CSTable t, String columnName) {
        int col = DataIO.columnIndex(t, columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        Conversions.Params p = new Conversions.Params();
        p.add(String.class, Date.class, DataIO.lookupDateFormat(t, col));
        ArrayList<Date> l = new ArrayList<Date>();
        for (String[] s : t.rows()) {
            l.add(Conversions.convert(s[col], Date.class, p));
        }
        return l.toArray(new Date[0]);
    }

    public static Double[] getColumnDoubleValues(CSTable t, String columnName) {
        int col = DataIO.columnIndex(t, columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        ArrayList<Double> l = new ArrayList<Double>();
        for (String[] s : t.rows()) {
            l.add(new Double(s[col]));
        }
        return l.toArray(new Double[0]);
    }

    public static Date getDate(CSProperties p, String key) throws ParseException {
        String val = p.get(key).toString();
        if (val == null) {
            throw new IllegalArgumentException(key);
        }
        String f = p.getInfo(key).get(KEY_FORMAT);
        SimpleDateFormat fmt = new SimpleDateFormat(f == null ? ISO8601 : f);
        return fmt.parse(val);
    }

    public static int getInt(CSProperties p, String key) throws ParseException {
        String val = p.get(key).toString();
        if (val == null) {
            throw new IllegalArgumentException(key);
        }
        return Integer.parseInt(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(CSProperties csp, File f, String title) {
        PrintWriter w = null;
        try {
            if (csp instanceof BasicCSProperties) {
                BasicCSProperties c = (BasicCSProperties)csp;
                c.setName(title);
            }
            w = new PrintWriter(f);
            DataIO.print(csp, w);
            w.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public static void print(CSProperties props, PrintWriter out) {
        out.println("@S," + CSVParser.printLine(props.getName()));
        for (String key : props.getInfo().keySet()) {
            out.println(" " + CSVParser.printLine(key, props.getInfo().get(key)));
        }
        out.println();
        for (String key : props.keySet()) {
            out.println("@P," + CSVParser.printLine(key, props.get(key).toString()));
            for (String key1 : props.getInfo(key).keySet()) {
                out.println(" " + CSVParser.printLine(key1, props.getInfo(key).get(key1)));
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public static void print(Map<String, Object> props, String header, PrintWriter out) {
        out.println("@S," + header);
        out.println();
        for (String key : props.keySet()) {
            out.println("@P," + CSVParser.printLine(key, props.get(key).toString()));
        }
        out.println();
        out.flush();
    }

    public static void print(CSTable table, PrintWriter out) {
        int i;
        out.println("@T," + CSVParser.printLine(table.getName()));
        for (String key : table.getInfo().keySet()) {
            out.println(CSVParser.printLine(key, table.getInfo().get(key)));
        }
        if (table.getColumnCount() < 1) {
            out.flush();
            return;
        }
        out.print(HEADER);
        for (int i2 = 1; i2 <= table.getColumnCount(); ++i2) {
            out.print("," + table.getColumnName(i2));
        }
        out.println();
        Map<String, String> m = table.getColumnInfo(1);
        for (String key : m.keySet()) {
            out.print(key);
            for (i = 1; i <= table.getColumnCount(); ++i) {
                out.print("," + table.getColumnInfo(i).get(key));
            }
            out.println();
        }
        for (String[] row : table.rows()) {
            for (i = 1; i < row.length; ++i) {
                out.print("," + row[i]);
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public static void save(CSTable table, File file) throws IOException {
        PrintWriter w = new PrintWriter(file);
        DataIO.print(table, w);
        w.close();
    }

    public static CSProperties properties(Reader r, String name) throws IOException {
        return new CSVProperties(r, name);
    }

    public static CSProperties properties(Reader[] r, String name) throws IOException {
        CSVProperties p = new CSVProperties(r[0], name);
        for (int i = 1; i < r.length; ++i) {
            CSVParser csv = new CSVParser(r[i], CSVStrategy.DEFAULT_STRATEGY);
            DataIO.locate(csv, name, PROPERTIES, PROPERTIES1);
            p.readProps(csv);
            r[i].close();
        }
        return p;
    }

    public static void merge(CSProperties base, CSProperties overlay) {
        for (String key : overlay.keySet()) {
            if (base.getInfo(key).containsKey("public")) {
                base.put(key, overlay.get(key));
                continue;
            }
            throw new IllegalArgumentException("Not public: " + key);
        }
    }

    public static Properties properties(CSProperties p) {
        Properties pr = new Properties();
        pr.putAll((Map<?, ?>)p);
        return pr;
    }

    public static CSProperties properties(Properties p) {
        return new BasicCSProperties(p);
    }

    public static CSProperties properties(Map<String, Object> p) {
        return new BasicCSProperties(p);
    }

    public static CSProperties properties() {
        return new BasicCSProperties();
    }

    public static CSTable table(File file) throws IOException {
        return DataIO.table(file, null);
    }

    public static CSTable table(File file, String name) throws IOException {
        return new FileTable(file, name);
    }

    public static CSTable table(String s) throws IOException {
        return DataIO.table(s, null);
    }

    public static CSTable table(String s, String name) throws IOException {
        return new StringTable(s, name);
    }

    public static CSTable table(URL url) throws IOException {
        return DataIO.table(url, null);
    }

    public static CSTable table(URL url, String name) throws IOException {
        return new URLTable(url, name);
    }

    public static boolean columnExist(CSTable table, String name) {
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public static int columnIndex(CSTable table, String name) {
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static int[] columnIndexes(CSTable table, String name) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).startsWith(name)) continue;
            l.add(i);
        }
        if (l.isEmpty()) {
            return null;
        }
        int[] idx = new int[l.size()];
        for (int i = 0; i < idx.length; ++i) {
            idx[i] = (Integer)l.get(i);
        }
        return idx;
    }

    public static List<String> columnNames(CSTable table, String name) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 1; i <= table.getColumnCount(); ++i) {
            if (!table.getColumnName(i).startsWith(name)) continue;
            l.add(table.getColumnName(i));
        }
        if (l.isEmpty()) {
            throw new IllegalArgumentException("No column(s) '" + name + "' in table: " + table.getName());
        }
        return l;
    }

    public static void rowStringValues(String[] row, int[] idx, String[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = row[idx[i]];
        }
    }

    public static double[] rowDoubleValues(String[] row, int[] idx, double[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Double.parseDouble(row[idx[i]]);
        }
        return vals;
    }

    public static double[] rowDoubleValues(String[] row, int[] idx) {
        double[] vals = new double[idx.length];
        return DataIO.rowDoubleValues(row, idx, vals);
    }

    public static CSTable extractColumns(CSTable table, String ... colNames) {
        int[] idx = new int[]{};
        for (String name : colNames) {
            idx = DataIO.add(idx, DataIO.columnIndexes(table, name));
        }
        if (idx.length == 0) {
            throw new IllegalArgumentException("No such column names: " + Arrays.toString(colNames));
        }
        ArrayList<String> cols = new ArrayList<String>();
        for (String name : colNames) {
            cols.addAll(DataIO.columnNames(table, name));
        }
        MemoryTable t = new MemoryTable();
        t.setName(table.getName());
        t.getInfo().putAll(table.getInfo());
        t.setColumns(cols.toArray(new String[0]));
        for (int i = 0; i < idx.length; ++i) {
            t.getColumnInfo(i + 1).putAll(table.getColumnInfo(idx[i]));
        }
        String[] r = new String[idx.length];
        for (String[] row : table.rows()) {
            DataIO.rowStringValues(row, idx, r);
            t.addRow(r);
        }
        return t;
    }

    public static String diff(double[] o, double[] p) {
        String status = "ok.";
        if (o.length != p.length) {
            status = "o.length != p.length";
        } else {
            for (int i = 0; i < o.length; ++i) {
                if (o[i] == p[i]) continue;
                status = status + "error";
            }
        }
        return status;
    }

    public static CSTable asTable(CSProperties p, String dim) {
        List<String> arrays = DataIO.keysByMeta(p, "bound", dim);
        if (arrays.isEmpty()) {
            return null;
        }
        int len = 0;
        ArrayList<String[]> m = new ArrayList<String[]>();
        for (String arr : arrays) {
            String[] d = Conversions.convert(p.get(arr), String[].class);
            len = d.length;
            m.add(d);
        }
        MemoryTable table = new MemoryTable();
        table.getInfo().put("info", "Parameter bound by " + dim);
        table.setName(dim);
        table.setColumns(arrays.toArray(new String[m.size()]));
        String[] row = new String[m.size()];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < m.size(); ++j) {
                row[j] = ((String[])m.get(j))[i].trim();
            }
            table.addRow(row);
        }
        return table;
    }

    public static CSProperties fromTable(CSTable t) {
        BasicCSProperties p = new BasicCSProperties();
        HashMap table = new HashMap();
        for (int i = 1; i <= t.getColumnCount(); ++i) {
            table.put(i, new ArrayList());
        }
        for (String[] row : t.rows()) {
            for (int i = 1; i < row.length; ++i) {
                ((List)table.get(i)).add(row[i]);
            }
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("bound", t.getName());
        for (int i = 1; i <= t.getColumnCount(); ++i) {
            String name = t.getColumnName(i);
            p.put(name, ((List)table.get(i)).toString().replace('[', '{').replace(']', '}'));
            p.setInfo(name, m);
        }
        return p;
    }

    public static List<String> tables(File f) throws IOException {
        return DataIO.findCSVElements(f, TABLE);
    }

    public static List<String> properties(File f) throws IOException {
        return DataIO.findCSVElements(f, PROPERTIES);
    }

    static List<String> findCSVElements(File f, String tag) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        FileReader r = new FileReader(f);
        CSVParser csv = new CSVParser(r, CSVStrategy.DEFAULT_STRATEGY);
        String[] line = null;
        while ((line = csv.getLine()) != null) {
            if (line.length != 2 || !line[0].equals(tag)) continue;
            l.add(line[1]);
        }
        ((Reader)r).close();
        return l;
    }

    private static int[] add(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private static String locate(CSVParser csv, String name, String ... type) throws IOException {
        if (name == null) {
            name = ".+";
        }
        Pattern p = Pattern.compile(name);
        String[] line = null;
        while ((line = csv.getLine()) != null) {
            if (line[0].startsWith(COMMENT) || !line[0].startsWith(P)) continue;
            for (String s : type) {
                if (!line[0].equalsIgnoreCase(s) || !p.matcher(line[1].trim()).matches()) continue;
                return line[1];
            }
        }
        throw new IllegalArgumentException("Not found : " + type + ", " + name);
    }

    public static void main(String[] args) throws IOException {
    }

    private static class URLTable
    extends CSVTable {
        URL s;

        URLTable(URL s, String name) throws IOException {
            this.s = s;
            this.init(name);
        }

        @Override
        protected Reader newReader() {
            try {
                return new InputStreamReader(this.s.openStream());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class StringTable
    extends CSVTable {
        String s;

        StringTable(String s, String name) throws IOException {
            this.s = s;
            this.init(name);
        }

        @Override
        protected Reader newReader() {
            return new StringReader(this.s);
        }
    }

    private static class FileTable
    extends CSVTable {
        File f;

        FileTable(File f, String name) throws IOException {
            this.f = f;
            this.init(name);
        }

        @Override
        protected Reader newReader() {
            try {
                return new FileReader(this.f);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static abstract class CSVTable
    implements CSTable {
        Map<Integer, Map<String, String>> info = new HashMap<Integer, Map<String, String>>();
        String name;
        int colCount;
        String[] columnNames;
        int firstline;
        CSVStrategy strategy = CSVStrategy.DEFAULT_STRATEGY;

        private CSVTable() {
        }

        protected abstract Reader newReader();

        protected void init(String tableName) throws IOException {
            CSVParser csv = new CSVParser(this.newReader(), this.strategy);
            this.name = DataIO.locate(csv, tableName, new String[]{DataIO.TABLE, DataIO.TABLE1});
            this.firstline = this.readTableHeader(csv);
        }

        private void skip0(CSVParser csv, int lines) {
            try {
                csv.skipLines(lines);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private String[] readRow(CSVParser csv) {
            try {
                String[] r = csv.getLine();
                return r;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Iterable<String[]> rows() {
            return this.rows(0);
        }

        @Override
        public Iterable<String[]> rows(final int startRow) {
            if (startRow < 0) {
                throw new IllegalArgumentException("startRow<0");
            }
            return new Iterable<String[]>(){

                @Override
                public Iterator<String[]> iterator() {
                    final Reader r = CSVTable.this.newReader();
                    final CSVParser csv = new CSVParser(r, CSVTable.this.strategy);
                    CSVTable.this.skip0(csv, CSVTable.this.firstline);
                    CSVTable.this.skip0(csv, startRow);
                    return new TableIterator<String[]>(){
                        String[] line;
                        int row;
                        {
                            this.line = CSVTable.this.readRow(csv);
                            this.row = startRow;
                        }

                        @Override
                        public void close() throws IOException {
                            r.close();
                        }

                        @Override
                        public boolean hasNext() {
                            boolean hn;
                            boolean bl = hn = this.line != null && this.line.length > 1 && this.line[0].isEmpty();
                            if (!hn) {
                                try {
                                    r.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return hn;
                        }

                        @Override
                        public String[] next() {
                            String[] s = this.line;
                            s[0] = Integer.toString(++this.row);
                            this.line = CSVTable.this.readRow(csv);
                            return s;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void skip(int n) {
                            if (n < 1) {
                                throw new IllegalArgumentException("n<1 : " + n);
                            }
                            CSVTable.this.skip0(csv, n - 1);
                            this.line = CSVTable.this.readRow(csv);
                            this.row += n;
                        }
                    };
                }
            };
        }

        private int readTableHeader(CSVParser csv) throws IOException {
            int i;
            LinkedHashMap<String, String> tableInfo = new LinkedHashMap<String, String>();
            this.info.put(-1, tableInfo);
            String[] line = null;
            while ((line = csv.getLine()) != null && !line[0].equalsIgnoreCase(DataIO.HEADER)) {
                if (line[0].startsWith(DataIO.COMMENT)) continue;
                tableInfo.put(line[0], line.length > 1 ? line[1] : null);
            }
            if (line == null) {
                throw new IOException("Invalid table structure.");
            }
            this.colCount = line.length - 1;
            this.columnNames = new String[line.length];
            this.columnNames[0] = "ROW";
            for (i = 1; i < line.length; ++i) {
                this.columnNames[i] = line[i];
                this.info.put(i, new LinkedHashMap());
            }
            while ((line = csv.getLine()) != null && !line[0].isEmpty()) {
                if (line[0].startsWith(DataIO.COMMENT)) continue;
                for (i = 1; i < line.length; ++i) {
                    this.info.get(i).put(line[0], line[i]);
                }
            }
            assert (line != null && line[0].isEmpty());
            return csv.getLineNumber() - 1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getInfo() {
            return this.getColumnInfo(-1);
        }

        @Override
        public Map<String, String> getColumnInfo(int column) {
            return Collections.unmodifiableMap(this.info.get(column));
        }

        @Override
        public int getColumnCount() {
            return this.colCount;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }
    }

    private static class CSVProperties
    extends BasicCSProperties
    implements CSProperties {
        CSVProperties(Reader reader, String name) throws IOException {
            CSVParser csv = new CSVParser(reader, CSVStrategy.DEFAULT_STRATEGY);
            this.name = DataIO.locate(csv, name, new String[]{DataIO.PROPERTIES, DataIO.PROPERTIES1});
            this.readProps(csv);
            reader.close();
        }

        private void readProps(CSVParser csv) throws IOException {
            HashMap<String, String> propInfo = null;
            String[] line = null;
            String propKey = DataIO.ROOT_ANN;
            while (!((line = csv.getLine()) == null || line[0].equalsIgnoreCase(DataIO.PROPERTIES) || line[0].equalsIgnoreCase(DataIO.PROPERTIES1) || line[0].equalsIgnoreCase(DataIO.TABLE) || line[0].equalsIgnoreCase(DataIO.TABLE1))) {
                if (line[0].startsWith(DataIO.COMMENT) || line[0].isEmpty()) continue;
                if (line[0].equalsIgnoreCase(DataIO.PROPERTY) || line[0].equalsIgnoreCase(DataIO.PROPERTY1)) {
                    if (line.length < 2) {
                        throw new IOException("Expected property name in line " + csv.getLineNumber());
                    }
                    propKey = line[1];
                    this.put(propKey, line.length == 3 ? line[2] : null);
                    propInfo = null;
                    continue;
                }
                if (propInfo == null) {
                    propInfo = new HashMap<String, String>();
                    this.info.put(propKey, propInfo);
                }
                propInfo.put(line[0], line.length > 1 ? line[1] : null);
            }
        }
    }

    private static class BasicCSProperties
    extends LinkedHashMap<String, Object>
    implements CSProperties {
        String name = "";
        Map<String, Map<String, String>> info = new HashMap<String, Map<String, String>>();

        BasicCSProperties(Properties p) {
            this();
            for (Object key : p.keySet()) {
                this.put(key.toString(), p.getProperty(key.toString()));
            }
        }

        BasicCSProperties(Map<String, Object> p) {
            this();
            for (String key : p.keySet()) {
                this.put(key, p.get(key));
            }
        }

        BasicCSProperties() {
            this.info.put(DataIO.ROOT_ANN, new HashMap());
        }

        @Override
        public void putAll(CSProperties p) {
            super.putAll(p);
            for (String s : p.keySet()) {
                Map<String, String> m = p.getInfo(s);
                this.setInfo(s, m);
            }
            this.getInfo().putAll(p.getInfo());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public Map<String, String> getInfo(String property) {
            Map<String, String> im = this.info.get(property);
            return im == null ? NOINFO : im;
        }

        @Override
        public Map<String, String> getInfo() {
            return this.getInfo(DataIO.ROOT_ANN);
        }

        @Override
        public void setInfo(String propertyname, Map<String, String> inf) {
            this.info.put(propertyname, inf);
        }

        @Override
        public String get(Object key) {
            Object val = super.get(key.toString());
            return this.resolve(val != null ? val.toString() : null);
        }

        private String resolve(String str) {
            if (str != null && str.contains("${")) {
                Matcher ma = null;
                while ((ma = varPattern.matcher(str)).find()) {
                    String key = ma.group(1);
                    String val = this.get(key);
                    if (val == null) {
                        throw new IllegalArgumentException("value substitution failed for " + key);
                    }
                    Pattern repl = Pattern.compile("\\$\\{" + key + "\\}");
                    str = repl.matcher(str).replaceAll(val);
                }
            }
            return str;
        }
    }
}

