/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.esp;

import java.io.File;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import ngmf.util.OutputStragegy;
import oms3.ComponentAccess;
import oms3.Compound;
import oms3.Conversions;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;
import oms3.dsl.AbstractSimulation;
import oms3.dsl.Buildable;
import oms3.io.CSProperties;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.util.Times;

public class Esp
extends AbstractSimulation {
    int first_year;
    int last_year;
    int fc;
    Calendar fc_end;

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("forecast_end")) {
            Date d = Conversions.convert(value, Date.class);
            this.fc_end = new GregorianCalendar();
            this.fc_end.setTime(d);
        } else if (name.equals("forecast_days")) {
            this.fc = (Integer)value;
            if (this.fc < 1) {
                throw new IllegalArgumentException("forecast_days < 1");
            }
        } else if (name.equals("first_year")) {
            this.first_year = (Integer)value;
        } else if (name.equals("last_year")) {
            this.last_year = (Integer)value;
        } else {
            return super.create(name, value);
        }
        return LEAF;
    }

    @Override
    public Object run() throws Exception {
        Compound.reload();
        Logger.getLogger("oms3.model").setLevel(Level.WARNING);
        if (this.getModel() == null) {
            throw new IllegalArgumentException("missing model definition.");
        }
        GregorianCalendar now = new GregorianCalendar();
        int thisYear = now.get(1);
        if (this.fc == 0 && this.fc_end == null) {
            throw new IllegalArgumentException("set either 'forecast_days' or 'forecast_end'");
        }
        if (this.fc > 0 && this.fc_end != null) {
            throw new IllegalArgumentException("set 'forecast_days' or 'forecast_end', not both");
        }
        if (this.fc_end == null && (this.fc > 366 || this.fc < 1)) {
            throw new IllegalArgumentException("forecast_days: 1...366");
        }
        if (this.first_year < 1900 || this.last_year < 1900 || this.first_year >= this.last_year || this.first_year > thisYear || this.last_year > thisYear) {
            throw new IllegalArgumentException("invalid/missing first_year or/and last_year!");
        }
        OutputStragegy st = this.getOutput().getOutputStrategy(this.getName());
        File lastFolder = st.nextOutputFolder();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Simulation output folder: " + lastFolder);
        }
        lastFolder.mkdirs();
        PrintWriter res = new PrintWriter(new File(lastFolder, "result.csv"));
        res.println("@S, Result");
        Calendar start = null;
        Calendar end = null;
        System.out.print(" Running ESP Traces ");
        for (int year = this.first_year; year <= this.last_year; ++year) {
            System.out.print(" " + year);
            Object comp = this.getModel().getComponent();
            log.config("Init ...");
            ComponentAccess.callAnnotated(comp, Initialize.class, true);
            CSProperties parameter = this.getModel().getParameter();
            boolean success = ComponentAccess.setInputData(parameter, comp, log);
            if (!success) {
                System.out.println("There are Parameter problems. Simulation exits.");
                return null;
            }
            boolean adjusted = ComponentAccess.adjustOutputPath(lastFolder, comp, log);
            if (adjusted) {
                lastFolder.mkdirs();
            }
            start = (Calendar)comp.getClass().getField("startTime").get(comp);
            end = (Calendar)comp.getClass().getField("endTime").get(comp);
            File input_file = (File)comp.getClass().getField("inputFile").get(comp);
            File out_file = (File)comp.getClass().getField("outFile").get(comp);
            if (start.after(end)) {
                throw new IllegalArgumentException("illegal startTime/endTime.");
            }
            if (this.fc == 0) {
                this.fc = (int)Times.diffDayPeriods(end, this.fc_end);
            } else {
                this.fc_end = new GregorianCalendar();
                this.fc_end.setTime(end.getTime());
                this.fc_end.add(5, this.fc);
            }
            CSTable t = DataIO.table(input_file, "obs");
            CSTable esp = DataIO.synthESPInput(t, start.getTime(), end.getTime(), this.fc, year);
            File new_input_file = new File(lastFolder, "esp-" + year + "-" + input_file.getName());
            PrintWriter w = new PrintWriter(new_input_file);
            DataIO.print(esp, w);
            w.close();
            File new_outFile = new File(out_file.getParent(), "esp-" + year + "-" + out_file.getName());
            comp.getClass().getField("inputFile").set(comp, new_input_file);
            comp.getClass().getField("outFile").set(comp, new_outFile);
            comp.getClass().getField("endTime").set(comp, this.fc_end);
            log.config("Exec ...");
            ComponentAccess.callAnnotated(comp, Execute.class, false);
            log.config("Finalize ...");
            ComponentAccess.callAnnotated(comp, Finalize.class, true);
            res.println(" trace." + year + ", \"" + new_outFile.toString() + "\"");
        }
        res.println(" initstart, " + Conversions.formatISO(start.getTime()));
        res.println(" initend, " + Conversions.formatISO(end.getTime()));
        res.println(" forecastend, " + Conversions.formatISO(this.fc_end.getTime()));
        res.println(" firstyear, " + this.first_year);
        res.println(" lastyear, " + this.last_year);
        res.close();
        System.out.println();
        Compound.shutdown();
        return null;
    }
}

