/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ngmf.util.cosu.luca.ExecutionHandle;
import ngmf.util.cosu.luca.ParameterData;
import oms3.Conversions;
import oms3.dsl.Buildable;
import oms3.dsl.Param;
import oms3.dsl.Params;
import oms3.dsl.cosu.Calibration;
import oms3.dsl.cosu.Luca;
import oms3.dsl.cosu.ObjFunc;

public class Step
implements Buildable {
    String name;
    Params params = new Params();
    int NumOfParams = 0;
    int maxExec = 10000;
    int initComplexes = 2;
    int minComplexes = 1;
    int pointsPerComplex = -1;
    int pointsPerSubcomplex = -1;
    int evolutions = -1;
    int shufflingLoops = 5;
    double ofPercentage = 0.01;
    int number;
    List<ObjFunc> ofs = new ArrayList<ObjFunc>();
    Data[] r;
    Date calibStart;
    Date calibEnd;
    File outFolder;

    Step(int number) {
        this.number = number;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name == null ? Integer.toString(this.number) : this.name;
    }

    public int getInitComplexes() {
        return this.initComplexes;
    }

    public int getMaxExec() {
        return this.maxExec;
    }

    public int getMinComplexes() {
        return this.minComplexes;
    }

    public int getEvolutions() {
        return this.evolutions > -1 ? this.evolutions : this.NumOfParams * 2 + 1;
    }

    public int getPointsPerComplex() {
        return this.pointsPerComplex > -1 ? this.pointsPerComplex : this.NumOfParams * 2 + 1;
    }

    public int getPointsPerSubcomplex() {
        return this.pointsPerSubcomplex > -1 ? this.pointsPerComplex : this.NumOfParams + 1;
    }

    public double getOfPercentage() {
        return this.ofPercentage;
    }

    public int getShufflingLoops() {
        return this.shufflingLoops;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("max_exec")) {
            this.maxExec = (Integer)value;
            if (this.maxExec < 1) {
                throw new IllegalArgumentException("max_exec: " + this.maxExec);
            }
        } else if (name.equals("init_complexes")) {
            this.initComplexes = (Integer)value;
            if (this.initComplexes < 1) {
                throw new IllegalArgumentException("init_complexes: " + this.initComplexes);
            }
        } else if (name.equals("points_per_complex")) {
            this.pointsPerComplex = (Integer)value;
        } else if (name.equals("points_per_subcomplex")) {
            this.pointsPerSubcomplex = (Integer)value;
        } else if (name.equals("evolutions")) {
            this.evolutions = (Integer)value;
        } else if (name.equals("min_complexes")) {
            this.minComplexes = (Integer)value;
            if (this.minComplexes < 1) {
                throw new IllegalArgumentException("minComplexes: " + this.minComplexes);
            }
        } else if (name.equals("shuffling_loops")) {
            this.shufflingLoops = (Integer)value;
            if (this.shufflingLoops < 1) {
                throw new IllegalArgumentException("shufflingLoops: " + this.shufflingLoops);
            }
        } else if (name.equals("of_percentage")) {
            this.ofPercentage = Conversions.convert(value, Double.class);
            if (this.ofPercentage <= 0.0 || this.ofPercentage > 1.0) {
                throw new IllegalArgumentException("of_percentage: " + this.ofPercentage);
            }
        } else {
            if (name.equals("parameter")) {
                return this.params;
            }
            if (name.equals("objfunc")) {
                ObjFunc of = new ObjFunc();
                this.ofs.add(of);
                return of;
            }
            throw new IllegalArgumentException(name.toString());
        }
        return LEAF;
    }

    public Params params() {
        return this.params;
    }

    public boolean needsToStopSCE() {
        return false;
    }

    public void setStatus(String string) {
    }

    public Data[] round() {
        return this.r;
    }

    void post(int round, Data step) {
        for (int i = round + 1; i < this.r.length; ++i) {
            Data.copyParamValues(step, this.r[i]);
        }
    }

    void init(Luca.ModelExecution model, Date calibStart, Date calibEnd, int rounds) throws IOException {
        this.calibStart = calibStart;
        this.calibEnd = calibEnd;
        this.outFolder = model.lastFolder;
        this.r = new Data[rounds];
        ParameterData[] p = Step.create(this.params(), model.getParameter());
        for (int i = 0; i < rounds; ++i) {
            this.r[i] = new Data();
            this.r[i].round = i;
            this.r[i].init(p);
            this.r[i].createBestParamData();
            this.NumOfParams += this.r[i].getParamValues().length;
        }
    }

    public static ParameterData[] create(Params params, Map<String, Object> modelparams) {
        ParameterData[] paramData = new ParameterData[params.getCount()];
        for (int i = 0; i < paramData.length; ++i) {
            Param p = params.getParam().get(i);
            Calibration calib = p.getCalibration();
            String pname = p.getName();
            Object pval = modelparams.get(pname);
            if (pval == null) {
                throw new RuntimeException("Paramter not found '" + pname + "'");
            }
            if (pval.toString().indexOf(123) == -1 && pval.toString().indexOf(125) == -1) {
                pval = '{' + pval.toString() + '}';
            }
            double[] pv = Conversions.convert(pval, double[].class);
            boolean[] calibrate = calib.getCalibrateFlags(pv.length);
            double lower = p.getLower();
            double upper = p.getUpper();
            if (Double.isNaN(upper)) {
                throw new IllegalArgumentException("'upper' not set:" + pname);
            }
            if (Double.isNaN(lower)) {
                throw new IllegalArgumentException("'lower' not set:" + pname);
            }
            if (lower > upper) {
                throw new IllegalArgumentException("'lower' > 'upper' :" + pname);
            }
            paramData[i] = new ParameterData(pname);
            paramData[i].set(pv, lower, upper, calib.getStrategyAsInt(), calibrate);
        }
        return paramData;
    }

    public boolean maximizeObjectiveFunctionValue() {
        return ObjFunc.isInc(this.ofs);
    }

    public double calculateObjectiveFunctionValue(ExecutionHandle executionHandle) {
        return ObjFunc.calculateObjectiveFunctionValue(this.ofs, this.calibStart, this.calibEnd, this.outFolder);
    }

    public static class Data {
        int round;
        double bestOFPoint;
        double[] upperBound;
        double[] lowerBound;
        double[] paramValues;
        ParameterData[] paramData;
        ParameterData[] bestParamData;

        public void createBestParamData() {
            this.bestParamData = new ParameterData[this.paramData.length];
            for (int i = 0; i < this.bestParamData.length; ++i) {
                this.bestParamData[i] = new ParameterData(this.paramData[i]);
            }
        }

        void init(ParameterData[] params) {
            ParameterData[] pd = new ParameterData[params.length];
            for (int i = 0; i < params.length; ++i) {
                pd[i] = new ParameterData(params[i]);
            }
            this.setParameterData(pd);
            int numOfParams = 0;
            for (int i = 0; i < this.paramData.length; ++i) {
                numOfParams += this.paramData[i].getCalibrationDataSize();
            }
            this.paramValues = new double[numOfParams];
            this.lowerBound = new double[numOfParams];
            this.upperBound = new double[numOfParams];
            int index = 0;
            for (int i = 0; i < this.paramData.length; ++i) {
                double[] values = this.paramData[i].getCalibrationData();
                for (int j = 0; j < values.length; ++j) {
                    this.paramValues[index] = values[j];
                    this.lowerBound[index] = this.paramData[i].getLowerBound();
                    this.upperBound[index] = this.paramData[i].getUpperBound();
                    ++index;
                }
            }
            this.bestOFPoint = 0.0;
        }

        public void setObjFuncValueOfBestPoint(double d) {
            this.bestOFPoint = d;
        }

        public double getObjFuncValueOfBestPoint() {
            return this.bestOFPoint;
        }

        public void setParameterData(ParameterData[] paramData) {
            this.paramData = paramData;
        }

        public void setParamValues(double[] paramValues) {
            this.paramValues = paramValues;
            int index = 0;
            for (int i = 0; i < this.paramData.length; ++i) {
                double[] data = new double[this.paramData[i].getCalibrationDataSize()];
                if (paramValues.length < data.length) {
                    throw new RuntimeException("CalibrationDataSize = " + this.paramData[i].getCalibrationDataSize() + ";  but paramValues.length = " + paramValues.length);
                }
                for (int j = 0; j < data.length; ++j) {
                    data[j] = paramValues[index];
                    ++index;
                }
                this.paramData[i].generateValues(data);
            }
        }

        public void setBestParamData(double[] bestParamValues, double bestOFPoint) {
            this.bestOFPoint = bestOFPoint;
            this.setBestParamData(bestParamValues);
        }

        public void setBestParamData(double[] bestParamValues) {
            int index = 0;
            for (int i = 0; i < this.bestParamData.length; ++i) {
                double[] data = new double[this.bestParamData[i].getCalibrationDataSize()];
                for (int j = 0; j < data.length; ++j) {
                    data[j] = bestParamValues[index];
                    ++index;
                }
                this.bestParamData[i].generateValues(data);
            }
        }

        public double[] getBestParamDataArray() {
            double[] bestParamValues = new double[this.paramValues.length];
            int index = 0;
            for (int i = 0; i < this.bestParamData.length; ++i) {
                double[] values = this.bestParamData[i].getCalibrationData();
                for (int j = 0; j < values.length; ++j) {
                    bestParamValues[index] = values[j];
                    ++index;
                }
            }
            return bestParamValues;
        }

        public double[] getUpperBound() {
            return this.upperBound;
        }

        public double[] getLowerBound() {
            return this.lowerBound;
        }

        public double[] getParamValues() {
            return this.paramValues;
        }

        public static void copyParamValues(Data source, Data dest) {
            double[] paramValueArray = new double[source.getParamValues().length];
            for (int i = 0; i < paramValueArray.length; ++i) {
                paramValueArray[i] = source.getParamValues()[i];
            }
            dest.setParamValues(paramValueArray);
            dest.setBestParamData(paramValueArray);
        }
    }
}

