/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import ngmf.util.cosu.luca.of.AbsoluteDifference;
import ngmf.util.cosu.luca.of.AbsoluteDifferenceLog;
import ngmf.util.cosu.luca.of.NashSutcliffe;
import ngmf.util.cosu.luca.of.NormalizedRMSE;
import ngmf.util.cosu.luca.of.PearsonsCorrelation;
import oms3.ObjectiveFunction;
import oms3.dsl.Buildable;
import oms3.dsl.cosu.CSVColumn;
import oms3.io.CSTable;
import oms3.io.DataIO;

public class ObjFunc
implements Buildable {
    double weight = Double.NaN;
    String timestep = "daily";
    ObjectiveFunction of;
    CSVColumn sim;
    CSVColumn obs;

    public CSVColumn getSimulated() {
        if (this.sim == null) {
            throw new IllegalArgumentException("Missing 'sim' argument");
        }
        return this.sim;
    }

    public CSVColumn getObserved() {
        if (this.obs == null) {
            throw new IllegalArgumentException("Missing 'obs' argument");
        }
        return this.obs;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("sim")) {
            this.sim = new CSVColumn();
            return this.sim;
        }
        if (name.equals("obs")) {
            this.obs = new CSVColumn();
            return this.obs;
        }
        throw new IllegalArgumentException(name.toString());
    }

    public void setMethod(String method) {
        if (method.equals("ns1 ")) {
            this.of = new NashSutcliffe();
        } else if (method.equals("rmse ")) {
            this.of = new NormalizedRMSE();
        } else if (method.equals("absdif ")) {
            this.of = new AbsoluteDifference();
        } else if (method.equals("logabsdif ")) {
            this.of = new AbsoluteDifferenceLog();
        } else if (method.equals("pmcc ")) {
            this.of = new PearsonsCorrelation();
        } else {
            try {
                Class<?> c = Class.forName(method);
                this.of = (ObjectiveFunction)c.newInstance();
            }
            catch (Exception E) {
                throw new IllegalArgumentException("No such method: " + method);
            }
        }
    }

    public void setTimestep(String timestep) {
        if (!(timestep.equals("daily") || timestep.equals("daily_mean") || timestep.equals("monthly_mean") || timestep.equals("mean_monthly") || timestep.equals("period_maximum") || timestep.equals("period_maximum") || timestep.equals("period_mininum") || timestep.equals("period_median") || timestep.equals("period_standard_deviation"))) {
            throw new IllegalArgumentException("SetTimeStep:  Illegal timestep: " + timestep);
        }
        this.timestep = timestep;
    }

    public void setWeight(double weight) {
        if (weight <= 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("of weight out of range: " + weight);
        }
        this.weight = weight;
    }

    String getTimestep() {
        return this.timestep;
    }

    double getWeight() {
        return this.weight;
    }

    ObjectiveFunction getOF() {
        if (this.of == null) {
            throw new IllegalArgumentException("No Objective function method defined.");
        }
        return this.of;
    }

    public static boolean isInc(List<ObjFunc> ofs) {
        if (ofs.isEmpty()) {
            throw new IllegalArgumentException("No Objective function(s) defined. ");
        }
        boolean inc = ofs.get(0).getOF().positiveDirection();
        for (ObjFunc of : ofs) {
            if (of.getOF().positiveDirection() == inc) continue;
            throw new IllegalArgumentException("Objective function(s) optimization direction mismatch!");
        }
        return inc;
    }

    public static void adjustWeights(List<ObjFunc> ofs) {
        int noOf = ofs.size();
        for (ObjFunc of : ofs) {
            if (!Double.isNaN(of.getWeight())) continue;
            of.setWeight(1.0 / (double)noOf);
        }
    }

    public static double calculateObjectiveFunctionValue(List<ObjFunc> ofs, Date start, Date end, File folder) {
        try {
            if (ofs.isEmpty()) {
                throw new IllegalArgumentException("No Objective function(s) defined. ");
            }
            double val = 0.0;
            double weight = 0.0;
            ObjFunc.adjustWeights(ofs);
            for (ObjFunc of : ofs) {
                CSVColumn obs = of.getObserved();
                String timeStepString = of.getTimestep();
                int timeStep = 0;
                if (timeStepString.equals("daily")) {
                    timeStep = 0;
                } else if (timeStepString.equals("mean_monthly")) {
                    timeStep = 1;
                } else if (timeStepString.equals("monthly_mean")) {
                    timeStep = 2;
                } else if (timeStepString.equals("annual_mean")) {
                    timeStep = 3;
                } else if (timeStepString.equals("period_mean")) {
                    timeStep = 4;
                } else if (timeStepString.equals("period_median")) {
                    timeStep = 5;
                } else if (timeStepString.equals("period_mininum")) {
                    timeStep = 7;
                } else if (timeStepString.equals("period_maximum")) {
                    timeStep = 8;
                } else if (timeStepString.equals("period_standard_deviation")) {
                    timeStep = 6;
                } else {
                    throw new IllegalArgumentException("TimeStep " + timeStepString + "unknown.");
                }
                CSTable tobs = DataIO.table(ObjFunc.resolve(obs.getFile(), folder), obs.getTable());
                double[] obsval = DataIO.getColumnDoubleValuesInterval(start, end, tobs, obs.getColumn(), timeStep);
                CSVColumn sim = of.getSimulated();
                CSTable tsim = DataIO.table(ObjFunc.resolve(sim.getFile(), folder), sim.getTable());
                double[] simval = DataIO.getColumnDoubleValuesInterval(start, end, tsim, sim.getColumn(), timeStep);
                weight += of.getWeight();
                val += of.getOF().calculate(obsval, simval, -90.0) * of.getWeight();
            }
            if (weight != 1.0) {
                throw new IllegalArgumentException("sum of of weights != 1.0");
            }
            return val;
        }
        catch (IOException E) {
            throw new RuntimeException(E);
        }
    }

    private static File resolve(String file, File out) {
        File f = new File(file);
        if (!f.isAbsolute() || !f.exists()) {
            f = new File(out, file);
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File not found: " + file);
        }
        return f;
    }
}

