/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ngmf.util.OutputStragegy;
import ngmf.util.cosu.luca.ParameterData;
import oms3.ComponentAccess;
import oms3.Conversions;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;
import oms3.dsl.AbstractSimulation;
import oms3.dsl.Buildable;
import oms3.dsl.Model;
import oms3.dsl.Output;
import oms3.dsl.Param;
import oms3.dsl.Params;
import oms3.dsl.cosu.ObjFunc;
import oms3.dsl.cosu.Step;
import oms3.io.CSProperties;

public class DDS
extends AbstractSimulation {
    int samples = 2000;
    int terms = 4;
    Params params = new Params();
    Date sens_start;
    Date sens_end;
    List<ObjFunc> ofs = new ArrayList<ObjFunc>();

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("parameter")) {
            return this.params;
        }
        if (name.equals("objfunc")) {
            ObjFunc of = new ObjFunc();
            this.ofs.add(of);
            return of;
        }
        if (name.equals("samples")) {
            this.samples = (Integer)value;
        } else if (name.equals("terms")) {
            this.terms = (Integer)value;
            if (this.terms != 4 && this.terms != 6) {
                throw new IllegalArgumentException("terms 4 or 6 !");
            }
        } else if (name.equals("sens_start")) {
            this.sens_start = Conversions.convert(value, Date.class);
        } else if (name.equals("sens_end")) {
            this.sens_end = Conversions.convert(value, Date.class);
        } else {
            return super.create(name, value);
        }
        return LEAF;
    }

    @Override
    public Object run() throws Exception {
        OutputStragegy st = this.getOutput().getOutputStrategy(this.getName());
        File lastFolder = st.nextOutputFolder();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Simulation output folder: " + lastFolder);
        }
        lastFolder.mkdirs();
        Logger.getLogger("oms3.model").setLevel(Level.WARNING);
        ObjFunc.adjustWeights(this.ofs);
        this.run(this.getModel(), this.getOut(), lastFolder, this.getName());
        return null;
    }

    void run(Model model, List<Output> out, File folder, String name) throws Exception {
        int i;
        int i2;
        List<Param> pList = this.params.getParam();
        int npar = this.params.getCount();
        int N = this.samples;
        double M = this.terms;
        double wi = Math.floor((double)N / (2.0 * M));
        double m2 = Math.floor(wi / (2.0 * M));
        double r = Math.floor(m2 / (double)npar);
        double[] w = new double[npar];
        if (r < 1.0) {
            for (int i3 = 0; i3 < npar; ++i3) {
                w[i3] = 1.0;
            }
        } else {
            double t = Math.floor(m2 / (double)npar);
            w[0] = 1.0;
            for (i2 = 1; i2 < npar; ++i2) {
                w[i2] = 1.0 + (double)i2 * t;
            }
        }
        int k1 = 0;
        double[][] w2 = new double[npar][w.length];
        for (i2 = 0; i2 < npar; ++i2) {
            for (int j = 0; j < w.length; ++j) {
                w2[i2][j] = j == k1 ? wi : w[j];
            }
            ++k1;
        }
        double inc = Math.PI * 2 / (double)N;
        double[] s = new double[N];
        s[0] = -Math.PI;
        for (int i4 = 1; i4 < s.length; ++i4) {
            s[i4] = s[i4 - 1] + inc;
        }
        double[][] x = new double[N][npar];
        double[] y = new double[N];
        double[] V2 = new double[npar];
        double[] VT = new double[npar];
        double[] Ak = new double[(int)Math.floor((N - 1) / 2)];
        double[] Bk = new double[(int)Math.floor((N - 1) / 2)];
        double[] S_par = new double[npar];
        double[] Vex = new double[npar];
        double[] Sex_par = new double[npar];
        for (int h = 0; h < npar; ++h) {
            for (int j = 0; j < N; ++j) {
                for (int i5 = 0; i5 < npar; ++i5) {
                    double p = 0.5 + Math.asin(Math.sin(w2[h][i5] * s[j])) / Math.PI;
                    Param par = pList.get(i5);
                    x[j][i5] = p * (par.getUpper() - par.getLower()) + par.getLower();
                }
                y[j] = this.run_model(model, out, folder, name, x[j]);
                System.out.println("par:" + h + " N:" + j + " of:" + y[j]);
            }
            V2[h] = 0.0;
            for (int k = 1; k <= (N - 1) / 2; ++k) {
                double A = 0.0;
                double B = 0.0;
                for (int j = 0; j < N; ++j) {
                    A += y[j] * Math.cos(s[j] * (double)k);
                    B += y[j] * Math.sin(s[j] * (double)k);
                }
                double ak = A * 2.0 / (double)N;
                double bk = B * 2.0 / (double)N;
                Ak[k - 1] = ak;
                Bk[k - 1] = bk;
                int n = h;
                V2[n] = V2[n] + (ak * ak + bk * bk);
            }
            VT[h] = V2[h] / 2.0;
            V2[h] = 0.0;
            int q = 1;
            while ((double)q <= M) {
                int idx = (int)((double)q * w2[h][h]) - 1;
                int n = h;
                V2[n] = V2[n] + (Ak[idx] * Ak[idx] + Bk[idx] * Bk[idx]);
                ++q;
            }
            int n = h;
            V2[n] = V2[n] / 2.0;
            S_par[h] = V2[h] / VT[h];
            Vex[h] = 0.0;
            q = 1;
            while ((double)q <= M) {
                for (int c = 0; c < npar; ++c) {
                    if (c == h) continue;
                    int idx = (int)((double)q * w2[h][c]) - 1;
                    int n2 = h;
                    Vex[n2] = Vex[n2] + (Ak[idx] * Ak[idx] + Bk[idx] * Bk[idx]);
                }
                ++q;
            }
            int n3 = h;
            Vex[n3] = Vex[n3] / 2.0;
            Sex_par[h] = 1.0 - Vex[h] / VT[h];
        }
        System.out.println();
        StringBuilder b = new StringBuilder("Sensitivity");
        for (i = 0; i < pList.size(); ++i) {
            b.append(String.format(Locale.US, "%15s ", pList.get(i).getName()));
        }
        b.append("\n        S          ");
        for (i = 0; i < S_par.length; ++i) {
            b.append(String.format(Locale.US, "%-8.7f   ", S_par[i]));
        }
        b.append("\n       ST          ");
        for (i = 0; i < Sex_par.length; ++i) {
            b.append(String.format(Locale.US, "%-8.7f   ", Sex_par[i]));
        }
        b.append('\n');
        System.out.println(b.toString());
    }

    private double run_model(Model model, List<Output> out, File folder, String simName, double[] x) throws Exception {
        int i;
        CSProperties parameter = model.getParameter();
        Object comp = model.getComponent();
        ParameterData[] pd = Step.create(this.params, parameter);
        for (i = 0; i < pd.length; ++i) {
            pd[i].generateValues(x[i]);
        }
        for (i = 0; i < pd.length; ++i) {
            String name = pd[i].getName();
            double[] val = pd[i].getDataValue();
            parameter.put(name, this.toValue(name, val, parameter));
        }
        ComponentAccess.callAnnotated(comp, Initialize.class, true);
        boolean success = ComponentAccess.setInputData(parameter, comp, log);
        if (!success) {
            throw new RuntimeException("There are Parameter problems. Simulation exits.");
        }
        ComponentAccess.adjustOutputPath(folder, comp, log);
        for (Output e : out) {
            e.setup(comp, folder, simName);
        }
        log.config("Exec ...");
        ComponentAccess.callAnnotated(comp, Execute.class, false);
        log.config("Finalize ...");
        ComponentAccess.callAnnotated(comp, Finalize.class, true);
        for (Output e : out) {
            e.done();
        }
        return ObjFunc.calculateObjectiveFunctionValue(this.ofs, this.sens_start, this.sens_end, folder);
    }

    private Object toValue(String name, double[] vals, Map<String, Object> parameter) {
        Object orig = parameter.get(name);
        if (orig.toString().indexOf(123) > -1) {
            return Conversions.convert(vals, String.class);
        }
        return Double.toString(vals[0]);
    }
}

