/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

import java.util.ArrayList;
import java.util.List;
import oms3.dsl.Buildable;

public class Calibration
implements Buildable {
    String strategy = "mean ";
    String range = "0-*";
    boolean matchColumn = false;
    String file;
    String column;
    String table;

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public void setMatchColumn(boolean matchColumn) {
        this.matchColumn = matchColumn;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    private static List<Integer> parseRange(String range, int max) {
        String[] n;
        ArrayList<Integer> idx = new ArrayList<Integer>();
        for (String s : n = range.split(",")) {
            String[] d = s.split("-");
            int mi = Integer.parseInt(d[0]);
            if (mi < 0 || mi >= max) {
                throw new IllegalArgumentException(range);
            }
            if (d.length == 2) {
                int ma;
                if (d[1].equals("*")) {
                    d[1] = Integer.toString(max - 1);
                }
                if ((ma = Integer.parseInt(d[1])) <= mi || ma >= max || ma < 0) {
                    throw new IllegalArgumentException(range);
                }
                for (int i = mi; i <= ma; ++i) {
                    idx.add(i);
                }
                continue;
            }
            idx.add(mi);
        }
        return idx;
    }

    public String getStrategy() {
        if (this.strategy == null) {
            throw new RuntimeException("Missing strategy.");
        }
        if (!(this.strategy.equals("mean ") || this.strategy.equals("individual") || this.strategy.equals("binary"))) {
            throw new RuntimeException("Strategy " + this.strategy + "unsupported.");
        }
        return this.strategy;
    }

    public String getRange() {
        return this.range;
    }

    public int getStrategyAsInt() {
        if (this.strategy.equals("mean ")) {
            return 1;
        }
        if (this.strategy.equals("individual")) {
            return 2;
        }
        if (this.strategy.equals("binary")) {
            return 3;
        }
        throw new IllegalArgumentException("Calibration strategy " + this.strategy + "not valid.");
    }

    public boolean[] getCalibrateFlags(int length) {
        boolean[] calibrationFlags = new boolean[length];
        List<Object> idx = new ArrayList<Integer>();
        if (length > 1) {
            idx = Calibration.parseRange(this.range, length);
        } else {
            idx.add(1);
        }
        if (!this.matchColumn) {
            for (int i = 0; i < length; ++i) {
                calibrationFlags[i] = idx.contains(i);
            }
        } else {
            throw new IllegalArgumentException("Selecting calibration flags by matching column data is not yet supported.");
        }
        return calibrationFlags;
    }

    public boolean getMatchColumn() {
        return this.matchColumn;
    }

    public String getFile() {
        if (this.file == null) {
            throw new RuntimeException("missing file name.");
        }
        return this.file;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        if (this.column == null) {
            throw new RuntimeException("missing column name.");
        }
        return this.column;
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }
}

