/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import ngmf.ui.graph.ValueSet;
import ngmf.util.OutputStragegy;
import oms3.dsl.Buildable;
import oms3.io.CSTable;
import oms3.io.DataIO;

public class Axis
implements Buildable,
ValueSet {
    String file;
    String table;
    String column;
    String name;
    boolean shape = false;
    boolean line = true;

    public void setLine(boolean line) {
        this.line = line;
    }

    public void setShape(boolean shape) {
        this.shape = shape;
    }

    @Override
    public boolean isLine() {
        return this.line;
    }

    @Override
    public boolean isShape() {
        return this.shape;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }

    Date[] getDates(File st, String simName) throws IOException {
        CSTable t = this.table(st);
        return DataIO.getColumnDateValues(t, this.column);
    }

    @Override
    public Double[] getDoubles(File st, String simName) throws IOException {
        CSTable ty = this.table(st);
        return DataIO.getColumnDoubleValues(ty, this.column);
    }

    private CSTable table(File st) throws IOException {
        File f = new File(this.file);
        if (!f.isAbsolute() || !f.exists()) {
            f = this.file.startsWith("%") ? OutputStragegy.resolve(new File(st, this.file)) : OutputStragegy.resolve(this.file);
        }
        return DataIO.table(f, this.table);
    }

    @Override
    public String getName() {
        return this.name == null ? this.column : this.name;
    }
}

