/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.ComponentException;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;
import oms3.dsl.AbstractSimulation;
import oms3.dsl.Buildable;
import oms3.io.CSProperties;

public class Tests
extends AbstractSimulation {
    static final Logger log = Logger.getLogger("oms3.sim");
    List<TestCase> testCases = new ArrayList<TestCase>();

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("test")) {
            TestCase tc = new TestCase();
            this.testCases.add(tc);
            return tc;
        }
        return super.create(name, value);
    }

    @Override
    public Object run() throws Exception {
        if (this.testCases.isEmpty()) {
            throw new ComponentException("No test(s) to run.");
        }
        for (int i = 0; i < this.testCases.size(); ++i) {
            this.testCases.get(i).run(i);
        }
        return null;
    }

    private static List<String> getfromData(List data, Object comp) {
        ArrayList<String> l = new ArrayList<String>();
        ComponentAccess cp = new ComponentAccess(comp);
        Collection<Access> ins = cp.inputs();
        for (int i = 0; i < data.size(); ++i) {
            Access a;
            if (data.get(i) instanceof String) {
                String name = data.get(i).toString();
                a = Tests.findAccessByName(name, ins);
                if (a == null) {
                    return l;
                }
            } else {
                return l;
            }
            l.add(a.getField().getName());
        }
        return l;
    }

    private static Access findAccessByName(String name, Collection<Access> ins) {
        for (Access access : ins) {
            if (!name.equals(access.getField().getName())) continue;
            return access;
        }
        return null;
    }

    private static Map<String, Object>[] getParamsets(List<String> fnames, List data) {
        int cols = fnames.size();
        if (cols < 1) {
            throw new ComponentException("no field mapping information for test data");
        }
        int rows = data.size() / fnames.size() - 1;
        if (rows < 1) {
            throw new ComponentException("no test data provided.");
        }
        int idx = cols;
        HashMap[] ps = new HashMap[rows];
        for (int r = 0; r < rows; ++r) {
            ps[r] = new HashMap();
            for (int c = 0; c < cols; ++c) {
                ps[r].put(fnames.get(c), data.get(idx++));
                if (idx <= data.size()) continue;
                throw new ComponentException("Invalid test parameter set, check the data size.");
            }
        }
        return ps;
    }

    class TestCase
    implements Buildable {
        String name;
        int count = 1;
        Closure pre;
        Closure post;
        String ignore = null;
        Throwable expected;
        long timeout = 0L;
        boolean rangecheck = false;
        List data;

        TestCase() {
        }

        public void setData(List data) {
            this.data = data;
        }

        public void setTimeout(long timeout) {
            if (timeout < 1L) {
                throw new ComponentException("Illegal timeout value: " + timeout);
            }
            this.timeout = timeout;
        }

        public void setRangecheck(boolean rangecheck) {
            this.rangecheck = rangecheck;
        }

        public void setIgnore(String ignore) {
            this.ignore = ignore;
        }

        public void setExpected(Throwable expected) {
            this.expected = expected;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCount(int count) {
            if (count < 1) {
                throw new ComponentException("Illegal number of test cases: " + count);
            }
            this.count = count;
        }

        public void setPre(Closure pre) {
            this.pre = pre;
        }

        public void setPost(Closure post) {
            this.post = post;
        }

        @Override
        public Buildable create(Object name, Object value) {
            return LEAF;
        }

        private String getTestName(int no) {
            return this.name != null ? this.name : "test-" + no;
        }

        private void run(int testNo) throws Exception {
            if (this.ignore != null) {
                System.out.println(this.getTestName(testNo) + " [ignored: " + this.ignore + "]");
                return;
            }
            System.out.print(this.getTestName(testNo) + " ");
            String libPath = Tests.this.model.getLibpath();
            if (libPath != null) {
                System.setProperty("jna.library.path", libPath);
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Setting jna.library.path to " + libPath);
                }
            }
            final Object comp = Tests.this.model.getComponent();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("TL component " + comp);
            }
            CSProperties parameter = Tests.this.model.getParameter();
            ComponentAccess.setInputData(parameter, comp, log);
            List data_ins = null;
            Map[] ps = null;
            int numruns = this.count;
            if (this.data != null) {
                data_ins = Tests.getfromData(this.data, comp);
                numruns = this.data.size() / data_ins.size() - 1;
                ps = Tests.getParamsets(data_ins, this.data);
            }
            for (int i = 0; i < numruns; ++i) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Test ... " + i);
                }
                try {
                    if (this.data != null) {
                        ComponentAccess.setInputData((Map<String, Object>)ps[i], comp, log);
                    }
                    if (this.pre != null) {
                        if (log.isLoggable(Level.INFO)) {
                            log.info(" Pre ...");
                        }
                        this.pre.call(comp);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info(" Init ...");
                    }
                    ComponentAccess.callAnnotated(comp, Initialize.class, true);
                    if (this.rangecheck) {
                        ComponentAccess.rangeCheck(comp, true, false);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info(" Execute ...");
                    }
                    if (this.timeout > 0L) {
                        ExecutorService service = Executors.newSingleThreadExecutor();
                        Callable<Object> callable = new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                ComponentAccess.callAnnotated(comp, Execute.class, false);
                                return null;
                            }
                        };
                        Future<Object> result = service.submit(callable);
                        service.shutdown();
                        boolean terminated = service.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
                        if (!terminated) {
                            service.shutdownNow();
                        }
                        result.get(0L, TimeUnit.MILLISECONDS);
                    } else {
                        ComponentAccess.callAnnotated(comp, Execute.class, false);
                    }
                    if (this.rangecheck) {
                        ComponentAccess.rangeCheck(comp, false, true);
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info(" Finalize ...");
                    }
                    ComponentAccess.callAnnotated(comp, Finalize.class, true);
                }
                catch (TimeoutException e) {
                    throw new ComponentException(String.format(this.getTestName(testNo) + " timed out after %d milliseconds", this.timeout));
                }
                catch (ComponentException e) {
                    throw e;
                }
                catch (Throwable E) {
                    if (this.expected != null) {
                        if (E.getClass() != this.expected.getClass()) {
                            throw new ComponentException("Expected " + this.expected + " but caught " + E);
                        }
                    }
                    throw new ComponentException(E, comp);
                }
                if (this.expected != null) {
                    throw new ComponentException("Expected :" + this.expected);
                }
                if (this.post != null) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info(" Post ...");
                    }
                    this.post.call(comp);
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }
}

