/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import oms3.Compound;
import oms3.Conversions;
import oms3.Notification;
import oms3.dsl.Buildable;
import oms3.dsl.Util;
import oms3.util.Stats;

public class Summary
implements Buildable {
    private static final String[] opt = new String[]{"monthly", "yearly", "weekly"};
    String time;
    String var;
    int[] idx;
    Calendar cal;
    StringBuffer out;
    List<Number> var_l = new ArrayList<Number>();
    int field = 5;
    String moments = "mean ";
    String file;

    public void setFile(String file) {
        this.file = file;
    }

    public void setPeriod(String period) {
        if (period.equals("weekly")) {
            this.field = 7;
        } else if (period.equals("monthly")) {
            this.field = 5;
        } else if (period.equals("yearly")) {
            this.field = 6;
        } else {
            throw new IllegalArgumentException(period);
        }
    }

    public void setMoments(String moments) {
        this.moments = moments;
    }

    public void setVar(String var) {
        String[] l = Conversions.parseArrayElement(var);
        this.var = l[0];
        this.idx = Util.arraysDims(l);
    }

    public void setTime(String time) {
        this.time = time;
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }

    void setup(Object comp) {
        if (comp instanceof Compound) {
            Compound c = (Compound)comp;
            this.out = new StringBuffer("Summary for '" + this.var + "' (" + opt[this.field - 5] + ")\n");
            this.out.append(String.format(Locale.US, "%19s", this.time) + "  ");
            for (String s : this.moments.split(" ")) {
                this.out.append(String.format(Locale.US, "%14s", s));
            }
            this.out.append('\n');
            c.addListener(new Notification.Listener(){

                @Override
                public void notice(Notification.Type T, EventObject E) {
                    if (T == Notification.Type.OUT) {
                        Notification.DataflowEvent e = (Notification.DataflowEvent)E;
                        if (e.getAccess().getField().getName().equals(Summary.this.time)) {
                            if (Summary.this.cal == null) {
                                Summary.this.cal = (Calendar)e.getValue();
                            }
                        } else if (e.getAccess().getField().getName().equals(Summary.this.var)) {
                            if (Summary.this.idx == null) {
                                Summary.this.var_l.add((Number)e.getValue());
                            } else {
                                Summary.this.var_l.add((Number)Util.accessArray(Summary.this.var, e.getValue(), Summary.this.idx));
                            }
                            if (Summary.this.cal == null) {
                                return;
                            }
                            if (Summary.this.cal.get(Summary.this.field) == 1) {
                                double[] d = Util.convertNumber(Summary.this.var_l);
                                double eff = 0.0;
                                Summary.this.out.append(Conversions.formatISO(Summary.this.cal.getTime()));
                                Summary.this.out.append("  ");
                                for (String m : Summary.this.moments.split(" ")) {
                                    if ("max ".startsWith(m)) {
                                        eff = Stats.max(d);
                                    } else if ("min ".startsWith(m)) {
                                        eff = Stats.min(d);
                                    } else if ("mean ".startsWith(m)) {
                                        eff = Stats.mean(d);
                                    } else if ("count ".startsWith(m)) {
                                        eff = Stats.length(d);
                                    } else if ("range ".startsWith(m)) {
                                        eff = Stats.range(d);
                                    } else if ("median ".startsWith(m)) {
                                        eff = Stats.median(d);
                                    } else if ("stddev ".startsWith(m)) {
                                        eff = Stats.stddev(d);
                                    } else if ("variance ".startsWith(m)) {
                                        eff = Stats.variance(d);
                                    } else if ("meandev ".startsWith(m)) {
                                        eff = Stats.meandev(d);
                                    } else if ("sum ".startsWith(m)) {
                                        eff = Stats.sum(d);
                                    } else if ("product ".startsWith(m)) {
                                        eff = Stats.product(d);
                                    } else if ("q1 ".startsWith(m)) {
                                        eff = Stats.quantile(d, 0.25);
                                    } else if ("q2 ".startsWith(m)) {
                                        eff = Stats.quantile(d, 0.5);
                                    } else if ("q3 ".startsWith(m)) {
                                        eff = Stats.quantile(d, 0.75);
                                    } else if ("lag1 ".startsWith(m)) {
                                        eff = Stats.lag1(d);
                                    } else {
                                        throw new IllegalArgumentException(m);
                                    }
                                    Summary.this.out.append(String.format(Locale.US, "%14.5f", eff));
                                }
                                Summary.this.out.append('\n');
                                Summary.this.var_l.clear();
                            }
                        }
                    }
                }
            });
        }
    }

    public void printSum(File dir) throws IOException {
        PrintWriter w = this.file != null ? new PrintWriter(new FileWriter(new File(dir, this.file), true)) : new PrintWriter(new OutputStreamWriter(System.out));
        w.println(this.out.toString());
        w.flush();
        if (this.file != null) {
            w.close();
        }
    }
}

