/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import groovy.util.BuilderSupport;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oms3.ComponentException;
import oms3.dsl.BeanBuilder;
import oms3.dsl.Buildable;

public abstract class GenericBuilderSupport
extends BuilderSupport {
    private static final Logger log = Logger.getLogger("oms3.sim");
    private static final Logger model_log = Logger.getLogger("oms3.model");
    static final ConsoleHandler conHandler = new ConsoleHandler();
    Buildable current;

    public GenericBuilderSupport() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("oms.version : " + System.getProperty("oms.version"));
            log.config("oms.home : " + System.getProperty("oms.home"));
            log.config("oms.prj : " + System.getProperty("oms.prj"));
        }
    }

    public void setLogging(String level) {
        log.setLevel(Level.parse(level));
    }

    protected Object createNode(Object name) {
        return this.createNode(name, null, null);
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, null, value);
    }

    protected Object createNode(Object name, Map map) {
        return this.createNode(name, map, null);
    }

    protected void setParent(Object parent, Object child) {
    }

    protected abstract Class<? extends Buildable> lookupTopLevel(Object var1);

    protected Object createNode(Object name, Map props, Object value) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("name=" + name + ", " + "map=" + props + ", " + "value=" + value + ", " + "value type=" + (value != null ? value.getClass().toString() : "-"));
        }
        if (name == null) {
            throw new Error("name == null");
        }
        if (this.current == null) {
            Class<? extends Buildable> current_class = this.lookupTopLevel(name);
            try {
                this.current = current_class.newInstance();
            }
            catch (Exception ex) {
                throw new Error(ex.getMessage());
            }
        } else {
            this.current = this.current.create(name, value);
        }
        if (this.current == null) {
            throw new Error("current==null");
        }
        if (props != null && this.current != Buildable.LEAF) {
            try {
                BeanBuilder b = new BeanBuilder(this.current.getClass());
                b.setProperties(this.current, props);
            }
            catch (IllegalAccessException ex) {
                throw new ComponentException(ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                throw new ComponentException(ex.getTargetException().getMessage());
            }
            catch (IntrospectionException ex) {
                throw new ComponentException(ex.getMessage());
            }
        }
        return this.current;
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.current = (Buildable)parent;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Completed: " + parent + " " + node);
        }
    }

    static {
        log.setUseParentHandlers(false);
        log.addHandler(conHandler);
        conHandler.setLevel(Level.ALL);
        conHandler.setFormatter(new LR());
    }

    public static class CompLR
    extends Formatter {
        @Override
        public String format(LogRecord r) {
            return String.format("%1$tm/%1$td %1$tT %2$-7s [%3$s] %4$s\n", new Date(r.getMillis()), r.getLevel(), r.getLoggerName(), r.getMessage());
        }
    }

    public static class LR
    extends Formatter {
        @Override
        public String format(LogRecord r) {
            return String.format("%1$tm/%1$td %1$tT %2$-7s %3$s\n", new Date(r.getMillis()), r.getLevel(), r.getMessage());
        }
    }
}

