/*
 * Decompiled with CFR 0.152.
 */
package oms3.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import oms3.compiler.MemoryOutputJavaFileObject;
import oms3.compiler.UrlJavaFileObject;

public class MemoryOutputJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    Map<String, MemoryOutputJavaFileObject> outputMap = new HashMap<String, MemoryOutputJavaFileObject>();
    List<URL> classPathUrls = new ArrayList<URL>();

    public MemoryOutputJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public void addClassPathUrl(URL url) {
        if (url == null) {
            throw new NullPointerException("url == null");
        }
        this.classPathUrls.add(url);
    }

    public static URL baseUrlOfClass(Class<?> clazz) {
        try {
            String name = clazz.getName();
            URL url = clazz.getResource("/" + name.replace('.', '/') + ".class");
            int curPos = 0;
            do {
                if ((curPos = name.indexOf(46, curPos + 1)) < 0) continue;
                url = new URL(url, "..");
            } while (curPos >= 0);
            return url;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL for class " + clazz.getName(), e);
        }
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind != JavaFileObject.Kind.CLASS) {
            throw new IOException("Only class output supported, kind=" + (Object)((Object)kind));
        }
        try {
            MemoryOutputJavaFileObject output = new MemoryOutputJavaFileObject(new URI(className), kind);
            this.outputMap.put(className, output);
            return output;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject result;
        if (StandardLocation.CLASS_OUTPUT == location && JavaFileObject.Kind.CLASS == kind) {
            result = this.outputMap.get(className);
            if (result == null) {
                result = super.getJavaFileForInput(location, className, kind);
            }
        } else {
            result = super.getJavaFileForInput(location, className, kind);
        }
        return result;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof UrlJavaFileObject) {
            UrlJavaFileObject urlFile = (UrlJavaFileObject)file;
            return urlFile.getBinaryName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (StandardLocation.CLASS_PATH == location && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            ArrayList<JavaFileObject> results = new ArrayList<JavaFileObject>();
            Iterable<JavaFileObject> superResults = super.list(location, packageName, kinds, recurse);
            for (JavaFileObject superResult : superResults) {
                results.add(superResult);
            }
            for (URL curClassPathUrl : this.classPathUrls) {
                String directory = packageName.replace('.', '/') + '/';
                URL loadUrl = new URL(curClassPathUrl, directory);
                try {
                    List<JavaFileObject> additionalClasses = this.listClassesFromUrl(loadUrl, packageName);
                    results.addAll(additionalClasses);
                }
                catch (IOException e) {}
            }
            return results;
        }
        Iterable<JavaFileObject> results = super.list(location, packageName, kinds, recurse);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JavaFileObject> listClassesFromUrl(URL base, String packageName) throws IOException {
        if (base == null) {
            throw new NullPointerException("base == null");
        }
        ArrayList<JavaFileObject> list = new ArrayList<JavaFileObject>();
        URLConnection connection = base.openConnection();
        connection.connect();
        String encoding = connection.getContentEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
        try {
            String curLine;
            do {
                if ((curLine = reader.readLine()) == null || !curLine.endsWith(".class")) continue;
                try {
                    String curSimpleName = curLine.substring(0, curLine.length() - ".class".length());
                    String binaryName = packageName == null ? curSimpleName : packageName + "." + curSimpleName;
                    list.add(new UrlJavaFileObject(curLine, new URL(base, curLine), JavaFileObject.Kind.CLASS, binaryName));
                }
                catch (URISyntaxException e) {
                    throw new IOException("Error parsing URL " + curLine + ".", e);
                }
            } while (curLine != null);
        }
        finally {
            reader.close();
        }
        return list;
    }
}

