/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.ComponentException;
import oms3.Utils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.syntax.SyntaxException;

public class CLI {
    protected static final Logger log;
    static final List<String> simExt;
    static final List<String> flags;

    private CLI() {
    }

    public static Object sim(String file, String ll, String cmd) throws Exception {
        String f = CLI.readFile(file);
        Object o = CLI.createSim(f, false, ll, file);
        return CLI.invoke(o, cmd);
    }

    public static void groovy(String file, String ll, String cmd) throws Exception {
        String f = CLI.readFile(file);
        Object o = CLI.createSim(f, true, ll, file);
    }

    public static Object invoke(Object target, String name) throws Exception {
        return target.getClass().getMethod(name, new Class[0]).invoke(target, new Object[0]);
    }

    public static String readFile(String name) {
        StringBuilder b = new StringBuilder();
        try {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(name));
            while ((line = r.readLine()) != null) {
                b.append(line).append('\n');
            }
            r.close();
        }
        catch (IOException E) {
            throw new ComponentException(E.getMessage());
        }
        return b.toString();
    }

    public static Object createSim(String script, boolean groovy, String ll) {
        return CLI.createSim(script, groovy, ll, null);
    }

    public static Object createSim(String script, boolean groovy, String ll, String file) {
        file = file == null ? "unknown" : file;
        CLI.setOMSProperties();
        Level.parse(ll);
        String prefix = groovy ? "" : "import static oms3.SimConst.*\ndef __sb__ = new oms3.SimBuilder(logging:'" + ll + "')\n" + "__sb__.";
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        Binding b = new Binding();
        b.setVariable("oms_version", (Object)System.getProperty("oms.version"));
        b.setVariable("oms_home", (Object)System.getProperty("oms.home"));
        b.setVariable("oms_prj", (Object)System.getProperty("oms.prj"));
        GroovyShell shell = new GroovyShell((ClassLoader)new GroovyClassLoader(parent), b);
        try {
            return shell.evaluate(prefix + script);
        }
        catch (MultipleCompilationErrorsException E) {
            int n = E.getErrorCollector().getErrorCount();
            if (n > 0) {
                SyntaxException syn = E.getErrorCollector().getSyntaxError(0);
                int line = syn.getLine() + (groovy ? 0 : -2);
                throw new ComponentException(new File(file).getName() + " [line:" + line + " column:" + syn.getStartColumn() + "]  " + syn.getOriginalMessage());
            }
            throw E;
        }
        catch (MissingPropertyException E) {
            throw new ComponentException("Cannot handle property '" + E.getProperty() + "' in " + file);
        }
        catch (GroovyRuntimeException E) {
            throw new ComponentException(E.getMessage() + " in '" + file + "'");
        }
    }

    public static Object evaluateGroovyScript(String file) {
        String content = CLI.readFile(file);
        return CLI.createSim(content, true, "OFF", file);
    }

    private static void setOMSProperties() {
        String oms_work = System.getProperty("oms3.work");
        if (oms_work != null) {
            System.setProperty("oms.prj", oms_work);
        }
        System.setProperty("oms.version", Utils.getVersion());
        if (System.getProperty("oms.home") == null) {
            System.setProperty("oms.home", System.getProperty("user.home") + File.separator + ".oms" + File.separator + Utils.getVersion());
        }
    }

    private static void usage() {
        System.err.println("usage: java -jar oms-all.jar [-l <loglevel> ] [-r|-e|-d|-a|-s|-o] <simfile>");
        System.err.println(" Command line access to simulations.");
        System.err.println("           -r   run the <simfile>");
        System.err.println("           -e   edit parameter in <simfile>");
        System.err.println("           -o   open the last output folder in desktop <simfile>");
        System.err.println("           -d   document the <simfile>");
        System.err.println("           -a   run the <simfile> analysis");
        System.err.println("           -s   create SHA <simfile> digest");
        System.err.println("           -mcp model classpath (jar files not specified in sim)");
        System.err.println("           -l <loglevel> set the log level:");
        System.err.println("                OFF|ALL|SEVERE|WARNING|INFO|CONFIG|FINE|FINER|FINEST");
    }

    static boolean isSim(String file) {
        return simExt.contains(file.substring(file.lastIndexOf(46)));
    }

    public static void main(String[] args) {
        String ll = "OFF";
        String cmd = null;
        String file = null;
        try {
            log.setLevel(Level.OFF);
            for (int i = 0; i < args.length; ++i) {
                if (flags.contains(args[i])) {
                    cmd = args[i];
                    file = args[++i];
                    continue;
                }
                if (args[i].equals("-l")) {
                    ll = args[++i];
                    continue;
                }
                CLI.usage();
                return;
            }
            if (file == null) {
                CLI.usage();
                return;
            }
            try {
                log.setLevel(Level.parse(ll));
            }
            catch (IllegalArgumentException E) {
                throw new ComponentException(E.getMessage());
            }
            boolean isgroovy = !CLI.isSim(file);
            Object target = CLI.createSim(CLI.readFile(file), isgroovy, ll, file);
            if (isgroovy) {
                return;
            }
            if (cmd.equals("-r")) {
                CLI.invoke(target, "run");
            } else if (cmd.equals("-e")) {
                CLI.invoke(target, "edit");
            } else if (cmd.equals("-d")) {
                CLI.invoke(target, "doc");
            } else if (cmd.equals("-o")) {
                CLI.invoke(target, "output");
            } else if (cmd.equals("-a")) {
                CLI.invoke(target, "graph");
            } else if (cmd.equals("-s")) {
                CLI.invoke(target, "dig");
            } else if (cmd.equals("-b")) {
                CLI.invoke(target, "build");
            }
        }
        catch (Throwable E) {
            System.err.println();
            System.err.println("ERROR");
            System.err.println("---------------------------------------------");
            Level level = log.getLevel();
            if (level != Level.OFF) {
                E.printStackTrace(System.err);
            } else {
                Throwable cause = E.getCause();
                String localizedMessage = cause != null ? cause.getLocalizedMessage() : E.getLocalizedMessage();
                String[] split = localizedMessage.split(":");
                if (split.length > 1 && split[0].contains(".")) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i < split.length; ++i) {
                        sb.append(":").append(split[i]);
                    }
                    localizedMessage = sb.substring(1);
                }
                System.err.println(localizedMessage);
            }
            System.exit(1);
        }
    }

    static {
        Handler[] handlers;
        log = Logger.getLogger("oms3.sim");
        simExt = Arrays.asList(".sim", ".luca", ".esp", ".fast");
        flags = Arrays.asList("-r", "-e", "-d", "-o", "-a", "-s", "-b");
        if (System.getProperty("java.version").compareTo("1.6") < 0) {
            throw new RuntimeException("Java 1.6+ required.");
        }
        Logger l0 = Logger.getLogger("");
        for (Handler handler : handlers = l0.getHandlers()) {
            l0.removeHandler(handler);
        }
    }
}

