/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu.luca.of;

import oms3.ObjectiveFunction;

public class PearsonsCorrelation
implements ObjectiveFunction {
    @Override
    public double calculate(double[] obs, double[] sim, double missingValue) {
        int j;
        double syy = 0.0;
        double sxy = 0.0;
        double sxx = 0.0;
        double ay = 0.0;
        double ax = 0.0;
        int n = 0;
        for (j = 0; j < obs.length; ++j) {
            if (!(obs[j] > missingValue)) continue;
            ax += obs[j];
            ay += sim[j];
            ++n;
        }
        if (n == 0) {
            throw new RuntimeException("Pearson's Correlation cannot be calculated due to no observed values");
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < obs.length; ++j) {
            if (!(obs[j] > missingValue)) continue;
            double xt = obs[j] - ax;
            double yt = sim[j] - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return sxy / Math.sqrt(sxx * syy);
    }

    @Override
    public boolean positiveDirection() {
        return true;
    }
}

