/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu.luca;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import ngmf.util.cosu.luca.ExecutionHandle;
import ngmf.util.cosu.luca.Sorter;
import oms3.dsl.cosu.Step;

public class SCE {
    double[] initialParameterSet;
    double[] lowerBound;
    double[] upperBound;
    int numOfParams;
    int initNumOfComplexes;
    int numOfPointsInComplex;
    int initTotalNumOfPoints;
    int numOfPointsInSubComplex;
    int numOfEvolutionSteps;
    int minNumOfComplexes;
    boolean includeInitialPOINT;
    int maxNumOfTrials;
    int numOfShufflingLoops;
    double percentage;
    boolean paramConvergenceSATISFIED;
    double[][] pointsX;
    double[] objFuncValueOfX;
    double[] pointInX;
    double[][] pointsInComplex;
    double[] objFuncValuesOfComplex;
    double[][] pointsInSimplex;
    double[] objFuncValuesOfSimplex;
    double[] worstPoint;
    double objFuncValueOfWorstPoint;
    double[] stdDevOfPopulation;
    double normalizedGeometricMean;
    int[] indicesOfSimplex;
    double[] bound;
    int currentNumOfComplexes;
    int lastNumOfComplexes;
    double[] bestCriterion;
    int totalNumOfPoints;
    double[] initialPoint;
    private ExecutionHandle executionHandle;
    Step stepData;
    Step.Data data;
    int NLOOP = 0;
    int LOOP = 0;
    int IGS = 0;
    int icall = 0;
    PrintStream out = System.out;
    boolean calculateGASDEV = true;
    double gasdevValue1;
    double gasdevValue2;

    public SCE(ExecutionHandle executionHandle, Step stepData, Step.Data data) {
        this.executionHandle = executionHandle;
        this.stepData = stepData;
        this.data = data;
        this.numOfParams = data.getParamValues().length;
        this.initNumOfComplexes = stepData.getInitComplexes();
        this.numOfPointsInComplex = stepData.getPointsPerComplex();
        this.numOfPointsInSubComplex = stepData.getPointsPerSubcomplex();
        this.numOfEvolutionSteps = stepData.getEvolutions();
        this.minNumOfComplexes = stepData.getMinComplexes();
        this.includeInitialPOINT = true;
        this.maxNumOfTrials = stepData.getMaxExec();
        this.numOfShufflingLoops = stepData.getShufflingLoops();
        this.percentage = stepData.getOfPercentage();
        this.upperBound = data.getUpperBound();
        this.lowerBound = data.getLowerBound();
        this.initialParameterSet = data.getParamValues();
        this.initTotalNumOfPoints = this.initNumOfComplexes * this.numOfPointsInComplex;
        this.pointsX = new double[this.initTotalNumOfPoints][this.numOfParams];
        this.objFuncValueOfX = new double[this.initTotalNumOfPoints];
        this.pointInX = new double[this.numOfParams];
        this.pointsInComplex = new double[this.numOfPointsInComplex][this.numOfParams];
        this.objFuncValuesOfComplex = new double[this.numOfPointsInComplex];
        this.pointsInSimplex = new double[this.numOfPointsInSubComplex][this.numOfParams];
        this.objFuncValuesOfSimplex = new double[this.numOfPointsInSubComplex];
        this.worstPoint = new double[this.numOfParams];
        this.stdDevOfPopulation = new double[this.numOfParams];
        this.indicesOfSimplex = new int[this.numOfPointsInSubComplex];
        this.bound = new double[this.numOfParams];
        this.bestCriterion = new double[10];
        this.initialPoint = new double[this.numOfParams];
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void run() throws Exception {
        int j;
        this.currentNumOfComplexes = this.initNumOfComplexes;
        this.totalNumOfPoints = this.initTotalNumOfPoints;
        for (j = 0; j < this.numOfParams; ++j) {
            this.bound[j] = this.upperBound[j] - this.lowerBound[j];
            this.initialPoint[j] = this.initialParameterSet[j];
        }
        double objFuncValue = this.execute(this.initialPoint);
        this.out.println("\n Initial OF value : " + objFuncValue);
        this.out.print(" Initial Parameterset : ");
        for (j = 0; j < this.initialParameterSet.length; ++j) {
            this.out.print(" " + this.initialParameterSet[j]);
        }
        this.out.println();
        if (this.maxNumOfTrials <= 1) {
            this.out.println("Due to max model execution of 1, no optimization was done. The only thing that was done is the calculation of objective function for initial values.");
            return;
        }
        this.out.println(" SCE generating data points ....");
        if (this.includeInitialPOINT) {
            for (j = 0; j < this.numOfParams; ++j) {
                this.pointsX[0][j] = this.initialParameterSet[j];
            }
            this.objFuncValueOfX[0] = objFuncValue;
        } else {
            for (j = 0; j < this.numOfParams; ++j) {
                this.pointsX[0][j] = this.lowerBound[j] + this.bound[j] * Math.random();
                this.pointInX[j] = this.pointsX[0][j];
            }
            this.objFuncValueOfX[0] = objFuncValue = this.execute(this.pointInX);
        }
        this.data.setObjFuncValueOfBestPoint(this.objFuncValueOfX[0]);
        int outputType = 1;
        if (this.icall < this.maxNumOfTrials) {
            int j2;
            for (int i = 1; i < this.totalNumOfPoints; ++i) {
                for (int j3 = 0; j3 < this.numOfParams; ++j3) {
                    this.pointsX[i][j3] = this.lowerBound[j3] + this.bound[j3] * Math.random();
                    this.pointInX[j3] = this.pointsX[i][j3];
                }
                this.objFuncValueOfX[i] = this.execute(this.pointInX);
                if (this.icall < this.maxNumOfTrials) continue;
                this.totalNumOfPoints = i + 1;
                this.pointsX = this.copy(this.pointsX, this.totalNumOfPoints);
                this.objFuncValueOfX = this.copy(this.objFuncValueOfX, this.totalNumOfPoints);
                break;
            }
            this.sort_duan(this.pointsX, this.objFuncValueOfX);
            this.data.setBestParamData(this.pointsX[0], this.objFuncValueOfX[0]);
            for (j2 = 0; j2 < this.numOfParams; ++j2) {
                this.worstPoint[j2] = this.pointsX[this.totalNumOfPoints - 1][j2];
            }
            this.objFuncValueOfWorstPoint = this.objFuncValueOfX[this.totalNumOfPoints - 1];
            this.parstt();
            this.out.print("\n Results of the initial SCE research:");
            for (j2 = 0; j2 < this.numOfParams; ++j2) {
                this.out.print(" " + this.pointsX[0][j2]);
            }
            this.out.println();
            outputType = this.icall >= this.maxNumOfTrials ? 1 : (this.paramConvergenceSATISFIED ? 3 : this.mainLoop());
        }
        double[] bestPoint = this.data.getBestParamDataArray();
        this.data.setParamValues(bestPoint);
        this.executionHandle.writeParameterFile(this.data);
        String output = "";
        this.out.println("\n **************************************************");
        if (outputType == 1) {
            output = " Optimization terminated, limit on the maximum number of trials, " + this.maxNumOfTrials + ", was exceeded.\n" + " Search was stopped at sub-complex " + (this.LOOP + 1) + " of complex " + (this.IGS + 1) + " in shuffling loop. " + this.NLOOP;
        } else if (outputType == 2) {
            output = " Optimization terminated, OF value has not changed " + this.percentage + "% in " + this.numOfShufflingLoops + " shuffling loops.";
        } else if (outputType == 3) {
            double normalizedGeometricMean2 = this.normalizedGeometricMean * 100.0;
            output = " Optimization terminated, population has converged into " + normalizedGeometricMean2 + "% of the feasible space.";
        } else if (outputType == 4) {
            output = " SCE was stopped.";
        }
        this.out.println(output);
        this.out.println(" **************************************************");
        this.out.print(" Final parameter estimates:");
        for (int j4 = 0; j4 < this.numOfParams; ++j4) {
            this.out.print(" " + bestPoint[j4]);
            this.initialParameterSet[j4] = bestPoint[j4];
        }
        this.out.println();
        this.out.println(" Final OF value: " + this.data.getObjFuncValueOfBestPoint());
    }

    private int mainLoop() throws Exception {
        this.out.println(" SCE shuffling ....");
        int outputType = 1;
        while (true) {
            ++this.NLOOP;
            this.IGS = 0;
            while (this.IGS < this.currentNumOfComplexes) {
                int j;
                int k2;
                int k1;
                for (k1 = 0; k1 < this.numOfPointsInComplex; ++k1) {
                    k2 = k1 * this.currentNumOfComplexes + this.IGS;
                    for (j = 0; j < this.numOfParams; ++j) {
                        this.pointsInComplex[k1][j] = this.pointsX[k2][j];
                    }
                    this.objFuncValuesOfComplex[k1] = this.objFuncValueOfX[k2];
                }
                this.LOOP = 0;
                while (this.LOOP < this.numOfEvolutionSteps) {
                    int j2;
                    int k;
                    if (this.numOfPointsInSubComplex == this.numOfPointsInComplex) {
                        for (k = 0; k < this.numOfPointsInSubComplex; ++k) {
                            this.indicesOfSimplex[k] = k;
                        }
                    } else {
                        for (k = 0; k < this.numOfPointsInSubComplex; ++k) {
                            boolean again = true;
                            int lpos = -1;
                            block7: while (again) {
                                again = false;
                                lpos = (int)((double)this.numOfPointsInComplex + 0.5 - Math.sqrt(Math.pow((double)this.numOfPointsInComplex + 0.5, 2.0) - (double)(this.numOfPointsInComplex * (this.numOfPointsInComplex + 1)) * Math.random()));
                                for (int k12 = 0; k12 < k; ++k12) {
                                    if (lpos != this.indicesOfSimplex[k12]) continue;
                                    again = true;
                                    continue block7;
                                }
                            }
                            this.indicesOfSimplex[k] = lpos;
                        }
                        Arrays.sort(this.indicesOfSimplex);
                    }
                    for (k = 0; k < this.numOfPointsInSubComplex; ++k) {
                        for (j2 = 0; j2 < this.numOfParams; ++j2) {
                            this.pointsInSimplex[k][j2] = this.pointsInComplex[this.indicesOfSimplex[k]][j2];
                        }
                        this.objFuncValuesOfSimplex[k] = this.objFuncValuesOfComplex[this.indicesOfSimplex[k]];
                    }
                    this.cce();
                    for (k = 0; k < this.numOfPointsInSubComplex; ++k) {
                        for (j2 = 0; j2 < this.numOfParams; ++j2) {
                            this.pointsInComplex[this.indicesOfSimplex[k]][j2] = this.pointsInSimplex[k][j2];
                        }
                        this.objFuncValuesOfComplex[this.indicesOfSimplex[k]] = this.objFuncValuesOfSimplex[k];
                    }
                    this.sort_duan(this.pointsInComplex, this.objFuncValuesOfComplex);
                    if (this.icall >= this.maxNumOfTrials) break;
                    ++this.LOOP;
                }
                for (k1 = 0; k1 < this.numOfPointsInComplex; ++k1) {
                    k2 = k1 * this.currentNumOfComplexes + this.IGS;
                    for (j = 0; j < this.numOfParams; ++j) {
                        this.pointsX[k2][j] = this.pointsInComplex[k1][j];
                    }
                    this.objFuncValueOfX[k2] = this.objFuncValuesOfComplex[k1];
                }
                if (this.icall >= this.maxNumOfTrials) break;
                ++this.IGS;
            }
            this.sort_duan(this.pointsX, this.objFuncValueOfX);
            this.data.setBestParamData(this.pointsX[0], this.objFuncValueOfX[0]);
            for (int j = 0; j < this.numOfParams; ++j) {
                this.worstPoint[j] = this.pointsX[this.totalNumOfPoints - 1][j];
            }
            this.objFuncValueOfWorstPoint = this.objFuncValueOfX[this.totalNumOfPoints - 1];
            this.parstt();
            if (this.icall >= this.maxNumOfTrials) {
                outputType = 1;
                break;
            }
            int lastIndex = this.bestCriterion.length - 1;
            this.bestCriterion[lastIndex] = this.data.getObjFuncValueOfBestPoint();
            if (this.NLOOP > this.numOfShufflingLoops && this.NLOOP >= this.bestCriterion.length) {
                int idx = lastIndex - this.numOfShufflingLoops;
                if (idx < 0) {
                    idx = 0;
                }
                double denomi = Math.abs(this.bestCriterion[idx] + this.bestCriterion[lastIndex]) / 2.0;
                double timeou = Math.abs(this.bestCriterion[idx] - this.bestCriterion[lastIndex]) / denomi;
                if (timeou < this.percentage) {
                    outputType = 2;
                    break;
                }
            }
            for (int l = 0; l < lastIndex; ++l) {
                this.bestCriterion[l] = this.bestCriterion[l + 1];
            }
            if (this.paramConvergenceSATISFIED) {
                outputType = 3;
                break;
            }
            if (this.currentNumOfComplexes <= this.minNumOfComplexes) continue;
            this.lastNumOfComplexes = this.currentNumOfComplexes--;
            this.totalNumOfPoints = this.currentNumOfComplexes * this.numOfPointsInComplex;
            this.comp();
        }
        return outputType;
    }

    double execute(double[] array) throws Exception {
        this.data.setParamValues(array);
        this.executionHandle.execute(this.data);
        ++this.icall;
        double of = this.stepData.calculateObjectiveFunctionValue(this.executionHandle);
        double distribution = this.normdistForBestPoint();
        this.out.print("\n    " + this.icall + ": " + of + " [" + this.data.getObjFuncValueOfBestPoint() + "/" + this.objFuncValueOfWorstPoint + "]" + " c:" + this.currentNumOfComplexes + " d:" + distribution);
        return of;
    }

    void sort_duan(double[][] x, double[] y) {
        int i;
        Sorter sorter;
        Vector<Integer> indices = new Vector<Integer>();
        for (int i2 = 0; i2 < x.length; ++i2) {
            indices.add(new Integer(i2));
        }
        if (!this.stepData.maximizeObjectiveFunctionValue()) {
            sorter = new Sorter(y, 1);
            Collections.sort(indices, sorter);
            Arrays.sort(y);
        } else {
            int i3;
            sorter = new Sorter(y, 2);
            Collections.sort(indices, sorter);
            Arrays.sort(y);
            double[] new_y = new double[y.length];
            for (i3 = 0; i3 < y.length; ++i3) {
                new_y[i3] = y[y.length - 1 - i3];
            }
            for (i3 = 0; i3 < y.length; ++i3) {
                y[i3] = new_y[i3];
            }
        }
        double[][] new_x = new double[x.length][x[0].length];
        for (i = 0; i < new_x.length; ++i) {
            new_x[i] = x[(Integer)indices.get(i)];
        }
        for (i = 0; i < x.length; ++i) {
            x[i] = new_x[i];
        }
    }

    void parstt() {
        double[] xMax = new double[this.numOfParams];
        double[] xMin = new double[this.numOfParams];
        double[] xMean = new double[this.numOfParams];
        double delta = Math.pow(10.0, -20.0);
        double peps = Math.pow(10.0, -3.0);
        double gSum = 0.0;
        for (int k = 0; k < this.numOfParams; ++k) {
            xMax[k] = Double.MIN_VALUE;
            xMin[k] = Double.MAX_VALUE;
            double xSum1 = 0.0;
            double xSum2 = 0.0;
            for (int i = 0; i < this.totalNumOfPoints; ++i) {
                xMax[k] = Math.max(this.pointsX[i][k], xMax[k]);
                xMin[k] = Math.min(this.pointsX[i][k], xMin[k]);
                xSum1 += this.pointsX[i][k];
                xSum2 += this.pointsX[i][k] * this.pointsX[i][k];
            }
            xMean[k] = xSum1 / (double)this.totalNumOfPoints;
            this.stdDevOfPopulation[k] = xSum2 / (double)this.totalNumOfPoints - xMean[k] * xMean[k];
            if (this.stdDevOfPopulation[k] <= delta) {
                this.stdDevOfPopulation[k] = delta;
            }
            this.stdDevOfPopulation[k] = Math.sqrt(this.stdDevOfPopulation[k]) / this.bound[k];
            gSum += Math.log(delta + (xMax[k] - xMin[k]) / this.bound[k]);
        }
        this.normalizedGeometricMean = Math.pow(Math.E, gSum / (double)this.numOfParams);
        this.paramConvergenceSATISFIED = false;
        if (this.normalizedGeometricMean <= peps) {
            this.paramConvergenceSATISFIED = true;
        }
    }

    double normdistForBestPoint() {
        double normalDistance = 0.0;
        for (int i = 0; i < this.numOfParams; ++i) {
            normalDistance += Math.abs(this.pointsX[0][i] - this.initialPoint[i]) / this.bound[i];
        }
        return normalDistance /= (double)this.numOfParams;
    }

    void comp() {
        double[][] tempPoints = new double[this.totalNumOfPoints][this.numOfParams];
        double[] tempObjFuncValues = new double[this.totalNumOfPoints];
        for (int igs = 0; igs < this.currentNumOfComplexes; ++igs) {
            for (int ipg = 0; ipg < this.numOfPointsInComplex; ++ipg) {
                int k1 = ipg * this.lastNumOfComplexes + igs;
                int k2 = ipg * this.currentNumOfComplexes + igs;
                for (int i = 0; i < this.numOfParams; ++i) {
                    tempPoints[k2][i] = this.pointsX[k1][i];
                }
                tempObjFuncValues[k2] = this.objFuncValueOfX[k1];
            }
        }
        this.pointsX = new double[this.totalNumOfPoints][this.numOfParams];
        this.objFuncValueOfX = new double[this.totalNumOfPoints];
        for (int j = 0; j < this.totalNumOfPoints; ++j) {
            for (int i = 0; i < this.numOfParams; ++i) {
                this.pointsX[j][i] = tempPoints[j][i];
            }
            this.objFuncValueOfX[j] = tempObjFuncValues[j];
        }
    }

    void cce() throws Exception {
        int j;
        int j2;
        double[] worstPointSimplex = new double[this.numOfParams];
        double[] centroid = new double[this.numOfParams];
        double[] newPoint = new double[this.numOfParams];
        double[] vector = new double[this.numOfParams];
        for (j2 = 0; j2 < this.numOfParams; ++j2) {
            worstPointSimplex[j2] = this.pointsInSimplex[this.numOfPointsInSubComplex - 1][j2];
            centroid[j2] = 0.0;
            for (int i = 0; i < this.numOfPointsInSubComplex - 1; ++i) {
                int n = j2;
                centroid[n] = centroid[n] + this.pointsInSimplex[i][j2];
            }
            centroid[j2] = centroid[j2] / (double)(this.numOfPointsInSubComplex - 1);
            vector[j2] = centroid[j2] - worstPointSimplex[j2];
        }
        double worstObjFuncValue = this.objFuncValuesOfSimplex[this.numOfPointsInSubComplex - 1];
        for (j2 = 0; j2 < this.numOfParams; ++j2) {
            newPoint[j2] = worstPointSimplex[j2] + 2.0 * vector[j2];
        }
        boolean outOfBOUND = false;
        for (int j3 = 0; j3 < this.numOfParams; ++j3) {
            if (!(newPoint[j3] > this.upperBound[j3]) && !(newPoint[j3] < this.lowerBound[j3])) continue;
            outOfBOUND = true;
            break;
        }
        if (outOfBOUND) {
            this.getNewPointAtRandom(newPoint);
        }
        double newObjFuncValue = this.execute(newPoint);
        if (this.stepData.maximizeObjectiveFunctionValue() && newObjFuncValue <= worstObjFuncValue || !this.stepData.maximizeObjectiveFunctionValue() && newObjFuncValue >= worstObjFuncValue) {
            if (this.icall >= this.maxNumOfTrials) {
                return;
            }
            for (j = 0; j < this.numOfParams; ++j) {
                newPoint[j] = worstPointSimplex[j] + 0.5 * vector[j];
            }
            newObjFuncValue = this.execute(newPoint);
            if (this.stepData.maximizeObjectiveFunctionValue() && newObjFuncValue < worstObjFuncValue || !this.stepData.maximizeObjectiveFunctionValue() && newObjFuncValue > worstObjFuncValue) {
                if (this.icall >= this.maxNumOfTrials) {
                    return;
                }
                this.getNewPointAtRandom(newPoint);
                newObjFuncValue = this.execute(newPoint);
            }
        }
        for (j = 0; j < this.numOfParams; ++j) {
            this.pointsInSimplex[this.numOfPointsInSubComplex - 1][j] = newPoint[j];
        }
        this.objFuncValuesOfSimplex[this.numOfPointsInSubComplex - 1] = newObjFuncValue;
    }

    void getNewPointAtRandom(double[] newPoint) {
        for (int j = 0; j < this.numOfParams; ++j) {
            int nnn = 0;
            do {
                double R = this.gasdev();
                newPoint[j] = this.pointsInSimplex[0][j] + this.stdDevOfPopulation[j] * R * this.bound[j];
                if (++nnn == 1001) {
                    this.out.println("SCE: getNewPointAtRandom(): Having hard time generating a new point in a feasible region");
                }
                if (nnn <= 1000) continue;
                newPoint[j] = this.lowerBound[j] + Math.abs(R) * (0.5 * this.bound[j]);
                if (nnn % 100 == 1) {
                    this.out.print("Attempt " + nnn + ": new point = " + newPoint[j] + ", lower bound = " + this.lowerBound[j] + ", upper bound = " + this.upperBound[j]);
                }
                if (newPoint[j] > this.upperBound[j] || newPoint[j] < this.lowerBound[j]) {
                    this.out.println(" ---> out of bound");
                    continue;
                }
                this.out.println(" ---> in bound!!");
            } while (newPoint[j] > this.upperBound[j] || newPoint[j] < this.lowerBound[j]);
        }
    }

    double gasdev() {
        if (this.calculateGASDEV) {
            double v2;
            double v1;
            double R;
            while ((R = (v1 = 2.0 * Math.random() - 1.0) * v1 + (v2 = 2.0 * Math.random() - 1.0) * v2) >= 1.0) {
            }
            double fac = Math.sqrt(-1.0 * (2.0 * Math.log(R) / R));
            this.gasdevValue2 = v1 * fac;
            this.gasdevValue1 = v2 * fac;
            this.calculateGASDEV = false;
            return this.gasdevValue1;
        }
        this.calculateGASDEV = true;
        return this.gasdevValue2;
    }

    double[] copy(double[] source, int size) {
        double[] newArray = new double[size];
        for (int i = 0; i < size; ++i) {
            newArray[i] = source[i];
        }
        return newArray;
    }

    double[][] copy(double[][] source, int rowSize) {
        double[][] newArray = new double[rowSize][source[0].length];
        for (int i = 0; i < rowSize; ++i) {
            for (int j = 0; j < newArray[0].length; ++j) {
                newArray[i][j] = source[i][j];
            }
        }
        return newArray;
    }
}

