/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;

public class MOCOM {
    public String parameterIDs;
    public String boundaries;
    public String effMethodNames;
    public double[] effValues;
    public int[] MaximizeEff;
    public boolean enable;
    public String fileName;
    double[] parameters;
    String[] parameterNames;
    String[] effNames;
    double[] lowBound;
    double[] upBound;
    PrintWriter writer;
    int N;
    int M;
    int n;
    int icall = 0;
    boolean continousOutput = false;
    Random generator = new Random();

    void init() throws FileNotFoundException {
        int p;
        this.writer = new PrintWriter(this.fileName);
        for (p = 0; p < this.parameterNames.length; ++p) {
            this.writer.print(this.parameterNames[p] + " ");
        }
        for (p = 0; p < this.effNames.length; ++p) {
            this.writer.print(this.effNames[p] + " ");
        }
        this.writer.flush();
    }

    private double random() {
        return this.generator.nextDouble();
    }

    boolean isSampleValid(double[] sample) {
        for (int i = 0; i < this.parameterNames.length; ++i) {
            if (!(sample[i] < this.lowBound[i]) && !(sample[i] > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    double[] compob(double[] x) {
        for (int j = 0; j < this.parameters.length; ++j) {
            this.parameters[j] = x[j];
        }
        double[] F = new double[this.M];
        for (int i = 0; i < this.M; ++i) {
            if (this.MaximizeEff[i] == 2) {
                F[i] = this.effValues[i];
                continue;
            }
            if (this.MaximizeEff[i] == 4) {
                F[i] = Math.abs(this.effValues[i]);
                continue;
            }
            if (this.MaximizeEff[i] == 3) {
                F[i] = -Math.abs(this.effValues[i]);
                continue;
            }
            if (this.MaximizeEff[i] != 1) continue;
            F[i] = -this.effValues[i];
        }
        return F;
    }

    public void sort(double[][] x, int col) {
        Arrays.sort(x, new MOCOM_Comparator(col, false));
    }

    int[] randperm(int upto) {
        int i;
        int[] perm = new int[upto];
        int[] freenums = new int[upto];
        for (i = 0; i < upto; ++i) {
            freenums[i] = i + 1;
        }
        for (i = 1; i <= upto; ++i) {
            int num = (int)Math.floor(this.random() * (double)(upto + 1 - i) + 1.0);
            perm[i - 1] = freenums[num - 1];
            freenums[num - 1] = freenums[upto - i];
        }
        return perm;
    }

    double[][] lhsu(double[] xmin, double[] xmax, int nsample) {
        int nvar = xmin.length;
        double[][] s = new double[nsample][nvar];
        for (int j = 0; j < nvar; ++j) {
            int[] idx = this.randperm(nsample);
            for (int i = 0; i < nsample; ++i) {
                double P = ((double)idx[i] - this.random()) / (double)nsample;
                s[i][j] = xmin[j] + P * (xmax[j] - xmin[j]);
            }
        }
        return s;
    }

    double[][] compf(double[][] D, int m) {
        int s = D.length;
        int r = 0;
        if (s == 0) {
            return null;
        }
        r = D[0].length;
        double[][] F = new double[s][];
        for (int i = 0; i < s; ++i) {
            F[i] = this.compob(D[i]);
        }
        return F;
    }

    int intMax(int[] R) {
        int RMax = Integer.MIN_VALUE;
        for (int i = 0; i < R.length; ++i) {
            if (RMax >= R[i]) continue;
            RMax = R[i];
        }
        return RMax;
    }

    Object[] parrank(double[][] ObjVals, int nmbOfObjs) {
        int i;
        int nmbOfIndivs = ObjVals.length;
        Vector[] dominated = new Vector[nmbOfIndivs];
        Vector front = new Vector();
        int[] nmbOfFront = new int[nmbOfIndivs];
        int[] nmbOfDominating = new int[nmbOfIndivs];
        for (i = 0; i < nmbOfIndivs; ++i) {
            nmbOfFront[i] = 0;
            nmbOfDominating[i] = 0;
            dominated[i] = new Vector();
        }
        for (int p = 0; p < nmbOfIndivs; ++p) {
            for (int q = 0; q < nmbOfIndivs; ++q) {
                int k;
                int sumA1 = 0;
                int sumA2 = 0;
                int sumB1 = 0;
                int sumB2 = 0;
                for (k = 0; k < nmbOfObjs; ++k) {
                    if (ObjVals[p][k] <= ObjVals[q][k]) {
                        ++sumA1;
                    }
                    if (!(ObjVals[p][k] < ObjVals[q][k])) continue;
                    ++sumA2;
                }
                for (k = 0; k < nmbOfObjs; ++k) {
                    if (ObjVals[q][k] <= ObjVals[p][k]) {
                        ++sumB1;
                    }
                    if (!(ObjVals[q][k] < ObjVals[p][k])) continue;
                    ++sumB2;
                }
                if (sumA1 == nmbOfObjs && sumA2 > 0) {
                    dominated[p].addElement(new Integer(q));
                    continue;
                }
                if (sumB1 != nmbOfObjs || sumB2 <= 0) continue;
                int n = p;
                nmbOfDominating[n] = nmbOfDominating[n] + 1;
            }
            if (nmbOfDominating[p] != 0) continue;
            nmbOfFront[p] = 1;
            if (front.size() == 0) {
                front.add(new Vector());
            }
            ((Vector)front.get(0)).add(p);
        }
        i = 0;
        while (((Vector)front.get(i)).size() != 0) {
            Vector<Integer> nextFront = new Vector<Integer>();
            for (int k = 0; k < ((Vector)front.get(i)).size(); ++k) {
                int p = (Integer)((Vector)front.get(i)).get(k);
                for (int l = 0; l < dominated[p].size(); ++l) {
                    int q;
                    int n = q = ((Integer)dominated[p].get(l)).intValue();
                    nmbOfDominating[n] = nmbOfDominating[n] - 1;
                    if (nmbOfDominating[q] != 0) continue;
                    nmbOfFront[q] = i + 2;
                    nextFront.add(new Integer(q));
                }
            }
            ++i;
            front.add(nextFront);
        }
        Integer RMax = this.intMax(nmbOfFront);
        return new Object[]{nmbOfFront, RMax};
    }

    double[] asswght(int[] R, int RMax, int s) {
        int i;
        double[] P = new double[s];
        double sum = 0.0;
        for (i = 0; i < R.length; ++i) {
            sum += (double)R[i];
        }
        for (i = 0; i < s; ++i) {
            P[i] = (double)(RMax - R[i] + 1) / ((double)(RMax + 1) * (double)s - sum);
        }
        return P;
    }

    Object[] worst(double[][] D, int n, int[] R, int Rmax) {
        Vector<Integer> Ltmp = new Vector<Integer>();
        for (int i = 0; i < R.length; ++i) {
            if (R[i] != Rmax) continue;
            Ltmp.add(new Integer(i));
        }
        int[] L = new int[Ltmp.size()];
        for (int i = 0; i < Ltmp.size(); ++i) {
            L[i] = (Integer)Ltmp.get(i);
        }
        int nA = L.length;
        double[][] A = new double[nA][n];
        for (int i = 0; i < L.length; ++i) {
            for (int j = 0; j < n; ++j) {
                A[i][j] = D[L[i]][j];
            }
        }
        return new Object[]{A, L, new Integer(nA)};
    }

    Object[] choose(double[] P, double[][] D, double[][] F, int[] Rank, int n) {
        double[] sP = new double[P.length];
        double sum = 0.0;
        int counter = 0;
        int[] Selected = new int[n];
        double[][] S1 = new double[n][D[0].length];
        double[][] F1 = new double[n][F[0].length];
        int[] R1 = new int[n];
        for (int i = 0; i < P.length; ++i) {
            sP[i] = sum += P[i];
        }
        while (counter < n) {
            int j;
            int R = -1;
            boolean multipleOccurrences = false;
            block2: do {
                int i;
                multipleOccurrences = false;
                double U = this.random();
                for (i = 0; i < P.length; ++i) {
                    if (!(U < sP[i])) continue;
                    R = i;
                    break;
                }
                for (i = 0; i < counter; ++i) {
                    if (Selected[i] != R) continue;
                    multipleOccurrences = true;
                    continue block2;
                }
            } while (multipleOccurrences);
            Selected[counter] = R;
            for (j = 0; j < D[0].length; ++j) {
                S1[counter][j] = D[R][j];
            }
            for (j = 0; j < F[0].length; ++j) {
                F1[counter][j] = F[R][j];
            }
            R1[counter] = Rank[R];
            ++counter;
        }
        return new Object[]{S1, F1, R1};
    }

    Object[] mosim(double[][] S, double[][] SF, int[] SR, int n, double[] minn, double[] maxn) {
        int i;
        double[] Fnew;
        double[] Snew;
        int lenS = S[0].length;
        int lenSF = SF[0].length;
        int r = lenS + lenSF + 1;
        double[][] Simplex = new double[S.length][lenS + lenSF + 1];
        for (int i2 = 0; i2 < S.length; ++i2) {
            int j;
            for (j = 0; j < lenS; ++j) {
                Simplex[i2][j] = S[i2][j];
            }
            for (j = 0; j < lenSF; ++j) {
                Simplex[i2][lenS + j] = SF[i2][j];
            }
            Simplex[i2][lenS + lenSF] = SR[i2];
        }
        this.sort(Simplex, r - 1);
        double[] Fw = new double[lenSF];
        for (int i3 = 0; i3 < lenSF; ++i3) {
            Fw[i3] = Simplex[Simplex.length - 1][n + i3];
        }
        double[] Sw = new double[n];
        for (int i4 = 0; i4 < n; ++i4) {
            Sw[i4] = Simplex[Simplex.length - 1][i4];
        }
        double[] Sg = new double[n];
        int i5 = 0;
        while (i5 < n) {
            Sg[i5] = 0.0;
            for (int j = 0; j < Simplex.length - 1; ++j) {
                int n2 = i5;
                Sg[n2] = Sg[n2] + Simplex[j][i5];
            }
            int n3 = i5++;
            Sg[n3] = Sg[n3] / (double)(Simplex.length - 1);
        }
        double[] Sref = new double[n];
        for (int i6 = 0; i6 < n; ++i6) {
            Sref[i6] = 2.0 * Sg[i6] - Sw[i6];
        }
        boolean accept = this.isSampleValid(Sref);
        if (!accept) {
            double[] Scon = new double[n];
            for (int i7 = 0; i7 < n; ++i7) {
                Scon[i7] = 0.5 * Sg[i7] + 0.5 * Sw[i7];
            }
            accept = this.isSampleValid(Scon);
            while (!accept) {
                double[][] newpar = this.lhsu(this.lowBound, this.upBound, 1);
                Scon = newpar[0];
                accept = this.isSampleValid(Scon);
            }
            double[] Fcon = this.compob(Scon);
            Snew = Scon;
            Fnew = Fcon;
        } else {
            double[] Fref = this.compob(Sref);
            double[][] SimplexTmp = new double[Simplex.length][lenSF];
            for (int j = 0; j < lenSF; ++j) {
                for (int i8 = 0; i8 < Simplex.length - 1; ++i8) {
                    SimplexTmp[i8][j] = Simplex[i8][n + j];
                }
                SimplexTmp[Simplex.length - 1][j] = Fref[j];
            }
            Object[] ret = this.parrank(SimplexTmp, 2);
            int[] Rref = (int[])ret[0];
            int Rrefmax = Integer.MIN_VALUE;
            for (int i9 = 0; i9 < Rref.length - 1; ++i9) {
                if (Rref[i9] <= Rrefmax) continue;
                Rrefmax = Rref[i9];
            }
            if (Rref[Rref.length - 1] <= Rrefmax) {
                Snew = Sref;
                Fnew = Fref;
            } else {
                double[] Scon = new double[n];
                for (int i10 = 0; i10 < n; ++i10) {
                    Scon[i10] = 0.5 * Sg[i10] + 0.5 * Sw[i10];
                }
                accept = this.isSampleValid(Scon);
                while (!accept) {
                    double[][] newpar = this.lhsu(this.lowBound, this.upBound, 1);
                    Scon = newpar[0];
                    accept = this.isSampleValid(Scon);
                }
                double[] Fcon = this.compob(Scon);
                Snew = Scon;
                Fnew = Fcon;
            }
        }
        for (i = 0; i < n; ++i) {
            S[S.length - 1][i] = Snew[i];
        }
        for (i = 0; i < SF[0].length; ++i) {
            SF[SF.length - 1][i] = Fnew[i];
        }
        return new Object[]{S, SF};
    }

    public Object[] update(double[][] D, int[] L, double[][] A, int n, int nA, double[][] F, double[][] FA2) {
        for (int i = 0; i < nA; ++i) {
            int j;
            for (j = 0; j < n; ++j) {
                D[L[i]][j] = A[i][j];
            }
            for (j = 0; j < FA2[0].length; ++j) {
                F[L[i]][j] = FA2[i][j];
            }
        }
        return new Object[]{D, F};
    }

    public Object[] mocom(int n, int s, double[] minn, double[] maxn, int m, int MaxIter) {
        double[][] D = this.lhsu(minn, maxn, s);
        double[][] F = this.compf(D, m);
        int nobj = F[0].length;
        Object[] ret = this.parrank(F, nobj);
        int[] R = (int[])ret[0];
        int Rmax = (Integer)ret[1];
        int loopcounter = 1;
        while (Rmax > 1) {
            int i;
            int c;
            double[] P = this.asswght(R, Rmax, s);
            ret = this.worst(D, n, R, Rmax);
            double[][] A = (double[][])ret[0];
            int[] L = (int[])ret[1];
            int nA = (Integer)ret[2];
            ret = this.choose(P, D, F, R, n);
            double[][] S1 = (double[][])ret[0];
            double[][] F1 = (double[][])ret[1];
            int[] R1 = (int[])ret[2];
            double[][] FA2 = new double[nA][F[0].length];
            for (int j = 0; j < nA; ++j) {
                int c1;
                int c12;
                if (S1.length != F1.length || F1.length != R1.length) {
                    throw new RuntimeException("Component " + this + ": internal error.");
                }
                double[][] S = new double[S1.length + 1][S1[0].length];
                double[][] SF = new double[F1.length + 1][F1[0].length];
                int[] SR = new int[R1.length + 1];
                for (c12 = 0; c12 < S1.length; ++c12) {
                    int c2;
                    for (c2 = 0; c2 < S1[0].length; ++c2) {
                        S[c12][c2] = S1[c12][c2];
                    }
                    for (c2 = 0; c2 < F1[0].length; ++c2) {
                        SF[c12][c2] = F1[c12][c2];
                    }
                    SR[c12] = R1[c12];
                }
                for (c12 = 0; c12 < S1[0].length; ++c12) {
                    S[S1.length][c12] = A[j][c12];
                }
                for (c12 = 0; c12 < F1[0].length; ++c12) {
                    SF[F1.length][c12] = F[L[j]][c12];
                }
                SR[R1.length] = R[L[j]];
                Object[] res = this.mosim(S, SF, SR, n, minn, maxn);
                S = (double[][])res[0];
                SF = (double[][])res[1];
                for (c1 = 0; c1 < n; ++c1) {
                    A[j][c1] = S[S.length - 1][c1];
                }
                for (c1 = 0; c1 < FA2[j].length; ++c1) {
                    FA2[j][c1] = SF[SF.length - 1][c1];
                }
            }
            ret = this.update(D, L, A, n, nA, F, FA2);
            D = (double[][])ret[0];
            F = (double[][])ret[1];
            ret = this.parrank(F, nobj);
            R = (int[])ret[0];
            Rmax = (Integer)ret[1];
            double[][] currentResult = new double[s][this.N + this.M + 1];
            for (int i2 = 0; i2 < s; ++i2) {
                int j;
                for (j = 0; j < this.N; ++j) {
                    currentResult[i2][j] = D[i2][j];
                }
                for (j = 0; j < this.M; ++j) {
                    currentResult[i2][this.N + j] = F[i2][j];
                }
                currentResult[i2][this.N + this.M] = R[i2];
            }
            this.sort(currentResult, this.N + this.M);
            if (this.continousOutput) {
                for (c = 0; c < s && loopcounter % 10 == 0; ++c) {
                    int i3;
                    this.writer.write("" + currentResult[c][this.N + this.M] + "\t");
                    for (i3 = 0; i3 < this.N; ++i3) {
                        this.writer.write("" + currentResult[c][i3] + "\t");
                    }
                    for (i3 = 0; i3 < this.M; ++i3) {
                        this.writer.write("" + currentResult[c][this.N + i3] + "\t");
                    }
                    this.writer.println("");
                    this.writer.flush();
                }
            }
            if (MaxIter < ++loopcounter) {
                int i4;
                System.out.println("********************************************");
                System.out.println("---------->OPTIMIZATION STOP<---------------");
                System.out.println("--->MAXIMUM NUMBER OF LOOPS HAS REACHED<----");
                System.out.println("********************************************");
                c = 0;
                System.out.print("Rank\t");
                for (i4 = 0; i4 < this.N; ++i4) {
                    System.out.print(this.parameterNames[i4] + "\t");
                }
                for (i4 = 0; i4 < this.M; ++i4) {
                    System.out.print(this.effNames[i4] + "\t");
                }
                System.out.println("");
                while (c < s) {
                    System.out.print("" + currentResult[c][this.N + this.M] + "\t");
                    for (i4 = 0; i4 < this.N; ++i4) {
                        System.out.print("" + currentResult[c][i4] + "\t");
                    }
                    for (i4 = 0; i4 < this.M; ++i4) {
                        System.out.print("" + currentResult[c][this.N + i4] + "\t");
                    }
                    System.out.println("");
                    ++c;
                }
                c = 0;
                this.writer.println("Number of model runs: " + this.icall);
                this.writer.write("Rank\t");
                for (i4 = 0; i4 < this.N; ++i4) {
                    this.writer.write(this.parameterNames[i4] + "\t");
                }
                for (i4 = 0; i4 < this.M; ++i4) {
                    this.writer.write(this.effNames[i4] + "\t");
                }
                this.writer.write("\n");
                while (c < s) {
                    this.writer.write("" + currentResult[c][this.N + this.M] + "\t");
                    for (i4 = 0; i4 < this.N; ++i4) {
                        this.writer.write("" + currentResult[c][i4] + "\t");
                    }
                    for (i4 = 0; i4 < this.M; ++i4) {
                        this.writer.write("" + currentResult[c][this.N + i4] + "\t");
                    }
                    ++c;
                    this.writer.println("");
                    this.writer.flush();
                }
                this.writer.flush();
                break;
            }
            if (Rmax > 1) continue;
            System.out.println("********************************************");
            System.out.println("---------->OPTIMIZATION STOP<---------------");
            System.out.println("-------------->SUCCESSFUL<------------------");
            System.out.println("********************************************");
            c = 0;
            System.out.print("Rank\t");
            for (i = 0; i < this.N; ++i) {
                System.out.print(this.parameterNames[i] + "\t");
            }
            for (i = 0; i < this.M; ++i) {
                System.out.print(this.effNames[i] + "\t");
            }
            System.out.println("");
            while (c < s) {
                System.out.print("" + currentResult[c][this.N + this.M] + "\t");
                for (i = 0; i < this.N; ++i) {
                    System.out.print("" + currentResult[c][i] + "\t");
                }
                for (i = 0; i < this.M; ++i) {
                    System.out.print("" + currentResult[c][this.N + i] + "\t");
                }
                System.out.println("");
                ++c;
            }
            c = 0;
            this.writer.println("Number of model runs: " + this.icall);
            this.writer.write("Rank\t");
            for (i = 0; i < this.N; ++i) {
                this.writer.write(this.parameterNames[i] + "\t");
            }
            for (i = 0; i < this.M; ++i) {
                this.writer.write(this.effNames[i] + "\t");
            }
            this.writer.println();
            while (c < s) {
                this.writer.write("" + currentResult[c][this.N + this.M] + "\t");
                for (i = 0; i < this.N; ++i) {
                    this.writer.write("" + currentResult[c][i] + "\t");
                }
                for (i = 0; i < this.M; ++i) {
                    this.writer.write("" + currentResult[c][this.N + i] + "\t");
                }
                ++c;
                this.writer.println();
                this.writer.flush();
            }
            this.writer.flush();
        }
        return new Object[]{D, F, R, new Integer(Rmax)};
    }

    public void run() {
        double[] lowBound = null;
        double[] upBound = null;
        int N = 0;
        int s = 0;
        int m = 0;
        int maxIter = 0;
        Object[] ret = this.mocom(N, s, lowBound, upBound, m, maxIter);
    }

    static class MOCOM_Comparator
    implements Comparator<double[]> {
        private int col = 0;
        private int order = 1;

        public MOCOM_Comparator(int col, boolean decreasing_order) {
            this.col = col;
            this.order = decreasing_order ? -1 : 1;
        }

        @Override
        public int compare(double[] b1, double[] b2) {
            if (b1[this.col] < b2[this.col]) {
                return -1 * this.order;
            }
            if (b1[this.col] == b2[this.col]) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

