/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui.mms;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import ngmf.ui.mms.Dimension;
import ngmf.ui.mms.MmsParamsReader;
import ngmf.ui.mms.Parameter;
import ngmf.ui.mms.ParameterSet;
import ngmf.ui.mms.ParameterSetHistory;

public class MmsParameterSet
implements ParameterSet {
    private HashMap dimensions = new HashMap();
    private HashMap parameters = new HashMap();
    private Vector history = new Vector();
    private String fileName;
    private String description;
    private String version;
    private Dimension[] dimensionArray;
    private Parameter[] parameterArray;
    private boolean writeHistory = false;

    @Override
    public Vector getParamsFor2DDim(String dim_name) {
        Vector<Parameter> params = new Vector<Parameter>(20, 20);
        String dim1_name = dim_name.substring(0, dim_name.indexOf(44));
        String dim2_name = dim_name.substring(dim_name.indexOf(44) + 1, dim_name.length());
        Dimension dim1 = (Dimension)this.dimensions.get(dim1_name);
        Dimension dim2 = (Dimension)this.dimensions.get(dim2_name);
        for (Parameter p : this.parameters.values()) {
            if (!p.isDimensionedBy(dim1) || !p.isDimensionedBy(dim2)) continue;
            params.add(p);
        }
        return params;
    }

    public TreeSet get2DCombos() {
        TreeSet<String> params = new TreeSet<String>();
        Iterator i = this.parameters.keySet().iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)this.parameters.get(i.next());
            if (p.getNumDim() != 2) continue;
            String foo = p.getDimension(0).getName() + "," + p.getDimension(1).getName();
            params.add(foo);
        }
        return params;
    }

    @Override
    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    @Override
    public Dimension getDimension(String name) {
        return (Dimension)this.dimensions.get(name);
    }

    @Override
    public Map getDims() {
        return this.dimensions;
    }

    @Override
    public Map getParams() {
        return this.parameters;
    }

    @Override
    public Set getParamsForDim(Dimension dim) {
        TreeSet<Parameter> params = new TreeSet<Parameter>();
        for (Parameter p : this.parameters.values()) {
            if (!p.isDimensionedBy(dim)) continue;
            params.add(p);
        }
        return params;
    }

    @Override
    public void addDimension(Dimension dim) {
        this.dimensions.put(dim.getName(), dim);
        Object[] o = this.dimensions.values().toArray();
        this.dimensionArray = new Dimension[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            this.dimensionArray[i] = (Dimension)o[i];
        }
    }

    @Override
    public void setDimension(Dimension dim, int size) {
        if (dim.getSize() == size) {
            return;
        }
        dim.setSize(size);
        Set param_set = this.getParamsForDim(dim);
        for (Parameter param : param_set) {
            param.resize();
        }
        this.history.add(new ParameterSetHistory(dim, "changed size to " + size));
    }

    @Override
    public void setParameterValues(Parameter param, Object vals) {
        param.setVals(vals);
        this.history.add(new ParameterSetHistory(param, "changed array values"));
    }

    @Override
    public void setParameterValue(Parameter param, Object val, int index) {
        param.setValueAt(val, index);
        this.history.add(new ParameterSetHistory(param, "changed value at index " + index));
    }

    @Override
    public void addParameter(Parameter parameter) {
        int num_dim = parameter.getNumDim();
        for (int i = 0; i < num_dim; ++i) {
            if (this.dimensions.containsKey(parameter.getDimension(i).getName())) continue;
            this.addDimension(parameter.getDimension(i));
        }
        Parameter param = this.getParameter(parameter.getName());
        if (param != null) {
            this.parameters.remove(parameter.getName());
        }
        this.parameters.put(parameter.getName(), parameter);
        Object[] o = this.parameters.values().toArray();
        this.parameterArray = new Parameter[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameterArray[i] = (Parameter)o[i];
        }
    }

    @Override
    public Object getValues(Dimension dim) {
        int[] i_a = new int[]{dim.getSize()};
        return i_a;
    }

    @Override
    public Object getValues(Parameter param) {
        return param.getVals();
    }

    @Override
    public Object getValues(String name) {
        Object ret = null;
        Parameter mp = this.getParameter(name);
        if (mp != null) {
            ret = this.getValues(mp);
        } else {
            Dimension md = this.getDimension(name);
            ret = this.getValues(md);
        }
        return ret;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public static void main(String[] arg) {
        try {
            MmsParamsReader mp = new MmsParamsReader(new FileReader(arg[0]));
            ParameterSet mps = mp.read();
            System.out.println("Dimensions = " + mps.getDims());
            System.out.println("Parameters = " + mps.getParams());
        }
        catch (FileNotFoundException e) {
            System.out.println(arg[0] + " not found");
        }
        catch (IOException e) {
            System.out.println(arg[0] + " io exception");
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Set getDimensionNames() {
        return this.dimensions.keySet();
    }

    @Override
    public Set getParameterNames() {
        return this.parameters.keySet();
    }

    public String toString() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return "MMS Parameters";
    }

    @Override
    public Dimension[] getDimensionArray() {
        return this.dimensionArray;
    }

    @Override
    public Parameter[] getParameterArray() {
        return this.parameterArray;
    }

    @Override
    public String[] getEditableDimensionArray() {
        TreeSet<String> dim_set = new TreeSet<String>();
        for (Parameter p : this.parameters.values()) {
            if (p.getSize() <= 0) continue;
            String foo = "";
            for (int j = 0; j < p.getNumDim(); ++j) {
                if (j != 0) {
                    foo = foo + ",";
                }
                foo = foo + p.getDimension(j).getName();
            }
            dim_set.add(foo);
        }
        Object[] objs = dim_set.toArray();
        String[] ret = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            ret[i] = (String)objs[i];
        }
        return ret;
    }

    @Override
    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Override
    public Vector getHistory() {
        return this.history;
    }

    @Override
    public void addHistory(String hist_line) {
        this.history.add(new ParameterSetHistory(hist_line));
    }

    @Override
    public void addHistory(Object what, String comment) {
        this.history.add(new ParameterSetHistory(what, comment));
    }

    public void writeHistory(boolean write) {
        this.writeHistory = write;
    }

    @Override
    public boolean isWriteHistory() {
        return this.writeHistory;
    }

    @Override
    public void setWriteHistory(boolean writeHistory) {
        this.writeHistory = writeHistory;
    }
}

