/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui.calc;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.Library;
import javax.swing.table.TableModel;
import ngmf.ui.calc.Mathx;
import ngmf.ui.calc.Util;
import oms3.util.Stats;

public class JelLibrarySupport {
    TableResolver symtab = new TableResolver();
    Object[] context = new Object[]{this.symtab};
    Library lib = new Library(new Class[]{Math.class, Mathx.class, Stats.class}, new Class[]{TableResolver.class}, null, this.symtab, null);
    TableModel model;

    public JelLibrarySupport(TableModel model) {
        this.model = model;
        try {
            this.lib.markStateDependent("random", null);
            this.lib.markStateDependent("random", new Class[]{Double.TYPE, Double.TYPE});
            this.lib.markStateDependent("ramp", new Class[]{Double.TYPE, Double.TYPE});
            this.lib.markStateDependent("reset_ramp", null);
        }
        catch (CompilationException ex) {
            ex.printStackTrace();
        }
    }

    public void setModel(TableModel model) {
        this.model = model;
    }

    Library getLibrary() {
        return this.lib;
    }

    Object[] getContext() {
        return this.context;
    }

    TableResolver getResolver() {
        return this.symtab;
    }

    public class TableResolver
    extends DVMap {
        int row;

        void setRow(int row) {
            this.row = row;
        }

        @Override
        public String getTypeName(String name) {
            int col;
            boolean isArray = true;
            if (name.startsWith("$")) {
                isArray = false;
                name = name.substring(1);
            }
            if ((col = Util.findColumn(JelLibrarySupport.this.model, name)) == -1) {
                return null;
            }
            if (!isArray && Number.class.isAssignableFrom(JelLibrarySupport.this.model.getColumnClass(col))) {
                return "Number";
            }
            if (isArray && Number.class.isAssignableFrom(JelLibrarySupport.this.model.getColumnClass(col))) {
                return "NumberArray";
            }
            if (!isArray && JelLibrarySupport.this.model.getColumnClass(col) == String.class) {
                return "String";
            }
            if (isArray && JelLibrarySupport.this.model.getColumnClass(col) == String.class) {
                return "StringArray";
            }
            return null;
        }

        public double getNumberProperty(String name) {
            int col = Util.findColumn(JelLibrarySupport.this.model, name.substring(1));
            return ((Number)JelLibrarySupport.this.model.getValueAt(this.row, col)).doubleValue();
        }

        public double[] getNumberArrayProperty(String name) {
            int col = Util.findColumn(JelLibrarySupport.this.model, name);
            double[] a = new double[JelLibrarySupport.this.model.getRowCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((Number)JelLibrarySupport.this.model.getValueAt(i, col)).doubleValue();
            }
            return a;
        }

        public double getStringProperty(String name) {
            int col = Util.findColumn(JelLibrarySupport.this.model, name.substring(1));
            return Double.parseDouble(JelLibrarySupport.this.model.getValueAt(this.row, col).toString());
        }

        public double[] getStringArrayProperty(String name) {
            int col = Util.findColumn(JelLibrarySupport.this.model, name);
            double[] a = new double[JelLibrarySupport.this.model.getRowCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = Double.parseDouble(JelLibrarySupport.this.model.getValueAt(i, col).toString());
            }
            return a;
        }
    }
}

