/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JTable;
import ngmf.ui.PasteKeyListener;

public class TableListener {
    JTable table;

    public TableListener(JTable table) {
        this.table = table;
        table.getTableHeader().addKeyListener(new PasteKeyListener(this));
        table.addKeyListener(new PasteKeyListener(this));
    }

    private ArrayList<ArrayList<String>> parseString(String text) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        StringTokenizer linetoken = new StringTokenizer(text, "\n");
        while (linetoken.hasMoreTokens()) {
            String current = linetoken.nextToken();
            StringTokenizer token = current.contains(",") ? new StringTokenizer(current, ",") : new StringTokenizer(current);
            ArrayList<String> line = new ArrayList<String>();
            while (token.hasMoreTokens()) {
                line.add(token.nextToken());
            }
            result.add(line);
        }
        return result;
    }

    private void addContents(String text) {
        int firstColSelected = this.table.getSelectedColumn();
        int firstRowSelected = this.table.getSelectedRow();
        int temp = firstColSelected;
        if (firstColSelected == -1 || firstRowSelected == -1) {
            return;
        }
        ArrayList<ArrayList<String>> clipboard = this.parseString(text);
        for (int i = 0; i < clipboard.size(); ++i) {
            for (int j = 0; j < clipboard.get(i).size(); ++j) {
                try {
                    this.table.getModel().setValueAt(clipboard.get(i).get(j), firstRowSelected, temp++);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            temp = firstColSelected;
            ++firstRowSelected;
        }
    }

    public void pasteClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.addContents((String)t.getTransferData(DataFlavor.stringFlavor));
                this.table.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

