/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.jdbc.CompositePrimaryKeyFinder;
import org.geotools.jdbc.HeuristicPrimaryKeyFinder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.MetadataTablePrimaryKeyFinder;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.SessionCommandsListener;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.util.InternationalString;

public abstract class JDBCDataStoreFactory
extends AbstractDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true);
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "Host", true, (Object)"localhost");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true);
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "Database", false);
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "Schema", false);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as");
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, (InternationalString)new SimpleInternationalString("password used to login"), false, null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);
    public static final DataAccessFactory.Param DATASOURCE = new DataAccessFactory.Param("Data Source", DataSource.class, "Data Source", false);
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)new Integer(10));
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)new Integer(1));
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param FETCHSIZE = new DataAccessFactory.Param("fetch size", Integer.class, "number of records read with each iteraction with the dbms", false, (Object)1000);
    public static final DataAccessFactory.Param MAXWAIT = new DataAccessFactory.Param("Connection timeout", Integer.class, "number of seconds the connection pool will wait before timing out attempting to get a new connection (default, 20 seconds)", false, (Object)20);
    public static final DataAccessFactory.Param PK_METADATA_TABLE = new DataAccessFactory.Param("Primary key metadata table", String.class, "The optional table containing primary key structure and sequence associations. Can be expressed as 'schema.name' or just 'name'", false);
    public static final DataAccessFactory.Param MAX_OPEN_PREPARED_STATEMENTS = new DataAccessFactory.Param("Max open prepared statements", Integer.class, "Maximum number of prepared statements kept open and cached for each connection in the pool. Set to 0 to have unbounded caching, to -1 to disable caching", false, (Object)50);
    public static final DataAccessFactory.Param EXPOSE_PK = new DataAccessFactory.Param("Expose primary keys", Boolean.class, "Expose primary key columns as attributes of the feature type", false, (Object)false);
    public static final DataAccessFactory.Param SQL_ON_BORROW = new DataAccessFactory.Param("Session startup SQL", String.class, "SQL statement executed when the connection is grabbed from the pool", false, null, Collections.singletonMap("isLargeText", Boolean.TRUE));
    public static final DataAccessFactory.Param SQL_ON_RELEASE = new DataAccessFactory.Param("Session close-up SQL", String.class, "SQL statement executed when the connection is released to the pool", false, null, Collections.singletonMap("isLargeText", Boolean.TRUE));

    public String getDisplayName() {
        return this.getDescription();
    }

    public boolean canProcess(Map params) {
        if (!super.canProcess(params)) {
            return false;
        }
        return this.checkDBType(params);
    }

    protected boolean checkDBType(Map params) {
        return this.checkDBType(params, this.getDatabaseID());
    }

    protected final boolean checkDBType(Map params, String dbtype) {
        try {
            String type = (String)DBTYPE.lookUp(params);
            return dbtype.equals(type);
        }
        catch (IOException e) {
            return false;
        }
    }

    public final JDBCDataStore createDataStore(Map params) throws IOException {
        Boolean exposePk;
        String metadataTable;
        String schema;
        String namespace;
        JDBCDataStore dataStore = new JDBCDataStore();
        SQLDialect dialect = this.createSQLDialect(dataStore);
        dataStore.setSQLDialect(dialect);
        DataSource ds = (DataSource)DATASOURCE.lookUp(params);
        if (ds != null) {
            dataStore.setDataSource(ds);
        } else {
            dataStore.setDataSource(this.createDataSource(params, dialect));
        }
        Integer fetchSize = (Integer)FETCHSIZE.lookUp(params);
        if (fetchSize != null && fetchSize > 0) {
            dataStore.setFetchSize(fetchSize);
        }
        if ((namespace = (String)NAMESPACE.lookUp(params)) != null) {
            dataStore.setNamespaceURI(namespace);
        }
        if ((schema = (String)SCHEMA.lookUp(params)) != null) {
            dataStore.setDatabaseSchema(schema);
        }
        if ((metadataTable = (String)PK_METADATA_TABLE.lookUp(params)) != null) {
            MetadataTablePrimaryKeyFinder tableFinder = new MetadataTablePrimaryKeyFinder();
            if (metadataTable.contains(".")) {
                String[] parts = metadataTable.split("\\.");
                if (parts.length > 2) {
                    throw new IllegalArgumentException("The primary key metadata table format is either 'name' or 'schema.name'");
                }
                tableFinder.setTableSchema(parts[0]);
                tableFinder.setTableName(parts[1]);
            } else {
                tableFinder.setTableSchema(metadataTable);
            }
            dataStore.setPrimaryKeyFinder(new CompositePrimaryKeyFinder(tableFinder, new HeuristicPrimaryKeyFinder()));
        }
        if ((exposePk = (Boolean)EXPOSE_PK.lookUp(params)) != null) {
            dataStore.setExposePrimaryKeyColumns(exposePk);
        }
        String sqlOnBorrow = (String)SQL_ON_BORROW.lookUp(params);
        String sqlOnRelease = (String)SQL_ON_RELEASE.lookUp(params);
        if (sqlOnBorrow != null || sqlOnRelease != null) {
            SessionCommandsListener listener = new SessionCommandsListener(sqlOnBorrow, sqlOnRelease);
            dataStore.getConnectionLifecycleListeners().add(listener);
        }
        dataStore.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        dataStore.setGeometryFactory(new GeometryFactory());
        dataStore.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        dataStore.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        dataStore.setDataStoreFactory((DataStoreFactorySpi)((Object)this));
        return this.createDataStoreInternal(dataStore, params);
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        return dataStore;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final DataAccessFactory.Param[] getParametersInfo() {
        LinkedHashMap map = new LinkedHashMap();
        this.setupParameters(map);
        return map.values().toArray(new DataAccessFactory.Param[map.size()]);
    }

    protected void setupParameters(Map parameters) {
        parameters.put(JDBCDataStoreFactory.DBTYPE.key, new DataAccessFactory.Param(JDBCDataStoreFactory.DBTYPE.key, JDBCDataStoreFactory.DBTYPE.type, JDBCDataStoreFactory.DBTYPE.description, JDBCDataStoreFactory.DBTYPE.required, (Object)this.getDatabaseID()));
        parameters.put(JDBCDataStoreFactory.HOST.key, HOST);
        parameters.put(JDBCDataStoreFactory.PORT.key, PORT);
        parameters.put(JDBCDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(JDBCDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(JDBCDataStoreFactory.USER.key, USER);
        parameters.put(JDBCDataStoreFactory.PASSWD.key, PASSWD);
        parameters.put(JDBCDataStoreFactory.NAMESPACE.key, NAMESPACE);
        parameters.put(JDBCDataStoreFactory.EXPOSE_PK.key, EXPOSE_PK);
        parameters.put(JDBCDataStoreFactory.MAXCONN.key, MAXCONN);
        parameters.put(JDBCDataStoreFactory.MINCONN.key, MINCONN);
        parameters.put(JDBCDataStoreFactory.FETCHSIZE.key, FETCHSIZE);
        parameters.put(JDBCDataStoreFactory.MAXWAIT.key, MAXWAIT);
        if (this.getValidationQuery() != null) {
            parameters.put(JDBCDataStoreFactory.VALIDATECONN.key, VALIDATECONN);
        }
        parameters.put(JDBCDataStoreFactory.PK_METADATA_TABLE.key, PK_METADATA_TABLE);
        parameters.put(JDBCDataStoreFactory.SQL_ON_BORROW.key, SQL_ON_BORROW);
        parameters.put(JDBCDataStoreFactory.SQL_ON_RELEASE.key, SQL_ON_RELEASE);
    }

    public boolean isAvailable() {
        try {
            Class.forName(this.getDriverClassName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    protected abstract String getDatabaseID();

    protected abstract String getDriverClassName();

    protected abstract SQLDialect createSQLDialect(JDBCDataStore var1);

    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        BasicDataSource dataSource = this.createDataSource(params);
        if (dialect instanceof PreparedStatementSQLDialect) {
            dataSource.setPoolPreparedStatements(true);
            HashMap testMap = new HashMap();
            this.setupParameters(testMap);
            if (testMap.containsKey(JDBCDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key)) {
                Integer maxPreparedStatements = (Integer)MAX_OPEN_PREPARED_STATEMENTS.lookUp(params);
                if (maxPreparedStatements != null && maxPreparedStatements > 0) {
                    dataSource.setMaxOpenPreparedStatements(maxPreparedStatements.intValue());
                }
                if (maxPreparedStatements != null && maxPreparedStatements < 0) {
                    dataSource.setPoolPreparedStatements(false);
                }
            }
        }
        return new DBCPDataSource(dataSource);
    }

    public BasicDataSource createDataSource(Map params) throws IOException {
        Boolean validate;
        Integer maxConn;
        Integer minConn;
        Integer maxWait;
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        String user = (String)USER.lookUp(params);
        dataSource.setUsername(user);
        String passwd = (String)PASSWD.lookUp(params);
        if (passwd != null) {
            dataSource.setPassword(passwd);
        }
        if ((maxWait = (Integer)MAXWAIT.lookUp(params)) != null && maxWait != -1) {
            dataSource.setMaxWait((long)(maxWait * 1000));
        }
        if ((minConn = (Integer)MINCONN.lookUp(params)) != null) {
            dataSource.setMinIdle(minConn.intValue());
        }
        if ((maxConn = (Integer)MAXCONN.lookUp(params)) != null) {
            dataSource.setMaxActive(maxConn.intValue());
        }
        if ((validate = (Boolean)VALIDATECONN.lookUp(params)) != null && validate.booleanValue() && this.getValidationQuery() != null) {
            dataSource.setTestOnBorrow(true);
            dataSource.setValidationQuery(this.getValidationQuery());
        }
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        return dataSource;
    }

    protected abstract String getValidationQuery();

    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        String url = "jdbc:" + this.getDatabaseID() + "://" + host;
        if (port != null) {
            url = url + ":" + port;
        }
        if (db != null) {
            url = url + "/" + db;
        }
        return url;
    }
}

