/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.renderer.jgrass;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class RasterRenderer
extends RendererImpl {
    private static final String THE_MAP_IS_OUTSIDE_OF_THE_VISIBLE_REGION = "The map is outside of the visible region.";

    public void render(Graphics2D g2d, IProgressMonitor monitor) throws RenderException {
        try {
            JGrassRegion screenDrawWindow;
            IRenderContext currentContext = this.getContext();
            currentContext.setStatus(1);
            CoordinateReferenceSystem destinationCRS = currentContext.getCRS();
            ReferencedEnvelope envelope = this.getRenderBounds();
            if (envelope == null || envelope.isNull()) {
                envelope = this.context.getImageBounds();
            }
            Point upperLeft = currentContext.worldToPixel(new Coordinate(envelope.getMinX(), envelope.getMinY()));
            Point bottomRight = currentContext.worldToPixel(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
            Rectangle screenSize = new Rectangle(upperLeft);
            screenSize.add(bottomRight);
            IGeoResource resource = this.getContext().getGeoResource();
            if (resource == null || !resource.canResolve(JGrassMapGeoResource.class)) {
                return;
            }
            JGrassMapGeoResource grassMapGeoResource = (JGrassMapGeoResource)((Object)resource.resolve(JGrassMapGeoResource.class, monitor));
            JGrassRegion fileWindow = new JGrassRegion(grassMapGeoResource.getFileWindow());
            JGrassMapsetGeoResource parent = (JGrassMapsetGeoResource)grassMapGeoResource.parent((IProgressMonitor)new NullProgressMonitor());
            CoordinateReferenceSystem grassCrs = parent.getLocationCrs();
            JGrassRegion reprojectedScreenDrawWindow = screenDrawWindow = new JGrassRegion(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY(), fileWindow.getRows(), fileWindow.getCols());
            if (!CRS.equalsIgnoreMetadata((Object)destinationCRS, (Object)grassCrs)) {
                reprojectedScreenDrawWindow = screenDrawWindow.reproject(destinationCRS, grassCrs, true);
            }
            Rectangle2D.Double fileRectDouble = fileWindow.getRectangle();
            Rectangle2D.Double reprojScreenRectangle = reprojectedScreenDrawWindow.getRectangle();
            if (!reprojScreenRectangle.intersects(fileRectDouble)) {
                this.getContext().setStatus(0);
                this.getContext().setStatusMessage(THE_MAP_IS_OUTSIDE_OF_THE_VISIBLE_REGION);
                System.out.println(THE_MAP_IS_OUTSIDE_OF_THE_VISIBLE_REGION);
                return;
            }
            Rectangle2D drawMapRectangle = reprojectedScreenDrawWindow.getRectangle().createIntersection(fileRectDouble);
            double ewRes = fileWindow.getWEResolution();
            double nsRes = fileWindow.getNSResolution();
            if (fileRectDouble.getWidth() < ewRes || fileRectDouble.getHeight() < nsRes) {
                this.getContext().setStatus(0);
                this.getContext().setStatusMessage(THE_MAP_IS_OUTSIDE_OF_THE_VISIBLE_REGION);
                System.out.println(THE_MAP_IS_OUTSIDE_OF_THE_VISIBLE_REGION);
                return;
            }
            try {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)destinationCRS, (CoordinateReferenceSystem)grassCrs, (boolean)true);
                Coordinate pixelSize = this.getContext().getPixelSize();
                Coordinate c1 = new Coordinate(envelope.getMinX(), envelope.getMinY());
                Coordinate c2 = new Coordinate(envelope.getMinX() + pixelSize.x, envelope.getMinY() + pixelSize.y);
                Envelope envy = new Envelope(c1, c2);
                Envelope envyTrans = JTS.transform((Envelope)envy, (MathTransform)transform);
                pixelSize = new Coordinate(envyTrans.getWidth(), envyTrans.getHeight());
                if (ewRes < pixelSize.x) {
                    ewRes = pixelSize.x;
                }
                if (nsRes < pixelSize.y) {
                    nsRes = pixelSize.y;
                }
                fileWindow.setNSResolution(nsRes);
                fileWindow.setWEResolution(ewRes);
                nsRes = fileWindow.getNSResolution();
                ewRes = fileWindow.getWEResolution();
                JGrassRegion activeWindow = grassMapGeoResource.getActiveWindow();
                Coordinate minXY = JGrassRegion.snapToNextHigherInRegionResolution((double)drawMapRectangle.getMinX(), (double)drawMapRectangle.getMinY(), (JGrassRegion)activeWindow);
                Coordinate maxXY = JGrassRegion.snapToNextHigherInRegionResolution((double)drawMapRectangle.getMaxX(), (double)drawMapRectangle.getMaxY(), (JGrassRegion)activeWindow);
                JGrassRegion drawMapRegion = new JGrassRegion(minXY.x, maxXY.x, minXY.y, maxXY.y, ewRes, nsRes);
                JGrassMapEnvironment grassMapEnvironment = grassMapGeoResource.getjGrassMapEnvironment();
                GridCoverage2D coverage = JGrassCatalogUtilities.getGridcoverageFromGrassraster(grassMapEnvironment, drawMapRegion);
                coverage = coverage.view(ViewType.RENDERED);
                if (coverage != null) {
                    RenderingHints hints = new RenderingHints(Collections.EMPTY_MAP);
                    hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
                    hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
                    hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                    hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
                    hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, new InterpolationNearest()));
                    g2d.addRenderingHints(hints);
                    TileCache tempCache = JAI.createTileCache();
                    tempCache.setMemoryCapacity(0x1000000L);
                    tempCache.setMemoryThreshold(1.0f);
                    hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, tempCache));
                    AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((Envelope)envelope, (Rectangle)screenSize, (CoordinateReferenceSystem)destinationCRS);
                    GridCoverageRenderer paint = new GridCoverageRenderer(destinationCRS, (Envelope)envelope, screenSize, worldToScreen, hints);
                    RasterSymbolizer rasterSymbolizer = CommonFactoryFinder.getStyleFactory(null).createRasterSymbolizer();
                    paint.paint(g2d, coverage, rasterSymbolizer);
                    tempCache.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.getContext().setStatus(0);
            this.getContext().setStatusMessage(null);
        }
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        Graphics2D g2d = this.getContext().getImage().createGraphics();
        this.render(g2d, monitor);
    }

    public void dispose() {
    }
}

