/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.workspacecreation;

import eu.udig.catalog.jgrass.workspacecreation.NewJGrassLocationFromFileWizard;
import eu.udig.catalog.jgrass.workspacecreation.WorkspaceProperties;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class W11CreateLocationFromFileWizardPage
extends WizardPage {
    public static final String ID = "W11CreateLocationFromFileWizardPage";
    private final WorkspaceProperties properties;

    public W11CreateLocationFromFileWizardPage(WorkspaceProperties properties) {
        super(ID);
        this.properties = properties;
        this.setTitle("Setting the file and location info");
        this.setDescription("In this page the user is asked to supply the file to import and info for the creation of the location.");
    }

    public void createControl(Composite maxparent) {
        Composite parent = new Composite(maxparent, 0);
        parent.setLayout((Layout)new GridLayout());
        Group fileimportGroup = new Group(parent, 0);
        fileimportGroup.setLayout((Layout)new GridLayout(2, false));
        fileimportGroup.setLayoutData((Object)new GridData(1808));
        fileimportGroup.setText("choose a file for which to create a location and mapset");
        final Text fileText = new Text((Composite)fileimportGroup, 2048);
        fileText.setLayoutData((Object)new GridData(1796));
        fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = fileText.getText();
                if (W11CreateLocationFromFileWizardPage.this.isImportFileValid(path)) {
                    ((W11CreateLocationFromFileWizardPage)W11CreateLocationFromFileWizardPage.this).properties.importFilePath = path;
                }
            }
        });
        final Button fileChooseButton = new Button((Composite)fileimportGroup, 2048);
        fileChooseButton.setText("...");
        fileChooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(fileChooseButton.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.asc", "*.tif", "*.tiff"});
                String path = fileDialog.open();
                if (path != null) {
                    path = path.replaceAll("\\s+", "_");
                }
                if (W11CreateLocationFromFileWizardPage.this.isImportFileValid(path)) {
                    ((W11CreateLocationFromFileWizardPage)W11CreateLocationFromFileWizardPage.this).properties.importFilePath = path;
                    fileText.setText(path);
                }
            }
        });
        Group baseFolderGroup = new Group(parent, 0);
        baseFolderGroup.setLayout((Layout)new GridLayout(2, false));
        baseFolderGroup.setLayoutData((Object)new GridData(1808));
        baseFolderGroup.setText("choose a folder in which to create the new location");
        final Text baseFolderText = new Text((Composite)baseFolderGroup, 2048);
        baseFolderText.setLayoutData((Object)new GridData(1796));
        baseFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = baseFolderText.getText();
                if (W11CreateLocationFromFileWizardPage.this.isBaseFolderValid(path)) {
                    ((W11CreateLocationFromFileWizardPage)W11CreateLocationFromFileWizardPage.this).properties.basePath = path;
                }
            }
        });
        final Button locationPathChooseButton = new Button((Composite)baseFolderGroup, 2048);
        locationPathChooseButton.setText("...");
        locationPathChooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fileDialog = new DirectoryDialog(locationPathChooseButton.getShell(), 4096);
                String path = fileDialog.open();
                if (path != null) {
                    path = path.replaceAll("\\s+", "_");
                }
                if (W11CreateLocationFromFileWizardPage.this.isBaseFolderValid(path)) {
                    ((W11CreateLocationFromFileWizardPage)W11CreateLocationFromFileWizardPage.this).properties.basePath = path;
                    baseFolderText.setText(path);
                }
            }
        });
        Group locationGroup = new Group(parent, 0);
        locationGroup.setLayout((Layout)new GridLayout(2, false));
        locationGroup.setLayoutData((Object)new GridData(1808));
        locationGroup.setText("enter a name for the new location");
        final Text locationText = new Text((Composite)locationGroup, 2048);
        locationText.setLayoutData((Object)new GridData(1796));
        locationText.setText("newLocation");
        locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String locName = locationText.getText();
                if (W11CreateLocationFromFileWizardPage.this.isLocationNameValid(locName)) {
                    ((W11CreateLocationFromFileWizardPage)W11CreateLocationFromFileWizardPage.this).properties.locationName = locName;
                }
            }
        });
        Group mapsetGroup = new Group(parent, 0);
        mapsetGroup.setLayout((Layout)new GridLayout(2, false));
        mapsetGroup.setLayoutData((Object)new GridData(1808));
        mapsetGroup.setText("enter a name for the new mapset");
        final Text mapsetText = new Text((Composite)mapsetGroup, 2048);
        mapsetText.setLayoutData((Object)new GridData(1796));
        mapsetText.setText("newMapset");
        mapsetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String mapsetName = mapsetText.getText();
                if (W11CreateLocationFromFileWizardPage.this.isMpasetNameValid(mapsetName)) {
                    ((W11CreateLocationFromFileWizardPage)W11CreateLocationFromFileWizardPage.this).properties.mapsetName = mapsetName;
                }
            }
        });
        this.setControl((Control)parent);
    }

    private boolean isImportFileValid(String path) {
        if (path != null && new File(path).exists() && (path.endsWith(".asc") || path.endsWith(".tif") || path.endsWith(".tiff"))) {
            this.setErrorMessage(null);
            this.canFinish(true);
            return true;
        }
        this.setErrorMessage("Only esrii ascii and geotiffs are supported.");
        this.canFinish(false);
        return false;
    }

    private boolean isBaseFolderValid(String path) {
        if (path != null && new File(path).exists()) {
            this.setErrorMessage(null);
            this.canFinish(true);
            return true;
        }
        this.setErrorMessage("The base folder is a needed parameter.");
        this.canFinish(false);
        return false;
    }

    private boolean isLocationNameValid(String locationName) {
        if (locationName != null && locationName.length() > 0) {
            this.setErrorMessage(null);
            this.canFinish(true);
            return true;
        }
        this.setErrorMessage("The location name is a needed parameter.");
        this.canFinish(false);
        return false;
    }

    private boolean isMpasetNameValid(String mapsetName) {
        if (mapsetName != null && mapsetName.length() > 0) {
            this.setErrorMessage(null);
            this.canFinish(true);
            return true;
        }
        this.setErrorMessage("The mapset name is a needed parameter.");
        this.canFinish(false);
        return false;
    }

    private void canFinish(boolean doFinish) {
        ((NewJGrassLocationFromFileWizard)this.getWizard()).canFinish = doFinish;
        this.getWizard().getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((NewJGrassLocationFromFileWizard)this.getWizard()).canFinish = false;
            this.getWizard().getContainer().updateButtons();
        }
        super.setVisible(visible);
    }
}

