/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.workspacecreation;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.catalog.jgrass.workspacecreation.W11CreateLocationFromFileWizardPage;
import eu.udig.catalog.jgrass.workspacecreation.WorkspaceProperties;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.grassraster.GrassCoverageWriter;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NewJGrassLocationFromFileWizard
extends Wizard
implements INewWizard {
    public boolean canFinish = false;
    private WorkspaceProperties props;

    public NewJGrassLocationFromFileWizard() {
        this.setWindowTitle("Creation of a new JGrass location");
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/simulwizard.png"));
    }

    public void addPages() {
        this.props = new WorkspaceProperties();
        this.props.locationName = "newLocation";
        this.props.mapsetName = "newMapset";
        W11CreateLocationFromFileWizardPage page1 = new W11CreateLocationFromFileWizardPage(this.props);
        this.addPage((IWizardPage)page1);
    }

    public boolean performFinish() {
        try {
            String importFilePath = this.props.importFilePath;
            File mapFile = new File(importFilePath);
            CoordinateReferenceSystem fileCrs = null;
            GridCoverage2D geodata = null;
            if (mapFile.getName().endsWith(".asc")) {
                ArcGridReader arcGridReader = new ArcGridReader((Object)mapFile);
                geodata = arcGridReader.read(null);
                geodata = geodata.view(ViewType.GEOPHYSICS);
                geodata = JGrassCatalogUtilities.removeNovalues(geodata);
                fileCrs = arcGridReader.getCrs();
            } else if (mapFile.getName().endsWith(".tif") || mapFile.getName().endsWith(".tiff")) {
                GeoTiffReader geotiffGridReader = new GeoTiffReader((Object)mapFile);
                geodata = geotiffGridReader.read(null);
                geodata = geodata.view(ViewType.GEOPHYSICS);
                geodata = JGrassCatalogUtilities.removeNovalues(geodata);
                fileCrs = geotiffGridReader.getCrs();
            }
            HashMap<String, Double> regionParams = JGrassCatalogUtilities.getRegionParamsFromGridCoverage(geodata);
            double n = regionParams.get("NORTH");
            double s = regionParams.get("SOUTH");
            double e = regionParams.get("EAST");
            double w = regionParams.get("WEST");
            double xres = regionParams.get("XRES");
            double yres = regionParams.get("YRES");
            JGrassRegion window = new JGrassRegion(w, e, s, n, xres, yres);
            File baseFolderFile = new File(this.props.basePath);
            File locationFile = new File(baseFolderFile, this.props.locationName);
            File mapsetFile = new File(locationFile, this.props.mapsetName);
            String locationPath = locationFile.getAbsolutePath();
            JGrassCatalogUtilities.createLocation(locationPath, fileCrs, window);
            JGrassCatalogUtilities.createMapset(locationPath, mapsetFile.getName(), null, null);
            JGrassRegion.writeWINDToMapset((String)mapsetFile.getAbsolutePath(), (JGrassRegion)window);
            String mapName = mapFile.getName();
            mapName = FilenameUtils.getBaseName((String)mapName);
            JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(mapsetFile, mapName);
            GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
            GrassCoverageWriter writer = format.getWriter((Object)mapEnvironment.getCELL(), null);
            GeneralParameterValue[] readParams = null;
            writer.write((GridCoverage)geodata, readParams);
            JGrassCatalogUtilities.addServiceToCatalog(String.valueOf(locationPath) + File.separator + "wks.jgrass", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.workspacecreation.wizard#NewJGrassLocationWizard#performFinish", e);
            e.printStackTrace();
        }
        return true;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

