/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.utils;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.core.JGrassService;
import java.awt.geom.AffineTransform;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.RasterFactory;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.memory.MemoryServiceExtensionImpl;
import net.refractions.udig.catalog.memory.internal.MemoryServiceImpl;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.gce.grassraster.GrassCoverageWriter;
import org.geotools.gce.grassraster.JGrassConstants;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGrassCatalogUtilities {
    public static final String GRASSMAPSET = "grassmapset";
    public static final String GRASSLOCATION = "grasslocation";
    public static final String JGRASS_WORKSPACE_FILENAME = "wks.jgrass";
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String EAST = "EAST";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";

    public static synchronized String[] getMapsetpathAndMapnameFromJGrassMapGeoResource(IGeoResource resource) {
        String[] mapsetPathAndMapName = new String[2];
        if (resource == null || !resource.canResolve(JGrassMapGeoResource.class)) {
            return null;
        }
        JGrassMapGeoResource mapResource = null;
        try {
            mapResource = (JGrassMapGeoResource)((Object)resource.resolve(JGrassMapGeoResource.class, null));
        }
        catch (IOException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#getMapsetpathAndMapnameFromJGrassMapGeoResource", e);
            e.printStackTrace();
            return null;
        }
        JGrassMapsetGeoResource mapsetResource = null;
        try {
            mapsetResource = (JGrassMapsetGeoResource)mapResource.parent(null);
            mapsetPathAndMapName[0] = mapsetResource.getFile().getAbsolutePath();
            mapsetPathAndMapName[1] = mapResource.getTitle();
        }
        catch (IOException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#getMapsetpathAndMapnameFromJGrassMapGeoResource", e);
            e.printStackTrace();
        }
        return mapsetPathAndMapName;
    }

    public static synchronized String getDirectPathFromJGrassMapGeoResource(IGeoResource resource) {
        String mapPath = null;
        if (resource == null || !resource.canResolve(JGrassMapGeoResource.class)) {
            return null;
        }
        JGrassMapGeoResource jg = null;
        try {
            jg = (JGrassMapGeoResource)((Object)resource.resolve(JGrassMapGeoResource.class, null));
        }
        catch (IOException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#getDirectPathFromJGrassMapGeoResource", e);
            e.printStackTrace();
            return null;
        }
        mapPath = URLUtils.urlToFile((URL)jg.getIdentifier()).getAbsolutePath();
        return mapPath;
    }

    public static synchronized void addServiceToCatalog(String serviceFile, IProgressMonitor progressMonitor) {
        try {
            URL fileUrl = new File(serviceFile).toURI().toURL();
            IServiceFactory sFactory = CatalogPlugin.getDefault().getServiceFactory();
            ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
            List services = sFactory.createService(fileUrl);
            for (IService service : services) {
                catalog.add(service);
            }
        }
        catch (Exception e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#addServiceToCatalog", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshJGrassService(String locationPath, IProgressMonitor monitor) {
        System.out.println("Lock on locationPath = " + Thread.holdsLock(locationPath));
        String string = locationPath;
        synchronized (string) {
            ID id = null;
            if (JGrassPlugin.getDefault() != null) {
                File locationFile = new File(locationPath);
                try {
                    id = new ID(locationFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
            } else {
                return;
            }
            final ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
            final JGrassService originalJGrassService = (JGrassService)catalog.getById(JGrassService.class, id, monitor);
            if (originalJGrassService == null) {
                return;
            }
            URL ID2 = originalJGrassService.getIdentifier();
            Map<String, Serializable> connectionParams = originalJGrassService.getConnectionParams();
            IServiceFactory locator = CatalogPlugin.getDefault().getServiceFactory();
            final List rereadService = locator.acquire(ID2, connectionParams);
            if (rereadService.size() > 0) {
                Runnable refreshCatalogRunner = new Runnable(){

                    @Override
                    public void run() {
                        IService newJGrassService = (IService)rereadService.get(0);
                        catalog.remove((IService)originalJGrassService);
                        catalog.add(newJGrassService);
                    }
                };
                new Thread(refreshCatalogRunner).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceFromUrlToMap(URL url, IProgressMonitor progressMonitor, int addPosition, IMap map) {
        URL uRL = url;
        synchronized (uRL) {
            ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
            List matches = catalog.find(url, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 2));
            for (IResolve resolve : matches) {
                List members = null;
                try {
                    ArrayList<IGeoResource> geoResources = new ArrayList<IGeoResource>();
                    members = resolve.members(progressMonitor);
                    if (members.size() < 1 && resolve.canResolve(IGeoResource.class)) {
                        geoResources.add((IGeoResource)resolve.resolve(IGeoResource.class, progressMonitor));
                    } else if (((IResolve)members.get(0)).canResolve(IGeoResource.class)) {
                        for (IResolve tmp : members) {
                            IGeoResource finalResolve = (IGeoResource)tmp.resolve(IGeoResource.class, progressMonitor);
                            geoResources.add(finalResolve);
                        }
                    }
                    List addedLayers = ApplicationGIS.addLayersToMap((IMap)map, geoResources, (int)addPosition);
                    if (addedLayers.size() != 0) continue;
                    System.out.println("strange");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized void removeMemoryServiceByTypeName(String typeName) {
        MemoryServiceImpl service = null;
        try {
            List members = CatalogPlugin.getDefault().getLocalCatalog().members((IProgressMonitor)new NullProgressMonitor());
            for (IResolve resolve : members) {
                if (!(resolve instanceof MemoryServiceImpl) || !URLUtils.urlEquals((URL)resolve.getIdentifier(), (URL)MemoryServiceExtensionImpl.URL, (boolean)true)) continue;
                service = (MemoryServiceImpl)resolve;
                break;
            }
            if (service == null) {
                return;
            }
            MemoryDataStore ds = (MemoryDataStore)service.resolve(MemoryDataStore.class, (IProgressMonitor)new NullProgressMonitor());
            if (Arrays.asList(ds.getTypeNames()).contains(typeName)) {
                CatalogPlugin.getDefault().getLocalCatalog().remove((IService)service);
            }
        }
        catch (IOException e) {
            CatalogPlugin.log((String)"Error finding services", (Throwable)e);
        }
    }

    public static boolean createLocation(String locationPath, CoordinateReferenceSystem crs, JGrassRegion window) {
        if (!new File(locationPath).mkdirs()) {
            return false;
        }
        String jgFile = String.valueOf(locationPath) + File.separator + JGRASS_WORKSPACE_FILENAME;
        File jgF = new File(jgFile);
        try {
            jgF.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JGrassCatalogUtilities.createMapset(locationPath, "PERMANENT", crs, window);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean createMapset(String locationPath, String mapset, CoordinateReferenceSystem crs, JGrassRegion window) {
        path = String.valueOf(locationPath) + File.separator + mapset;
        if (!new File(path).mkdirs()) {
            return false;
        }
        if (mapset.equals("PERMANENT")) {
            try {
                if (window != null) {
                    JGrassRegion.writeWINDToMapset((String)path, (JGrassRegion)window);
                    JGrassRegion.writeDEFAULTWINDToLocation((String)locationPath, (JGrassRegion)window);
                } else {
                    out = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + "DEFAULT_WIND"));
                    out.write("eu.hydrologis.jgrass.libs.region");
                    out.close();
                    out = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + "WIND"));
                    out.write("proj:           0\nzone:           0\nnorth:          1\nsouth:          0\nwest:           0\neast:           1\nrows:           1\ncols:           1\ne-w resol:      1\nn-s resol:      1");
                    out.close();
                }
                if (crs == null) ** GOTO lbl39
                prjOut = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + "PROJ_INFO.WKT"));
                prjOut.write(crs.toWKT());
                prjOut.close();
            }
            catch (IOException e) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#createMapset", e);
                e.printStackTrace();
                return false;
            }
        } else {
            try {
                in = new BufferedReader(new FileReader(String.valueOf(locationPath) + File.separator + "PERMANENT" + File.separator + "DEFAULT_WIND"));
                out = new BufferedWriter(new FileWriter(String.valueOf(path) + File.separator + "WIND"));
                while ((line = in.readLine()) != null) {
                    out.write(line);
                    out.write("\n");
                }
                out.close();
                in.close();
            }
            catch (IOException e) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#createMapset", e);
                e.printStackTrace();
                return false;
            }
        }
lbl39:
        // 3 sources

        if (!new File(String.valueOf(path) + File.separator + "site_lists").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "fcell").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "cell").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "cellhd").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "cats").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "colr").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "cell_misc").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "dig").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "dig_atts").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(path) + File.separator + "dig_cats").mkdirs()) {
            return false;
        }
        return JGrassCatalogUtilities.createJGrassFolders(path) != false;
    }

    public static boolean createJGrassFolders(String mapsetpath) {
        if (!new File(String.valueOf(mapsetpath) + File.separator + "grassascii").exists() && !new File(String.valueOf(mapsetpath) + File.separator + "grassascii").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(mapsetpath) + File.separator + "fluidturtleascii").exists() && !new File(String.valueOf(mapsetpath) + File.separator + "fluidturtleascii").mkdirs()) {
            return false;
        }
        if (!new File(String.valueOf(mapsetpath) + File.separator + "esriasciigrid").exists() && !new File(String.valueOf(mapsetpath) + File.separator + "esriasciigrid").mkdirs()) {
            return false;
        }
        return new File(String.valueOf(mapsetpath) + File.separator + JGrassConstants.HORTON_MACHINE_PATH).exists() || new File(String.valueOf(mapsetpath) + File.separator + JGrassConstants.HORTON_MACHINE_PATH).mkdirs();
    }

    public static synchronized CoordinateReferenceSystem getLocationCrs(String locationPath) {
        CoordinateReferenceSystem readCrs = null;
        BufferedReader crsReader = null;
        try {
            try {
                String projWtkFilePath = String.valueOf(locationPath) + File.separator + "PERMANENT" + File.separator + "PROJ_INFO.WKT";
                File projWtkFile = new File(projWtkFilePath);
                if (projWtkFile.exists()) {
                    crsReader = new BufferedReader(new FileReader(projWtkFile));
                    StringBuffer wtkString = new StringBuffer();
                    String line = null;
                    while ((line = crsReader.readLine()) != null) {
                        wtkString.append(line.trim());
                    }
                    readCrs = CRS.parseWKT((String)wtkString.toString());
                }
            }
            catch (Exception e1) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassMapsetGeoResource#getJGrassCrs", e1);
                e1.printStackTrace();
                try {
                    if (crsReader != null) {
                        crsReader.close();
                    }
                }
                catch (IOException e) {
                    JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassMapsetGeoResource#getJGrassCrs", e);
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (crsReader != null) {
                    crsReader.close();
                }
            }
            catch (IOException e) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassMapsetGeoResource#getJGrassCrs", e);
                e.printStackTrace();
            }
        }
        return readCrs;
    }

    public static ILayer getMapgraphicLayerByClass(Class<?> theClass) {
        try {
            List mapgraphics = CatalogPlugin.getDefault().getLocalCatalog().find(MapGraphicService.SERVICE_URL, null);
            List members = ((IResolve)mapgraphics.get(0)).members(null);
            for (IResolve resolve : members) {
                if (!resolve.canResolve(theClass)) continue;
                IGeoResource resolve2 = (IGeoResource)resolve.resolve(IGeoResource.class, null);
                String resName = resolve2.getInfo((IProgressMonitor)new NullProgressMonitor()).getName();
                List mapLayers = ApplicationGIS.getActiveMap().getMapLayers();
                for (ILayer layer : mapLayers) {
                    if (!layer.getName().trim().equals(resName.trim())) continue;
                    return layer;
                }
            }
        }
        catch (IOException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.utils#JGrassCatalogUtilities#getMapgraphicLayerByClass", e);
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static synchronized JGrassMapGeoResource addMapToCatalog(String locationPath, String mapsetName, String mapName, String mapType) {
        JGrassMapsetGeoResource mapset = null;
        try {
            File locationFile = new File(locationPath);
            ID locationId = new ID(locationFile.toURI().toURL());
            URL mapsetUrl = JGrassMapsetGeoResource.createId(locationFile.getAbsolutePath(), mapsetName);
            ID mapsetId = new ID(mapsetUrl);
            ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
            mapset = (JGrassMapsetGeoResource)localCatalog.getById(JGrassMapsetGeoResource.class, mapsetId, ProgressManager.instance().get(new Object[0]));
            if (mapset == null) {
                JGrassService locationService = (JGrassService)localCatalog.getById(JGrassService.class, locationId, ProgressManager.instance().get(new Object[0]));
                mapset = locationService.getMapsetGeoresourceByName(mapsetName);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            String message = "An error occurred while adding the map to the catalog";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
        }
        if (mapset == null) {
            return null;
        }
        return mapset.addMap(mapName, mapType);
    }

    public static synchronized void removeMapFromCatalog(String locationPath, String mapsetName, String mapName, String mapType) {
        File locationFile = new File(locationPath);
        URL mapsetUrl = JGrassMapsetGeoResource.createId(locationFile.getAbsolutePath(), mapsetName);
        ID mapsetId = new ID(mapsetUrl);
        JGrassMapsetGeoResource mapset = (JGrassMapsetGeoResource)CatalogPlugin.getDefault().getLocalCatalog().getById(JGrassMapsetGeoResource.class, mapsetId, ProgressManager.instance().get(new Object[0]));
        mapset.removeMap(mapName, mapType);
    }

    public static synchronized JGrassMapsetGeoResource addMapsetToCatalog(String locationPath, String mapsetName) {
        File locationFile = new File(locationPath);
        try {
            ID locationId = new ID(locationFile.toURI().toURL());
            JGrassService location = (JGrassService)CatalogPlugin.getDefault().getLocalCatalog().getById(JGrassService.class, locationId, ProgressManager.instance().get(new Object[0]));
            return location.addMapset(mapsetName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            String message = "An error occurred while adding the mapset to the catalog";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
            return null;
        }
    }

    public static synchronized void removeMapsetFromCatalog(String locationPath, String mapsetName) {
        try {
            File locationFile = new File(locationPath);
            ID locationId = new ID(locationFile.toURI().toURL());
            JGrassService location = (JGrassService)CatalogPlugin.getDefault().getLocalCatalog().getById(JGrassService.class, locationId, ProgressManager.instance().get(new Object[0]));
            location.removeMapset(mapsetName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            String message = "An error occurred while removing the mapset to the catalog";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
        }
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }

    public static GridCoverage2D getGridcoverageFromGrassraster(JGrassMapEnvironment jGrassMapEnvironment, JGrassRegion readRegion) throws Exception {
        CoordinateReferenceSystem crs = jGrassMapEnvironment.getCoordinateReferenceSystem();
        JGrassRegion jGrassRegion = readRegion;
        if (jGrassRegion == null) {
            jGrassRegion = jGrassMapEnvironment.getActiveRegion();
        }
        GeneralParameterValue[] readParams = JGrassCatalogUtilities.createGridGeometryGeneralParameter(jGrassRegion.getCols(), jGrassRegion.getRows(), jGrassRegion.getNorth(), jGrassRegion.getSouth(), jGrassRegion.getWest(), jGrassRegion.getEast(), crs);
        GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
        AbstractGridCoverage2DReader reader = format.getReader((Object)jGrassMapEnvironment.getCELL());
        GridCoverage2D mapCoverage = (GridCoverage2D)reader.read(readParams);
        return mapCoverage;
    }

    public static void writeGridCoverageFromGrassraster(File mapFile, JGrassRegion writeRegion, GridCoverage2D grassCoverage) throws Exception {
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(mapFile);
        GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
        GrassCoverageWriter writer = format.getWriter((Object)mapEnvironment.getCELL(), null);
        GeneralParameterValue[] readParams = null;
        if (writeRegion == null) {
            writeRegion = mapEnvironment.getActiveRegion();
        }
        readParams = JGrassCatalogUtilities.createGridGeometryGeneralParameter(writeRegion.getCols(), writeRegion.getRows(), writeRegion.getNorth(), writeRegion.getSouth(), writeRegion.getEast(), writeRegion.getWest(), mapEnvironment.getCoordinateReferenceSystem());
        writer.write((GridCoverage)grassCoverage, readParams);
    }

    public static String[] filesOfRasterMap(String mapsetPath, String mapname) {
        String[] filesOfRaster = new String[]{String.valueOf(mapsetPath) + File.separator + "fcell" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cell" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cats" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "hist" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cellhd" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "colr" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_format", String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_quant", String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_range", String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "null"};
        return filesOfRaster;
    }

    public static GridCoverage2D removeNovalues(GridCoverage2D geodata) {
        HashMap<String, Double> params = JGrassCatalogUtilities.getRegionParamsFromGridCoverage(geodata);
        int height = params.get(ROWS).intValue();
        int width = params.get(COLS).intValue();
        WritableRaster tmpWR = JGrassCatalogUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter tmpIter = RandomIterFactory.createWritable((WritableRaster)tmpWR, null);
        RenderedImage readRI = geodata.getRenderedImage();
        RandomIter readIter = RandomIterFactory.create((RenderedImage)readRI, null);
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                double value = readIter.getSampleDouble(c, r, 0);
                if (Double.isNaN(value) || Float.isNaN((float)value) || Math.abs(value - -9999.0) < 1.0E-7) {
                    tmpIter.setSample(c, r, 0, Double.NaN);
                } else {
                    tmpIter.setSample(c, r, 0, value);
                }
                ++c;
            }
            ++r;
        }
        geodata = JGrassCatalogUtilities.buildCoverage("newcoverage", tmpWR, params, geodata.getCoordinateReferenceSystem());
        return geodata;
    }

    public static GridCoverage2D buildCoverage(String name, WritableRaster writableRaster, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        Envelope2D writeEnvelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)name, writableRaster, (Envelope)writeEnvelope);
        return coverage2D;
    }

    public static WritableRaster createDoubleWritableRaster(int width, int height, Class<?> dataClass, SampleModel sampleModel, Double value) {
        int dataType = 5;
        if (dataClass != null) {
            if (dataClass.isAssignableFrom(Integer.class)) {
                dataType = 3;
            } else if (dataClass.isAssignableFrom(Float.class)) {
                dataType = 4;
            } else if (dataClass.isAssignableFrom(Byte.class)) {
                dataType = 0;
            }
        }
        if (sampleModel == null) {
            sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[1]);
        }
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        if (value != null) {
            double v = value;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    raster.setSample(x, y, 0, v);
                    ++x;
                }
                ++y;
            }
        }
        return raster;
    }

    public static HashMap<String, Double> getRegionParamsFromGridCoverage(GridCoverage2D gridCoverage) {
        HashMap<String, Double> envelopeParams = new HashMap<String, Double>();
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }
}

