/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.commands.DeleteLayersCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;

public class RenameMapAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        block11: {
                            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                            Object map = (this).RenameMapAction.this.selection.getFirstElement();
                            try {
                                String newMapName;
                                String mapsetName;
                                String oldMapName;
                                JGrassMapGeoResource mr;
                                block12: {
                                    String type;
                                    pm.beginTask("Renaming map...", -1);
                                    pm.worked(1);
                                    if (!(map instanceof JGrassMapGeoResource) || !(type = (mr = (JGrassMapGeoResource)((Object)map)).getType()).equals("grassbinaryraster")) break block11;
                                    String[] mapsetpathAndMapname = JGrassCatalogUtilities.getMapsetpathAndMapnameFromJGrassMapGeoResource(mr);
                                    oldMapName = mapsetpathAndMapname[1];
                                    mapsetName = mapsetpathAndMapname[0];
                                    InputDialog iDialog = new InputDialog(Display.getDefault().getActiveShell(), "New map name", "Please enter the new name for the map: " + oldMapName, "new_" + oldMapName, null);
                                    iDialog.open();
                                    newMapName = iDialog.getValue();
                                    if (newMapName.indexOf(32) == -1) break block12;
                                    MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 1);
                                    msgBox.setMessage("Map names can't contain spaces. Please choose a name without spaces.");
                                    msgBox.open();
                                    newMapName = null;
                                    return;
                                }
                                try {
                                    if (newMapName != null && newMapName.length() > 0) {
                                        IMap activeMap = ApplicationGIS.getActiveMap();
                                        List mapLayers = activeMap.getMapLayers();
                                        ArrayList<ILayer> toRemove = new ArrayList<ILayer>();
                                        int i = 0;
                                        while (i < mapLayers.size()) {
                                            String layerName = ((ILayer)mapLayers.get(i)).getName();
                                            if (layerName.equals(oldMapName)) {
                                                toRemove.add((ILayer)mapLayers.get(i));
                                            }
                                            ++i;
                                        }
                                        if (toRemove.size() > 0) {
                                            activeMap.sendCommandSync((MapCommand)new DeleteLayersCommand(toRemove.toArray(new ILayer[toRemove.size()])));
                                        }
                                        RenameMapAction.this.renameGrassRasterMap(mapsetName, oldMapName, newMapName);
                                        ((JGrassMapsetGeoResource)mr.parent((IProgressMonitor)new NullProgressMonitor())).removeMap(oldMapName, "grassbinaryraster");
                                        ((JGrassMapsetGeoResource)mr.parent((IProgressMonitor)new NullProgressMonitor())).addMap(newMapName, "grassbinaryraster");
                                    }
                                }
                                catch (Exception e) {
                                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"Problems occurred while renaming the map.");
                                    e.printStackTrace();
                                }
                            }
                            finally {
                                pm.done();
                            }
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Remove maps...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    private void renameGrassRasterMap(String mapsetPath, String oldMapName, String newMapName) throws IOException {
        String[] mappaths = JGrassCatalogUtilities.filesOfRasterMap(mapsetPath, oldMapName);
        int j = 0;
        while (j < mappaths.length) {
            File filetorename = new File(mappaths[j]);
            if (filetorename.exists()) {
                File parentFile = filetorename.getParentFile();
                File renamedFile = new File(parentFile, newMapName);
                if (filetorename.isDirectory()) {
                    FileUtils.moveDirectory((File)filetorename, (File)renamedFile);
                } else if (filetorename.isFile()) {
                    FileUtils.moveFile((File)filetorename, (File)renamedFile);
                } else {
                    throw new IOException("File type not defined");
                }
            }
            ++j;
        }
    }
}

