/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;

public class RemoveMapsetAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;
    private IWorkbenchWindow window;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                boolean answer = MessageDialog.openQuestion((Shell)shell, (String)"WARNING", (String)"Are you sure you want to remove the selected mapsets from disk? This can't be undone!");
                if (answer) {
                    List toList = RemoveMapsetAction.this.selection.toList();
                    for (Object object : toList) {
                        if (!(object instanceof JGrassMapsetGeoResource)) continue;
                        JGrassMapsetGeoResource mapsetr = (JGrassMapsetGeoResource)object;
                        String mapsetPath = mapsetr.getFile().getAbsolutePath();
                        try {
                            FileUtils.deleteDirectory((File)new File(mapsetPath));
                            JGrassCatalogUtilities.removeMapsetFromCatalog(mapsetr.getFile().getParent(), mapsetr.getFile().getName());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            String message = "An error occurred while removing the mapset.";
                            ExceptionDetailsDialog.openError((String)"ERROR", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public Menu getMenu(Control parent) {
        return null;
    }
}

