/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.commands.DeleteLayersCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;

public class RemoveMapAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        boolean answer = MessageDialog.openQuestion((Shell)shell, (String)"WARNING", (String)"Are you sure you want to remove the selected maps from disk? This can't be undone!");
                        if (answer) {
                            List toList = (this).RemoveMapAction.this.selection.toList();
                            try {
                                pm.beginTask("Removing maps...", toList.size());
                                for (Object object : toList) {
                                    JGrassMapGeoResource mr;
                                    String type;
                                    if (object instanceof JGrassMapGeoResource && (type = (mr = (JGrassMapGeoResource)((Object)object)).getType()).equals("grassbinaryraster")) {
                                        String[] mapsetpathAndMapname = JGrassCatalogUtilities.getMapsetpathAndMapnameFromJGrassMapGeoResource(mr);
                                        try {
                                            RemoveMapAction.this.removeGrassRasterMap(mapsetpathAndMapname[0], mapsetpathAndMapname[1]);
                                            ((JGrassMapsetGeoResource)mr.parent((IProgressMonitor)new NullProgressMonitor())).removeMap(mapsetpathAndMapname[1], "grassbinaryraster");
                                            IMap activeMap = ApplicationGIS.getActiveMap();
                                            List mapLayers = activeMap.getMapLayers();
                                            String mapName = mr.getTitle();
                                            ArrayList<ILayer> toRemove = new ArrayList<ILayer>();
                                            int i = 0;
                                            while (i < mapLayers.size()) {
                                                String layerName = ((ILayer)mapLayers.get(i)).getName();
                                                if (layerName.equals(mapName)) {
                                                    toRemove.add((ILayer)mapLayers.get(i));
                                                }
                                                ++i;
                                            }
                                            if (toRemove.size() > 0) {
                                                activeMap.sendCommandSync((MapCommand)new DeleteLayersCommand(toRemove.toArray(new ILayer[toRemove.size()])));
                                            }
                                        }
                                        catch (Exception e) {
                                            MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"Problems occurred while removing the map.");
                                            e.printStackTrace();
                                        }
                                    }
                                    pm.worked(1);
                                }
                            }
                            finally {
                                pm.done();
                            }
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Remove maps...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public void removeGrassRasterMap(String mapsetPath, String mapName) throws IOException {
        String[] mappaths = JGrassCatalogUtilities.filesOfRasterMap(mapsetPath, mapName);
        int j = 0;
        while (j < mappaths.length) {
            File filetoremove = new File(mappaths[j]);
            if (filetoremove.exists()) {
                FileUtils.forceDelete((File)filetoremove);
            }
            ++j;
        }
    }
}

