/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapSummaryAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        Object object = (this).MapSummaryAction.this.selection.getFirstElement();
                        try {
                            pm.beginTask("Collecting stats...", -1);
                            StringBuilder regionString = new StringBuilder();
                            GridCoverage2D geodata = null;
                            if (object instanceof AbstractRasterGeoResource) {
                                AbstractRasterGeoResource rGeo = (AbstractRasterGeoResource)object;
                                AbstractGridCoverage2DReader gridCoverage2DReader = (AbstractGridCoverage2DReader)rGeo.resolve(AbstractGridCoverage2DReader.class, pm);
                                geodata = gridCoverage2DReader.read(null);
                                geodata = geodata.view(ViewType.GEOPHYSICS);
                                Envelope envelope = geodata.getEnvelope();
                                DirectPosition lowerCorner = envelope.getLowerCorner();
                                double[] westSouth = lowerCorner.getCoordinate();
                                DirectPosition upperCorner = envelope.getUpperCorner();
                                double[] eastNorth = upperCorner.getCoordinate();
                                GridGeometry2D gridGeometry = geodata.getGridGeometry();
                                GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
                                int rows = gridRange.height;
                                int cols = gridRange.width;
                                AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
                                double we_res = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
                                double ns_res = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
                                double north = eastNorth[1];
                                double south = westSouth[1];
                                double east = eastNorth[0];
                                double west = westSouth[0];
                                regionString.append("region:\nwest=");
                                regionString.append(west);
                                regionString.append("\neast=");
                                regionString.append(east);
                                regionString.append("\nsouth=");
                                regionString.append(south);
                                regionString.append("\nnorth=");
                                regionString.append(north);
                                regionString.append("\nwe_res=");
                                regionString.append(we_res);
                                regionString.append("\nns_res=");
                                regionString.append(ns_res);
                                regionString.append("\nrows=");
                                regionString.append(rows);
                                regionString.append("\ncols=");
                                regionString.append(cols);
                            } else if (object instanceof JGrassMapGeoResource) {
                                JGrassMapGeoResource mr = (JGrassMapGeoResource)((Object)object);
                                File mapFile = mr.getMapFile();
                                JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(mapFile);
                                JGrassRegion jGrassRegion = mapEnvironment.getActiveRegion();
                                int cols = jGrassRegion.getCols();
                                int rows = jGrassRegion.getRows();
                                double north = jGrassRegion.getNorth();
                                double south = jGrassRegion.getSouth();
                                double east = jGrassRegion.getEast();
                                double west = jGrassRegion.getWest();
                                double we_res = jGrassRegion.getWEResolution();
                                double ns_res = jGrassRegion.getNSResolution();
                                regionString.append("region:\nwest=");
                                regionString.append(west);
                                regionString.append("\neast=");
                                regionString.append(east);
                                regionString.append("\nsouth=");
                                regionString.append(south);
                                regionString.append("\nnorth=");
                                regionString.append(north);
                                regionString.append("\nwe_res=");
                                regionString.append(we_res);
                                regionString.append("\nns_res=");
                                regionString.append(ns_res);
                                regionString.append("\nrows=");
                                regionString.append(rows);
                                regionString.append("\ncols=");
                                regionString.append(cols);
                                GeneralParameterValue[] readParams = MapSummaryAction.createGridGeometryGeneralParameter(cols, rows, north, south, east, west, mapEnvironment.getCoordinateReferenceSystem());
                                GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
                                AbstractGridCoverage2DReader reader = format.getReader((Object)mapEnvironment.getCELL());
                                geodata = reader.read(readParams);
                                geodata = geodata.view(ViewType.GEOPHYSICS);
                            } else {
                                MessageDialog.openInformation((Shell)shell, (String)"WARNING", (String)"Unable to read format");
                                return;
                            }
                            try {
                                GridGeometry2D gridGeometry = geodata.getGridGeometry();
                                GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
                                int rows = gridRange.height;
                                int cols = gridRange.width;
                                AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
                                double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
                                double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
                                RandomIter inputIter = RandomIterFactory.create((RenderedImage)geodata.getRenderedImage(), null);
                                double mean = 0.0;
                                double[] minMaxMeans = new double[]{Double.MAX_VALUE, Double.MIN_VALUE, 0.0, 0.0, 0.0};
                                int validCells = 0;
                                int y = 0;
                                while (y < rows) {
                                    int x = 0;
                                    while (x < cols) {
                                        double value = inputIter.getSampleDouble(x, y, 0);
                                        if (!Double.isNaN(value) && (int)value != -9999) {
                                            if (value < minMaxMeans[0]) {
                                                minMaxMeans[0] = value;
                                            }
                                            if (value > minMaxMeans[1]) {
                                                minMaxMeans[1] = value;
                                            }
                                            mean += value;
                                            ++validCells;
                                        }
                                        ++x;
                                    }
                                    ++y;
                                }
                                minMaxMeans[2] = mean /= (double)validCells;
                                minMaxMeans[3] = validCells;
                                minMaxMeans[4] = (double)validCells * xRes * yRes;
                                StringBuilder sb = new StringBuilder();
                                sb.append("Summary for the map:\n");
                                sb.append("\n");
                                sb.append("range: " + minMaxMeans[0] + " - " + minMaxMeans[1] + "\n");
                                sb.append("mean: " + minMaxMeans[2] + "\n");
                                sb.append("active cells: " + minMaxMeans[3] + "\n");
                                sb.append("active area (assuming metric resolution): " + minMaxMeans[4] + "\n");
                                sb.append(String.valueOf(regionString.toString()) + "\n");
                                sb.append("data crs: " + geodata.getCoordinateReferenceSystem().getName().toString());
                                MessageDialog.openInformation((Shell)shell, (String)"Summary", (String)sb.toString());
                            }
                            catch (Exception e) {
                                String message = "An error occurred while exporting the maps.";
                                ExceptionDetailsDialog.openError((String)"ERROR", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Calculating map summery...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }
}

