/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.core.JGrassConnectionFactory;
import eu.udig.catalog.jgrass.core.JGrassServiceExtension;
import eu.udig.catalog.jgrass.messages.Messages;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JGrassWizardPage
extends WizardPage
implements ModifyListener,
UDIGConnectionPage {
    private String url = "";
    private static final String JGRASS_WIZARD = "JGRASS_WIZARD";
    private static final String JGRASS_RECENT = "JGRASS_RECENT";
    private IDialogSettings settings = JGrassPlugin.getDefault().getDialogSettings().getSection("JGRASS_WIZARD");
    private static final int COMBO_HISTORY_LENGTH = 15;
    private Combo urlCombo = null;
    private List<IService> jgrassServices;

    public JGrassWizardPage() {
        super(Messages.getString("jgrasswizard.dbimport"));
        if (this.settings == null) {
            this.settings = JGrassPlugin.getDefault().getDialogSettings().addNewSection(JGRASS_WIZARD);
        }
    }

    public String getId() {
        return "eu.hydrologis.udig.catalog.internal.jgrass.ui.JGrass";
    }

    protected Map<String, Serializable> defaultParams() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        return this.toParams(selection);
    }

    protected Map<String, Serializable> toParams(IStructuredSelection context) {
        if (context != null) {
            Iterator itr = context.iterator();
            while (itr.hasNext()) {
                Map<String, Serializable> params = new JGrassConnectionFactory().createConnectionParameters(itr.next());
                if (params.isEmpty()) continue;
                return params;
            }
        }
        return Collections.EMPTY_MAP;
    }

    public void createControl(Composite parent) {
        int columns;
        String[] recentJGrass = this.settings.getArray(JGRASS_RECENT);
        if (recentJGrass == null) {
            recentJGrass = new String[]{};
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.getString("jgrasswizard.selectfolder"));
        urlLabel.setLayoutData((Object)gridData);
        new Label(composite, 0);
        Map<String, Serializable> params = this.defaultParams();
        gridData = new GridData(768);
        gridData.widthHint = 400;
        this.urlCombo = new Combo(composite, 2048);
        this.urlCombo.setItems(recentJGrass);
        this.urlCombo.setVisibleItemCount(15);
        this.urlCombo.setLayoutData((Object)gridData);
        URL selectedURL = this.getURL(params);
        if (selectedURL != null) {
            File urlToFile = URLUtils.urlToFile((URL)selectedURL);
            this.urlCombo.setText(urlToFile.getAbsolutePath());
            this.url = urlToFile.getAbsolutePath();
            this.setPageComplete(true);
        } else if (this.url != null && this.url.length() != 0) {
            this.urlCombo.setText(this.url);
            try {
                this.getResources((IProgressMonitor)new NullProgressMonitor());
                this.setPageComplete(true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                this.setPageComplete(false);
            }
        } else {
            this.url = null;
            this.urlCombo.setText("insert path here");
            this.setPageComplete(false);
        }
        this.urlCombo.addModifyListener((ModifyListener)this);
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.getString("jgrasswizard.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getDefault().getActiveShell());
                directoryDialog.setText(Messages.getString("jgrasswizard.choosefolder"));
                String selectedDirectory = directoryDialog.open();
                JGrassWizardPage.this.urlCombo.setText(selectedDirectory);
                JGrassWizardPage.this.url = selectedDirectory;
                try {
                    JGrassWizardPage.this.getResources((IProgressMonitor)new NullProgressMonitor());
                    JGrassWizardPage.this.setPageComplete(true);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JGrassWizardPage.this.setPageComplete(false);
                }
            }
        });
        gridData = new GridData();
        gridData.widthHint = 150;
        browseButton.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
    }

    public URL getURL(Map<String, Serializable> params) {
        Serializable value = params.get("eu.udig.catalog.jgrass.urlKey");
        if (value == null) {
            return null;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                URL url = new File((String)((Object)value)).toURI().toURL();
                return url;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.getClass();
        if (this.getWizard().canFinish()) {
            this.getWizard().performFinish();
        }
    }

    public List<IService> getResources(IProgressMonitor monitor) throws Exception {
        URL location = new File(this.url).toURI().toURL();
        JGrassServiceExtension creator = new JGrassServiceExtension();
        Map<String, Serializable> params = creator.createParams(location);
        IService service = creator.createService(location, params);
        service.getInfo(monitor);
        this.jgrassServices = new ArrayList<IService>();
        this.jgrassServices.add(service);
        this.saveWidgetValues();
        return this.jgrassServices;
    }

    public void modifyText(ModifyEvent e) {
        this.url = ((Combo)e.getSource()).getText();
        try {
            this.getResources((IProgressMonitor)new NullProgressMonitor());
            this.setPageComplete(true);
            this.setErrorMessage(null);
        }
        catch (Exception e1) {
            this.setErrorMessage(e1.getLocalizedMessage());
            e1.printStackTrace();
            this.setPageComplete(false);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void saveWidgetValues() {
        if (this.settings != null) {
            String[] recentJGrasses = this.settings.getArray(JGRASS_RECENT);
            if (recentJGrasses == null) {
                recentJGrasses = new String[]{};
            }
            recentJGrasses = this.addToHistory(recentJGrasses, this.url);
            this.settings.put(JGRASS_RECENT, recentJGrasses);
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 15) {
            history.remove(15);
        }
    }

    public Map<String, Serializable> getParams() {
        try {
            if (this.url == null) {
                return Collections.emptyMap();
            }
            URL location = new File(this.url).toURI().toURL();
            JGrassServiceExtension creator = new JGrassServiceExtension();
            return creator.createParams(location);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Collection<URL> getResourceIDs() {
        try {
            ArrayList<URL> l = new ArrayList<URL>();
            l.add(new File(this.url).toURI().toURL());
            return l;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Collection<IService> getServices() {
        return this.jgrassServices;
    }
}

