/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.core.ChooseCoordinateReferenceSystemDialog;
import eu.udig.catalog.jgrass.core.JGrassService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.URLUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGrassServiceExtension
implements ServiceExtension {
    public static final String KEY = "eu.udig.catalog.jgrass.urlKey";

    public Map<String, Serializable> createParams(URL url) {
        HashMap<String, URL> params;
        block10: {
            File startFile;
            block9: {
                params = null;
                startFile = URLUtils.urlToFile((URL)url);
                if (startFile != null) break block9;
                return null;
            }
            try {
                File permanentFolder;
                File cellFolderFile;
                File file;
                String path = startFile.getAbsolutePath();
                if (path.endsWith(".jgrass")) {
                    path = new File(path).getParent();
                    url = new File(path).toURI().toURL();
                }
                if ((file = new File(path)).exists() && file.isFile() && (cellFolderFile = file.getParentFile()).getName().equalsIgnoreCase("cell")) {
                    JGrassMapEnvironment env = new JGrassMapEnvironment(file);
                    file = env.getLOCATION();
                    url = file.toURI().toURL();
                }
                if (!file.exists() || !file.isDirectory() || !(permanentFolder = new File(String.valueOf(file.getAbsolutePath()) + File.separator + "PERMANENT")).exists() || !permanentFolder.isDirectory()) break block10;
                boolean windexists = true;
                File windFile = new File(permanentFolder + File.separator + "WIND");
                if (!windFile.exists()) {
                    windexists = false;
                    File tmpWindFile = new File(permanentFolder + File.separator + "WIND".toLowerCase());
                    if (tmpWindFile.exists()) {
                        tmpWindFile.renameTo(windFile);
                        windexists = true;
                    }
                }
                if (windexists) {
                    params = new HashMap<String, URL>();
                    params.put(KEY, url);
                    File projWtkFile = new File(String.valueOf(file.getAbsolutePath()) + File.separator + "PERMANENT" + File.separator + "PROJ_INFO.WKT");
                    if (!this.setJGrassCrs(projWtkFile)) {
                        return null;
                    }
                    break block10;
                }
                return null;
            }
            catch (Throwable e) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassServiceExtension#createParams", e);
                e.printStackTrace();
            }
        }
        return params;
    }

    public IService createService(URL id, Map<String, Serializable> params) {
        if (params == null) {
            return null;
        }
        if (params.containsKey(KEY)) {
            return new JGrassService(params);
        }
        return null;
    }

    public synchronized boolean setJGrassCrs(File projFile) {
        block5: {
            block4: {
                if (!projFile.exists()) break block4;
                return true;
            }
            try {
                final ChooseCoordinateReferenceSystemDialog crsChooser = new ChooseCoordinateReferenceSystemDialog();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        crsChooser.open(shell);
                    }
                });
                CoordinateReferenceSystem readCrs = crsChooser.getCrs();
                if (readCrs != null) {
                    BufferedWriter bWriter = new BufferedWriter(new FileWriter(projFile));
                    String crsString = readCrs.toWKT();
                    bWriter.write(crsString);
                    bWriter.close();
                    break block5;
                }
                return false;
            }
            catch (Exception e1) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassServiceExtension#setJGrassCrs", e1);
                e1.printStackTrace();
            }
        }
        return true;
    }
}

