/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.JGrassUtilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGrassMapsetGeoResource
implements IResolveFolder {
    private JGrassService parent = null;
    private String name = null;
    private Throwable msg = null;
    private List<IResolve> jgrassMapMembers = null;
    private ImageDescriptor icon;
    private Map<String, String> mapNamesAndTypes;
    private CoordinateReferenceSystem locationCrs;
    private File mapsetFile;
    private File cellFolderFile;

    public JGrassMapsetGeoResource(JGrassService parent, String name, String mapsetPath) {
        this.parent = parent;
        this.name = name;
        this.mapsetFile = new File(mapsetPath);
        if (!this.mapsetFile.exists() || !this.mapsetFile.isDirectory()) {
            throw new IllegalArgumentException("The GRASS mapset has to be a folder: " + mapsetPath);
        }
        this.cellFolderFile = new File(this.mapsetFile, "cell");
        this.locationCrs = parent.getLocationCrs();
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        if (adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(File.class)) {
            return true;
        }
        return CatalogPlugin.getDefault().getResolveManager().canResolve((IResolve)this, adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast((Object)this.parent);
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return adaptee.cast(this.mapsetFile);
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve((IResolve)this, adaptee)) {
            return (T)rm.resolve((IResolve)this, adaptee, monitor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IResolve> members(IProgressMonitor monitor) {
        block6: {
            JGrassMapsetGeoResource jGrassMapsetGeoResource = this;
            synchronized (jGrassMapsetGeoResource) {
                Map<String, String> mapNamesAndTypes;
                block5: {
                    if (this.jgrassMapMembers != null) break block6;
                    mapNamesAndTypes = this.loadMaps(monitor);
                    if (mapNamesAndTypes != null) break block5;
                    return null;
                }
                this.jgrassMapMembers = new ArrayList<IResolve>();
                for (Map.Entry<String, String> item : mapNamesAndTypes.entrySet()) {
                    String name = item.getKey();
                    String type = item.getValue();
                    JGrassMapGeoResource jgrassMapGeoResource = new JGrassMapGeoResource(this.parent, this, name, type);
                    this.jgrassMapMembers.add((IResolve)jgrassMapGeoResource);
                }
                return this.jgrassMapMembers;
            }
        }
        return this.jgrassMapMembers;
    }

    private Map<String, String> loadMaps(IProgressMonitor monitor) {
        try {
            this.mapNamesAndTypes = new HashMap<String, String>();
            File[] rasterFiles = this.cellFolderFile.listFiles();
            if (rasterFiles == null) {
                this.msg = new Throwable("Either dir does not exist or is not a directory");
            } else {
                File[] fileArray = rasterFiles;
                int n = rasterFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File rasterFile = fileArray[n2];
                    if (JGrassUtilities.checkRasterMapConsistence((String)this.mapsetFile.getAbsolutePath(), (String)rasterFile.getName())) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("grassbinaryraster");
                        sb.append("|");
                        sb.append(rasterFile.getAbsolutePath());
                        this.mapNamesAndTypes.put(rasterFile.getName(), sb.toString());
                    }
                    ++n2;
                }
            }
            this.msg = null;
            return this.mapNamesAndTypes;
        }
        catch (Throwable e) {
            this.msg = e;
            return null;
        }
    }

    public URL getIdentifier() {
        String parentFile = URLUtils.urlToFile((URL)this.parent.getIdentifier()).getAbsolutePath();
        URL mapsetId = JGrassMapsetGeoResource.createId(parentFile, this.name);
        return mapsetId;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public IResolve.Status getStatus() {
        if (this.msg != null) {
            return IResolve.Status.BROKEN;
        }
        if (this.jgrassMapMembers == null) {
            return IResolve.Status.NOTCONNECTED;
        }
        return IResolve.Status.CONNECTED;
    }

    public JGrassRegion getActiveRegionWindow() {
        try {
            return new JGrassRegion(this.getActiveRegionWindowPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getActiveRegionWindowPath() {
        File windFile = new File(this.mapsetFile, "WIND");
        if (!windFile.exists() && !(windFile = new File(this.mapsetFile, "WIND".toLowerCase())).exists()) {
            this.msg = new Throwable("Couldn't find a suitable region file in the mapset. Check your Location.");
            return null;
        }
        return windFile.getAbsolutePath();
    }

    public ImageDescriptor getIcon(IProgressMonitor monitor) {
        if (this.icon == null) {
            this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        }
        return this.icon;
    }

    public String getTitle() {
        return this.name;
    }

    public void dispose(IProgressMonitor monitor) {
        this.jgrassMapMembers = null;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public IService getService(IProgressMonitor monitor) {
        return this.parent;
    }

    public ID getID() {
        ID id = new ID(this.getIdentifier());
        return id;
    }

    public static URL createId(String locationPath, String mapsetName) {
        try {
            URL locationUrl = new File(locationPath).toURI().toURL();
            String locationUrlString = URLUtils.urlToString((URL)locationUrl, (boolean)false);
            if (!locationUrlString.endsWith("/")) {
                locationUrlString = String.valueOf(locationUrlString) + "/";
            }
            return new URL(String.valueOf(locationUrlString) + "#/" + mapsetName);
        }
        catch (MalformedURLException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Url should always work this is a bug"))).initCause(e);
        }
    }

    public Set<String> getMapnamesList() {
        Set<String> mapnamesSet = this.mapNamesAndTypes.keySet();
        return mapnamesSet;
    }

    public JGrassMapGeoResource addMap(String mapName, String mapType) {
        String mapPath = new File(this.cellFolderFile, mapName).getAbsolutePath();
        String mapTypeAndPath = String.valueOf(mapType) + "|" + mapPath;
        JGrassMapGeoResource resource = new JGrassMapGeoResource(this.parent, this, mapName, mapTypeAndPath);
        if (this.jgrassMapMembers == null) {
            this.jgrassMapMembers = this.members(ProgressManager.instance().get(null));
        }
        if (!this.jgrassMapMembers.contains((Object)resource)) {
            this.jgrassMapMembers.add((IResolve)resource);
            ICatalog catalog = this.getService(null).parent(null);
            if (catalog instanceof CatalogImpl) {
                ResolveDelta delta = new ResolveDelta((IResolve)resource, IResolveDelta.Kind.ADDED);
                ResolveChangeEvent event = new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta);
                ((CatalogImpl)catalog).fire((IResolveChangeEvent)event);
            }
        } else {
            try {
                int index = this.jgrassMapMembers.indexOf((Object)resource);
                IResolve iResolve = this.jgrassMapMembers.get(index);
                resource = (JGrassMapGeoResource)iResolve;
                resource.resetBoundInfo();
            }
            catch (IOException e) {
                String message = "An error occurred while reloading the file bounds info.";
                ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
            }
        }
        return resource;
    }

    public JGrassMapGeoResource removeMap(String mapName, String mapType) {
        String mapPath = new File(this.cellFolderFile, mapName).getAbsolutePath();
        String mapTypeAndPath = String.valueOf(mapType) + "|" + mapPath;
        JGrassMapGeoResource resource = new JGrassMapGeoResource(this.parent, this, mapName, mapTypeAndPath);
        if (this.jgrassMapMembers == null) {
            this.jgrassMapMembers = this.members(ProgressManager.instance().get(null));
        }
        if (this.jgrassMapMembers.contains((Object)resource)) {
            this.jgrassMapMembers.remove((Object)resource);
            ICatalog catalog = this.getService(null).parent(null);
            if (catalog instanceof CatalogImpl) {
                ResolveDelta delta = new ResolveDelta((IResolve)resource, IResolveDelta.Kind.REMOVED);
                ResolveChangeEvent event = new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta);
                ((CatalogImpl)catalog).fire((IResolveChangeEvent)event);
            }
        }
        return resource;
    }

    public File getFile() {
        return this.mapsetFile;
    }

    public CoordinateReferenceSystem getLocationCrs() {
        return this.locationCrs;
    }

    class JGrassMapsetGeoResourceInfo
    extends IGeoResourceInfo {
        public JGrassMapsetGeoResourceInfo(IProgressMonitor monitor) throws IOException {
            this.title = this.name = JGrassMapsetGeoResource.this.name;
            this.description = "JGrass Mapset (" + JGrassMapsetGeoResource.this.getIdentifier() + ")";
            JGrassRegion activeRegionWindow = JGrassMapsetGeoResource.this.getActiveRegionWindow();
            this.bounds = new ReferencedEnvelope(activeRegionWindow.getEnvelope(), this.getCRS());
            this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/repository_obj.gif");
        }

        public CoordinateReferenceSystem getCRS() {
            return JGrassMapsetGeoResource.this.locationCrs;
        }
    }
}

