/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.core.JGTtmsProperties;
import eu.udig.catalog.jgrass.core.JGTtmsService;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGTtmsGeoResource
extends IGeoResource {
    public static final String READERID = "eu.udig.catalog.jgrass.core.JGTtmsGeoResource.readerid";
    private URL url = null;
    private Throwable msg = null;
    private IGeoResourceInfo info = null;
    private final IService parentService;
    private CoordinateReferenceSystem tmsCrs;
    private JGTtmsProperties tmsProperties = null;
    private File tmsPropertiesFile;

    public JGTtmsGeoResource(JGTtmsService parentService, URL url) {
        this.parentService = parentService;
        this.url = url;
        this.tmsPropertiesFile = URLUtils.urlToFile((URL)url);
        this.tmsProperties = this.getTmsProperties(this.tmsPropertiesFile);
        this.tmsCrs = parentService.getCrs();
    }

    private JGTtmsProperties getTmsProperties(File tmsPropertiesFile) {
        JGTtmsProperties tmsProperties = new JGTtmsProperties();
        List fileLines = new ArrayList();
        try {
            fileLines = FileUtils.readLines((File)tmsPropertiesFile);
        }
        catch (IOException e1) {
            this.msg = e1;
            e1.printStackTrace();
        }
        for (String line : fileLines) {
            int split;
            if ((line = line.trim()).length() == 0 || (split = line.indexOf(61)) == -1) continue;
            String value = line.substring(split + 1).trim();
            if (line.startsWith("url")) {
                int indexOfZ = value.indexOf("ZZZ");
                tmsProperties.HOST_NAME = value.substring(0, indexOfZ);
                tmsProperties.tilePart = value.substring(indexOfZ);
                if (value.startsWith("http")) {
                    tmsProperties.HOST_NAME = tmsProperties.HOST_NAME.substring(7);
                } else {
                    tmsProperties.PROTOCOL = "file";
                    tmsProperties.HOST_NAME = String.valueOf(tmsPropertiesFile.getParent()) + File.separator + tmsProperties.HOST_NAME;
                    tmsProperties.isFile = true;
                }
            }
            if (line.startsWith("minzoom")) {
                try {
                    tmsProperties.ZOOM_MIN = Byte.valueOf(value).byteValue();
                }
                catch (Exception exception) {}
            }
            if (line.startsWith("maxzoom")) {
                try {
                    tmsProperties.ZOOM_MAX = Byte.valueOf(value).byteValue();
                }
                catch (Exception exception) {}
            }
            if (line.startsWith("center")) {
                try {
                    String[] coord = value.split("\\s+");
                    double x = Double.parseDouble(coord[0]);
                    double y = Double.parseDouble(coord[1]);
                    tmsProperties.centerPoint = new Coordinate(x, y);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!line.startsWith("type") || !value.equals(JGTtmsProperties.TILESCHEMA.tms.toString())) continue;
            tmsProperties.type = JGTtmsProperties.TILESCHEMA.tms;
        }
        return tmsProperties;
    }

    public JGTtmsProperties getTmsProperties() {
        return this.tmsProperties;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(IGeoResource.class) || adaptee.isAssignableFrom(JGTtmsGeoResource.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast(this.parentService);
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return adaptee.cast(this.tmsPropertiesFile);
        }
        if (adaptee.isAssignableFrom(JGTtmsGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(CoordinateReferenceSystem.class)) {
            return adaptee.cast(this.tmsCrs);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public URL getIdentifier() {
        String urlString = URLUtils.urlToString((URL)this.url, (boolean)false);
        try {
            return new URL(String.valueOf(urlString) + "#/" + this.getTitle());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ID getID() {
        return new ID(this.getIdentifier());
    }

    public IService service(IProgressMonitor monitor) throws IOException {
        return this.parentService;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public IResolve.Status getStatus() {
        if (this.msg != null) {
            return IResolve.Status.BROKEN;
        }
        return IResolve.Status.CONNECTED;
    }

    public String getTitle() {
        try {
            this.createInfo((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.info.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        JGTtmsGeoResource jGTtmsGeoResource = this;
        synchronized (jGTtmsGeoResource) {
            if (this.info == null) {
                this.info = new JGTtmsGeoResourceInfo(monitor);
            }
        }
        return this.info;
    }

    class JGTtmsGeoResourceInfo
    extends IGeoResourceInfo {
        public JGTtmsGeoResourceInfo(IProgressMonitor monitor) {
            String baseName;
            this.title = this.name = (baseName = FilenameUtils.getBaseName((String)JGTtmsGeoResource.this.tmsPropertiesFile.getName()));
            this.description = this.name;
            try {
                Coordinate c = ((JGTtmsGeoResource)JGTtmsGeoResource.this).tmsProperties.centerPoint;
                Envelope env = new Envelope(c);
                GeodeticCalculator gc = new GeodeticCalculator(JGTtmsGeoResource.this.tmsCrs);
                gc.setStartingGeographicPoint(c.x, c.y);
                gc.setDirection(-45.0, 10000.0);
                Point2D p1 = gc.getDestinationGeographicPoint();
                env.expandToInclude(p1.getX(), p1.getY());
                gc.setDirection(135.0, 10000.0);
                Point2D p2 = gc.getDestinationGeographicPoint();
                env.expandToInclude(p2.getX(), p2.getY());
                ReferencedEnvelope tmpBounds = new ReferencedEnvelope(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                this.bounds = tmpBounds.transform(JGTtmsGeoResource.this.tmsCrs, true);
                this.icon = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
            }
            catch (Exception e) {
                this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/problem.gif");
                e.printStackTrace();
            }
        }

        public ReferencedEnvelope getBounds() {
            return this.bounds;
        }

        public void setBounds(ReferencedEnvelope newBounds) {
            this.bounds = newBounds;
        }
    }
}

