/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.AbstractChooserDialog;
import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterCatalogTreeViewer;
import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterLayerTreeViewer;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.messages.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class JGRasterChooserDialog
extends AbstractChooserDialog {
    private IResourcesSelector active;
    private List<JGrassMapGeoResource> newLayers;
    private Dialog dialog;
    private String mapsetPath;

    public JGRasterChooserDialog(String mapsetPath) {
        this.mapsetPath = mapsetPath;
    }

    @Override
    public void open(Shell parentShell, final int selectionType) {
        this.dialog = new Dialog(parentShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(Messages.getString("JGRasterChooserDialog.chooseraster"));
            }

            protected Point getInitialSize() {
                return new Point(280, 380);
            }

            protected Control createDialogArea(Composite parent) {
                JGRasterChooserDialog.this.parentPanel = (Composite)super.createDialogArea(parent);
                GridLayout gLayout = (GridLayout)JGRasterChooserDialog.this.parentPanel.getLayout();
                gLayout.numColumns = 1;
                JGRasterChooserDialog.this.active = new JGRasterLayerTreeViewer(JGRasterChooserDialog.this.parentPanel, 2048, selectionType, JGRasterChooserDialog.this.mapsetPath);
                JGRasterChooserDialog.this.makeCheckPanel();
                return JGRasterChooserDialog.this.parentPanel;
            }

            protected void buttonPressed(int buttonId) {
                String text = null;
                JGRasterChooserDialog.this.newLayers = new ArrayList();
                if (buttonId == 0) {
                    List layers = (List)JGRasterChooserDialog.this.active.getSelectedLayers();
                    for (IGeoResource geoResource : layers) {
                        JGRasterChooserDialog.this.newLayers.add((JGrassMapGeoResource)geoResource);
                        try {
                            text = geoResource.getInfo(null).getTitle();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (text == null) {
                        return;
                    }
                } else {
                    JGRasterChooserDialog.this.newLayers = null;
                }
                super.buttonPressed(buttonId);
            }
        };
        this.dialog.setBlockOnOpen(true);
        this.dialog.open();
    }

    public boolean isDisposed() {
        return this.dialog.getShell().isDisposed();
    }

    public void widgetSelected(SelectionEvent e) {
        Button selectedButton = (Button)e.getSource();
        if (!selectedButton.getSelection()) {
            return;
        }
        this.isCatalogType = !selectedButton.getData("type").equals("visiblelayertype");
        Control[] childrens = this.parentPanel.getChildren();
        int i = 0;
        while (i < childrens.length) {
            childrens[i].dispose();
            ++i;
        }
        if (this.isCatalogType) {
            this.active = new JGRasterCatalogTreeViewer(this.parentPanel, 2048, 4, this.mapsetPath);
        } else if (!this.isCatalogType) {
            this.active = new JGRasterLayerTreeViewer(this.parentPanel, 2048, 4, this.mapsetPath);
        }
        this.makeCheckPanel();
        this.parentPanel.layout();
    }

    public List<JGrassMapGeoResource> getSelectedResources() {
        return this.newLayers;
    }

    @Override
    public String getNameOfResourceAtIndex(int index) {
        try {
            if (this.newLayers != null && this.newLayers.size() > 0) {
                return this.newLayers.get(index).getInfo(null).getName();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

