/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.core.JGrassService;
import eu.udig.catalog.jgrass.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JGRasterCatalogTreeViewer
extends Composite
implements ISelectionChangedListener,
IResourcesSelector {
    private final HashMap<String, JGrassMapGeoResource> itemsMap = new HashMap();
    private LabelProvider labelProvider = null;
    private List<IGeoResource> itemLayers;
    private String mapset;

    public JGRasterCatalogTreeViewer(Composite parent, int style, int selectionStyle, String mapset) {
        super(parent, style);
        if (mapset != null) {
            this.mapset = mapset;
        }
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree((Composite)this, selectionStyle, patternFilter);
        TreeViewer tv = filter.getViewer();
        tv.getTree().setLayoutData((Object)new GridData(1808));
        tv.setContentProvider((IContentProvider)new ContentProvider());
        this.labelProvider = new LabelProvider();
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.setInput((Object)"dummy2");
        tv.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Vector<String> itemNames = new Vector<String>();
            for (Object domain : selection) {
                String value = this.labelProvider.getText(domain);
                itemNames.add(value);
            }
            this.itemLayers = new ArrayList<IGeoResource>();
            for (String name : itemNames) {
                JGrassMapGeoResource tmpLayer = this.itemsMap.get(name);
                if (tmpLayer == null) continue;
                this.itemLayers.add(tmpLayer);
            }
        }
    }

    @Override
    public List<IGeoResource> getSelectedLayers() {
        return this.itemLayers;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof JGrassMapsetGeoResource) {
                JGrassMapsetGeoResource map = (JGrassMapsetGeoResource)arg0;
                List<IResolve> layers = map.members(null);
                if (layers == null) {
                    return null;
                }
                return this.filteredLayers(layers);
            }
            if (arg0 instanceof JGrassMapGeoResource) {
                return null;
            }
            return null;
        }

        private Object[] filteredLayers(List<IResolve> layers) {
            try {
                Vector<JGrassMapGeoResource> filteredLayers = new Vector<JGrassMapGeoResource>();
                for (IResolve layer : layers) {
                    if (!(layer instanceof JGrassMapGeoResource) || !((JGrassMapGeoResource)layer).getType().equals("grassbinaryraster") && !((JGrassMapGeoResource)layer).getType().equals("grassasciiraster") && !((JGrassMapGeoResource)layer).getType().equals("esriasciigrid") && !((JGrassMapGeoResource)layer).getType().equals("fluidturtleasciiraster")) continue;
                    filteredLayers.add((JGrassMapGeoResource)layer);
                    JGRasterCatalogTreeViewer.this.itemsMap.put(((JGrassMapGeoResource)layer).getInfo(null).getTitle(), (JGrassMapGeoResource)layer);
                }
                HashMap<String, JGrassMapGeoResource> tmp = new HashMap<String, JGrassMapGeoResource>();
                for (JGrassMapGeoResource resource : filteredLayers) {
                    tmp.put(resource.getInfo(null).getTitle(), resource);
                }
                TreeMap sortedMap = new TreeMap(tmp);
                filteredLayers.removeAllElements();
                for (JGrassMapGeoResource map : sortedMap.values()) {
                    filteredLayers.add(map);
                }
                return filteredLayers.toArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getParent(Object arg0) {
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return null;
            }
            if (arg0 instanceof JGrassMapGeoResource) {
                try {
                    return ((JGrassMapGeoResource)((Object)arg0)).parent(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return true;
            }
            if (arg0 instanceof JGrassMapGeoResource) {
                return false;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
            ArrayList<IResolve> neededCatalogMembers = null;
            try {
                List allCatalogMembers = catalog.members(null);
                neededCatalogMembers = new ArrayList<IResolve>();
                for (IResolve catalogMember : allCatalogMembers) {
                    if (!(catalogMember instanceof JGrassService)) continue;
                    List<IResolve> layers = ((JGrassService)catalogMember).members(null);
                    for (IResolve resource : layers) {
                        if (JGRasterCatalogTreeViewer.this.mapset != null && resource instanceof JGrassMapsetGeoResource) {
                            JGrassMapsetGeoResource map = (JGrassMapsetGeoResource)resource;
                            File refFile = map.getFile();
                            File mapsetFile = new File(JGRasterCatalogTreeViewer.this.mapset);
                            if (!refFile.getAbsolutePath().equals(mapsetFile.getAbsolutePath())) continue;
                            neededCatalogMembers.add(resource);
                            continue;
                        }
                        neededCatalogMembers.add(resource);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (neededCatalogMembers != null) {
                return neededCatalogMembers.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
        private final Image rasterMaps = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif").createImage();
        private final Image mainRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/jgrass_obj.gif").createImage();
        private final Image grassasciiRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/grassascii.gif").createImage();
        private final Image esriasciiRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/esrigrid.gif").createImage();
        private final Image fluidturtleRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/ftraster.gif").createImage();
        private final Image problemRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/problem.gif").createImage();

        public Image getImage(Object arg0) {
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return this.mainRasterMaps;
            }
            if (arg0 instanceof JGrassMapGeoResource) {
                if (((JGrassMapGeoResource)((Object)arg0)).getType().equals("grassbinaryraster")) {
                    return this.rasterMaps;
                }
                if (((JGrassMapGeoResource)((Object)arg0)).getType().equals("grassasciiraster")) {
                    return this.grassasciiRasterMaps;
                }
                if (((JGrassMapGeoResource)((Object)arg0)).getType().equals("esriasciigrid")) {
                    return this.esriasciiRasterMaps;
                }
                if (((JGrassMapGeoResource)((Object)arg0)).getType().equals("fluidturtleasciiraster")) {
                    return this.fluidturtleRasterMaps;
                }
                return this.problemRasterMaps;
            }
            return null;
        }

        public String getText(Object arg0) {
            String text = null;
            try {
                if (arg0 instanceof JGrassMapsetGeoResource) {
                    String locationName = ((JGrassService)((JGrassMapsetGeoResource)arg0).parent(null)).getInfo(null).getTitle();
                    String mapsetName = ((JGrassMapsetGeoResource)arg0).getTitle();
                    text = String.valueOf(locationName) + Messages.getString("JGRasterCatalogTreeViewer.loc-mapset-name-delimiter") + mapsetName;
                } else if (arg0 instanceof JGrassMapGeoResource) {
                    text = ((JGrassMapGeoResource)((Object)arg0)).getInfo(null).getTitle();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return text;
        }

        public void addListener(ILabelProviderListener arg0) {
            this.listeners.add(arg0);
        }

        public void dispose() {
            if (this.rasterMaps != null) {
                this.rasterMaps.dispose();
            }
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
            this.listeners.remove(arg0);
        }
    }
}

