/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.geotools.data.DataStore;

public class FeatureCatalogTreeViewer
extends Composite
implements ISelectionChangedListener,
IResourcesSelector {
    public static final int SHAPELAYER = 0;
    public static final int GRASSRASTERLAYER = 1;
    private final HashMap<String, DataStore> itemsMap = new HashMap();
    private LabelProvider labelProvider = null;
    private List<DataStore> itemLayers;

    public FeatureCatalogTreeViewer(Composite parent, int style, int selectionStyle) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree((Composite)this, selectionStyle, patternFilter);
        TreeViewer tv = filter.getViewer();
        tv.getTree().setLayoutData((Object)new GridData(1808));
        tv.setContentProvider((IContentProvider)new ContentProvider());
        this.labelProvider = new LabelProvider();
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.setInput((Object)"dummy");
        tv.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Vector<String> itemNames = new Vector<String>();
            for (Object domain : selection) {
                String value = this.labelProvider.getText(domain);
                itemNames.add(value);
            }
            this.itemLayers = new ArrayList<DataStore>();
            for (String name : itemNames) {
                DataStore tmpLayer = this.itemsMap.get(name);
                if (tmpLayer == null) continue;
                this.itemLayers.add(tmpLayer);
            }
        }
    }

    @Override
    public List<DataStore> getSelectedLayers() {
        return this.itemLayers;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            return false;
        }

        public Object[] getElements(Object arg0) {
            ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
            ArrayList<IResolve> neededCatalogMembers = null;
            try {
                List allCatalogMembers = catalog.members(null);
                neededCatalogMembers = new ArrayList<IResolve>();
                for (IResolve catalogMember : allCatalogMembers) {
                    if (!catalogMember.canResolve(DataStore.class)) continue;
                    neededCatalogMembers.add(catalogMember);
                    FeatureCatalogTreeViewer.this.itemsMap.put(new File(catalogMember.getIdentifier().getPath()).getName(), (DataStore)catalogMember.resolve(DataStore.class, null));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (neededCatalogMembers != null) {
                return neededCatalogMembers.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
        private final Image vectorMaps = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/feature_obj.gif").createImage();

        public Image getImage(Object arg0) {
            if (arg0 instanceof IResolve) {
                return this.vectorMaps;
            }
            return null;
        }

        public String getText(Object arg0) {
            String text = null;
            if (arg0 instanceof IResolve) {
                text = new File(((IResolve)arg0).getIdentifier().getPath()).getName();
            }
            return text;
        }

        public void addListener(ILabelProviderListener arg0) {
            this.listeners.add(arg0);
        }

        public void dispose() {
            if (this.vectorMaps != null) {
                this.vectorMaps.dispose();
            }
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
            this.listeners.remove(arg0);
        }
    }
}

