/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion;

import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.activeregion.ActiveRegionMapGraphic;
import eu.udig.catalog.jgrass.activeregion.ActiveRegionStyle;
import eu.udig.catalog.jgrass.activeregion.ActiveregionStyleContent;
import eu.udig.catalog.jgrass.activeregion.dialogs.CatalogJGrassMapsetTreeViewerDialog;
import eu.udig.catalog.jgrass.activeregion.dialogs.FeatureChooserDialog;
import eu.udig.catalog.jgrass.activeregion.dialogs.JGRasterChooserDialog;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.impl.UDIGFeatureStore;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ActiveregionGraphicStyleConfigurator
extends IStyleConfigurator
implements SelectionListener,
ModifyListener {
    private static final int bound_type = 0;
    private static final int row_type = 1;
    private static final int res_type = 2;
    private Label northLabel = null;
    private Text northText = null;
    private Label rowsLabel = null;
    private Text rowsText = null;
    private Label southLabel = null;
    private Text southText = null;
    private Label colsLabel = null;
    private Text colsText = null;
    private Label westLabel = null;
    private Text westText = null;
    private Label xresLabel = null;
    private Text xresText = null;
    private Label eastLabel = null;
    private Text eastText = null;
    private Label yresLabel = null;
    private Text yresText = null;
    private Button rasterMapSetButton = null;
    private Button featuresMapSetButton = null;
    private Button resetToActiveButton = null;
    private ColorEditor backgroundColour;
    private ColorEditor foregroundColor;
    private Text backgroundAlphaText;
    private Text forgroundAlphaText;
    private ActiveRegionStyle style = null;
    private boolean isWorking = false;
    private IBlackboard blackboard;
    private Button gridButton;
    private Composite parent;
    private Text windPathText;
    private JGrassMapsetGeoResource jGrassMapsetGeoResource;

    public void createControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 512);
        scrollComposite.setMinHeight(100);
        scrollComposite.setLayoutData((Object)new GridData(1808));
        Composite c = new Composite((Composite)scrollComposite, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        Group chooseMapsetGroup = new Group(c, 2048);
        GridLayout layout1 = new GridLayout(3, false);
        chooseMapsetGroup.setLayout((Layout)layout1);
        chooseMapsetGroup.setLayoutData((Object)new GridData(768));
        chooseMapsetGroup.setText("Ruling / Affected mapset");
        Label mapsetLabel = new Label((Composite)chooseMapsetGroup, 0);
        mapsetLabel.setText("wind file for active region:  ");
        this.windPathText = new Text((Composite)chooseMapsetGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = 100;
        this.windPathText.setLayoutData((Object)gd);
        this.windPathText.setEditable(false);
        final Button mapsetButton = new Button((Composite)chooseMapsetGroup, 2056);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 128;
        mapsetButton.setLayoutData((Object)gd2);
        mapsetButton.setText("Browse");
        mapsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CatalogJGrassMapsetTreeViewerDialog cDialog = new CatalogJGrassMapsetTreeViewerDialog();
                cDialog.open(mapsetButton.getShell());
                List<JGrassMapsetGeoResource> selectedLayers = cDialog.getSelectedLayers();
                if (selectedLayers == null || selectedLayers.size() == 0) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.jGrassMapsetGeoResource = selectedLayers.get(0);
                String windPath = ActiveregionGraphicStyleConfigurator.this.jGrassMapsetGeoResource.getActiveRegionWindowPath();
                ActiveregionGraphicStyleConfigurator.this.windPathText.setText(windPath);
                JGrassRegion jgR = ActiveregionGraphicStyleConfigurator.this.jGrassMapsetGeoResource.getActiveRegionWindow();
                CoordinateReferenceSystem crs = ActiveregionGraphicStyleConfigurator.this.jGrassMapsetGeoResource.getLocationCrs();
                ActiveregionGraphicStyleConfigurator.this.commitToBlackboards(jgR, crs, windPath);
            }
        });
        Group regionGroup = new Group(c, 2048);
        GridLayout layout2 = new GridLayout(2, true);
        regionGroup.setLayout((Layout)layout2);
        regionGroup.setText("Region settings");
        regionGroup.setLayoutData((Object)new GridData(768));
        this.northLabel = new Label((Composite)regionGroup, 0);
        this.northLabel.setText("north");
        this.northLabel.setLayoutData((Object)new GridData(768));
        this.northText = new Text((Composite)regionGroup, 2048);
        this.northText.setLayoutData((Object)new GridData(768));
        this.southLabel = new Label((Composite)regionGroup, 0);
        this.southLabel.setText("south");
        this.southLabel.setLayoutData((Object)new GridData(768));
        this.southText = new Text((Composite)regionGroup, 2048);
        this.southText.setLayoutData((Object)new GridData(768));
        this.westLabel = new Label((Composite)regionGroup, 0);
        this.westLabel.setText("west");
        this.westLabel.setLayoutData((Object)new GridData(768));
        this.westText = new Text((Composite)regionGroup, 2048);
        this.westText.setLayoutData((Object)new GridData(768));
        this.eastLabel = new Label((Composite)regionGroup, 0);
        this.eastLabel.setText("east");
        this.eastLabel.setLayoutData((Object)new GridData(768));
        this.eastText = new Text((Composite)regionGroup, 2048);
        this.eastText.setLayoutData((Object)new GridData(768));
        this.rowsLabel = new Label((Composite)regionGroup, 0);
        this.rowsLabel.setText("rows");
        this.rowsLabel.setLayoutData((Object)new GridData(768));
        this.rowsText = new Text((Composite)regionGroup, 2048);
        this.rowsText.setLayoutData((Object)new GridData(768));
        this.colsLabel = new Label((Composite)regionGroup, 0);
        this.colsLabel.setText("cols");
        this.colsLabel.setLayoutData((Object)new GridData(768));
        this.colsText = new Text((Composite)regionGroup, 2048);
        this.colsText.setLayoutData((Object)new GridData(768));
        this.xresLabel = new Label((Composite)regionGroup, 0);
        this.xresLabel.setText("xres");
        this.xresLabel.setLayoutData((Object)new GridData(768));
        this.xresText = new Text((Composite)regionGroup, 2048);
        this.xresText.setLayoutData((Object)new GridData(768));
        this.yresLabel = new Label((Composite)regionGroup, 0);
        this.yresLabel.setText("yres");
        this.yresLabel.setLayoutData((Object)new GridData(768));
        this.yresText = new Text((Composite)regionGroup, 2048);
        this.yresText.setLayoutData((Object)new GridData(768));
        Group styleGroup = new Group(c, 2048);
        GridLayout layout3 = new GridLayout(2, true);
        styleGroup.setLayout((Layout)layout3);
        styleGroup.setText("Style properties");
        styleGroup.setLayoutData((Object)new GridData(768));
        this.gridButton = new Button((Composite)styleGroup, 2080);
        this.gridButton.setText("visualize active region grid");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.gridButton.setLayoutData((Object)gridData);
        Label backgroundColourLabel = new Label((Composite)styleGroup, 0);
        backgroundColourLabel.setLayoutData((Object)new GridData(768));
        backgroundColourLabel.setText("background color");
        this.backgroundColour = new ColorEditor((Composite)styleGroup);
        this.backgroundColour.getButton().setLayoutData((Object)new GridData(768));
        Label backgroundAlphaLabel = new Label((Composite)styleGroup, 0);
        backgroundAlphaLabel.setLayoutData((Object)new GridData(768));
        backgroundAlphaLabel.setText("background alpha (0-1)");
        this.backgroundAlphaText = new Text((Composite)styleGroup, 2048);
        this.backgroundAlphaText.setLayoutData((Object)new GridData(768));
        Label foregroundColourLabel = new Label((Composite)styleGroup, 0);
        foregroundColourLabel.setLayoutData((Object)new GridData(768));
        foregroundColourLabel.setText("foreground color");
        this.foregroundColor = new ColorEditor((Composite)styleGroup);
        this.foregroundColor.getButton().setLayoutData((Object)new GridData(768));
        Label forgroundAlphaLabel = new Label((Composite)styleGroup, 0);
        forgroundAlphaLabel.setLayoutData((Object)new GridData(768));
        forgroundAlphaLabel.setText("foreground alpha (0-1)");
        this.forgroundAlphaText = new Text((Composite)styleGroup, 2048);
        this.forgroundAlphaText.setLayoutData((Object)new GridData(768));
        final Group settoGroup = new Group(c, 2048);
        GridLayout layout4 = new GridLayout(1, true);
        settoGroup.setLayout((Layout)layout4);
        settoGroup.setText("Set region to...");
        settoGroup.setLayoutData((Object)new GridData(768));
        this.rasterMapSetButton = new Button((Composite)settoGroup, 0);
        this.rasterMapSetButton.setText("set region to raster map");
        this.rasterMapSetButton.setLayoutData((Object)new GridData(768));
        this.rasterMapSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JGRasterChooserDialog tree = new JGRasterChooserDialog(null);
                tree.open(settoGroup.getShell(), 4);
                ActiveregionGraphicStyleConfigurator.this.update(tree.getSelectedResources());
            }
        });
        this.featuresMapSetButton = new Button((Composite)settoGroup, 0);
        this.featuresMapSetButton.setText("set region to vector map");
        this.featuresMapSetButton.setLayoutData((Object)new GridData(768));
        this.featuresMapSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureChooserDialog tree = new FeatureChooserDialog();
                tree.open(settoGroup.getShell(), 4);
                ActiveregionGraphicStyleConfigurator.this.update(tree.getSelectedResources());
            }
        });
        this.resetToActiveButton = new Button((Composite)settoGroup, 0);
        this.resetToActiveButton.setText("reset back to actual region");
        this.resetToActiveButton.setLayoutData((Object)new GridData(768));
        this.resetToActiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String windPath = ActiveregionGraphicStyleConfigurator.this.windPathText.getText();
                try {
                    JGrassRegion jgR = new JGrassRegion(windPath);
                    ActiveregionGraphicStyleConfigurator.this.setWidgetsToWindow(jgR);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.northText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.southText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.rowsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(1);
            }
        });
        this.colsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(1);
            }
        });
        this.westText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.xresText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(2);
            }
        });
        this.eastText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.yresText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ActiveregionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ActiveregionGraphicStyleConfigurator.this.textModified(2);
            }
        });
        this.foregroundColor.addSelectionListener((SelectionListener)this);
        this.backgroundColour.addSelectionListener((SelectionListener)this);
        c.layout();
        Point size = c.computeSize(-1, -1);
        c.setSize(size);
        scrollComposite.setContent((Control)c);
    }

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(ActiveRegionMapGraphic.class);
    }

    protected void refresh() {
        try {
            IBlackboard blackboard = this.getLayer().getMap().getBlackboard();
            this.style = (ActiveRegionStyle)blackboard.get("eu.udig.catalog.jgrass.activeregion.activeregionStyle");
            if (this.style == null) {
                this.style = ActiveregionStyleContent.createDefault();
                blackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)this.style);
            }
            if (this.style.windPath == null) {
                CatalogJGrassMapsetTreeViewerDialog mapsetDialog = new CatalogJGrassMapsetTreeViewerDialog();
                mapsetDialog.open(this.parent.getShell());
                this.jGrassMapsetGeoResource = mapsetDialog.getSelectedLayers().get(0);
                JGrassRegion activeRegionWindow = this.jGrassMapsetGeoResource.getActiveRegionWindow();
                this.style.windPath = this.jGrassMapsetGeoResource.getActiveRegionWindowPath();
                this.style.north = (float)activeRegionWindow.getNorth();
                this.style.south = (float)activeRegionWindow.getSouth();
                this.style.west = (float)activeRegionWindow.getWest();
                this.style.east = (float)activeRegionWindow.getEast();
                this.style.rows = activeRegionWindow.getRows();
                this.style.cols = activeRegionWindow.getCols();
                CoordinateReferenceSystem jGrassCrs = this.jGrassMapsetGeoResource.getLocationCrs();
                try {
                    Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)jGrassCrs, (boolean)true);
                    this.style.crsString = "EPSG:" + epsg;
                }
                catch (Exception exception) {
                    this.style.crsString = CRS.lookupIdentifier((IdentifiedObject)jGrassCrs, (boolean)true);
                }
            }
            this.windPathText.setText(this.style.windPath);
            JGrassRegion tmp = new JGrassRegion((double)this.style.west, (double)this.style.east, (double)this.style.south, (double)this.style.north, this.style.rows, this.style.cols);
            this.isWorking = true;
            this.northText.setText(String.valueOf(this.style.north));
            this.southText.setText(String.valueOf(this.style.south));
            this.westText.setText(String.valueOf(this.style.west));
            this.eastText.setText(String.valueOf(this.style.east));
            this.xresText.setText(String.valueOf(tmp.getWEResolution()));
            this.yresText.setText(String.valueOf(tmp.getNSResolution()));
            this.colsText.setText(String.valueOf(this.style.cols));
            this.rowsText.setText(String.valueOf(this.style.rows));
            this.isWorking = false;
            this.forgroundAlphaText.setText(Float.toString(this.style.fAlpha));
            this.backgroundAlphaText.setText(Float.toString(this.style.bAlpha));
            this.foregroundColor.setColorValue(new RGB(this.style.foregroundColor.getRed(), this.style.foregroundColor.getGreen(), this.style.foregroundColor.getBlue()));
            this.backgroundColour.setColorValue(new RGB(this.style.backgroundColor.getRed(), this.style.backgroundColor.getGreen(), this.style.backgroundColor.getBlue()));
            CoordinateReferenceSystem crs = CRS.decode((String)this.style.crsString);
            this.commitToBlackboards(tmp, crs, this.style.windPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateBlackboard() {
        int bAlpha;
        ActiveRegionStyle style = this.getActiveRegionStyle();
        RGB bg = this.backgroundColour.getColorValue();
        try {
            bAlpha = Integer.parseInt(this.backgroundAlphaText.getText());
            style.backgroundColor = new Color(bg.red, bg.green, bg.blue, bAlpha);
        }
        catch (Exception exception) {
            style.backgroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        bg = this.foregroundColor.getColorValue();
        try {
            bAlpha = Integer.parseInt(this.forgroundAlphaText.getText());
            style.foregroundColor = new Color(bg.red, bg.green, bg.blue, bAlpha);
        }
        catch (Exception exception) {
            style.foregroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        this.dumpActiveRegionStyle(style);
    }

    private void dumpActiveRegionStyle(ActiveRegionStyle style) {
        this.blackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)style);
    }

    private ActiveRegionStyle getActiveRegionStyle() {
        ActiveRegionStyle style = (ActiveRegionStyle)this.blackboard.get("eu.udig.catalog.jgrass.activeregion.activeregionStyle");
        if (style == null) {
            style = ActiveregionStyleContent.createDefault();
        }
        return style;
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void modifyText(ModifyEvent e) {
        this.updateBlackboard();
    }

    public void update(Object updatedObject) {
        if (updatedObject instanceof List) {
            String text = null;
            List layers = (List)updatedObject;
            for (Object layer : layers) {
                if (layer instanceof JGrassMapGeoResource) {
                    JGrassMapGeoResource rasterMapResource = (JGrassMapGeoResource)((Object)layer);
                    try {
                        text = rasterMapResource.getInfo(null).getName();
                        JGrassRegion fileWindow = rasterMapResource.getFileWindow();
                        if (fileWindow == null) continue;
                        this.setWidgetsToWindow(fileWindow);
                        continue;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
                if (layer instanceof DataStore || layer instanceof UDIGFeatureStore) {
                    try {
                        DataStore store = (DataStore)layer;
                        SimpleFeatureSource featureStore = store.getFeatureSource(store.getTypeNames()[0]);
                        ReferencedEnvelope envelope = featureStore.getBounds();
                        ActiveRegionStyle style = this.getActiveRegionStyle();
                        JGrassRegion activeWindow = new JGrassRegion((double)style.west, (double)style.east, (double)style.south, (double)style.north, style.rows, style.cols);
                        JGrassRegion newWindow = JGrassRegion.adaptActiveRegionToEnvelope((Envelope)envelope, (JGrassRegion)activeWindow);
                        this.northText.setText(String.valueOf(newWindow.getNorth()));
                        this.southText.setText(String.valueOf(newWindow.getSouth()));
                        this.eastText.setText(String.valueOf(newWindow.getEast()));
                        this.westText.setText(String.valueOf(newWindow.getWest()));
                        this.textModified(0);
                        continue;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                return;
            }
            if (text == null) {
                return;
            }
        }
    }

    public void preApply() {
        double n = Double.parseDouble(this.northText.getText());
        double s = Double.parseDouble(this.southText.getText());
        double w = Double.parseDouble(this.westText.getText());
        double e = Double.parseDouble(this.eastText.getText());
        double xr = Double.parseDouble(this.xresText.getText());
        double yr = Double.parseDouble(this.yresText.getText());
        JGrassRegion newRegion = new JGrassRegion(w, e, s, n, xr, yr);
        try {
            File mapsetFile = new File(this.style.windPath).getParentFile();
            File locationFile = mapsetFile.getParentFile();
            JGrassRegion.writeWINDToMapset((String)mapsetFile.getAbsolutePath(), (JGrassRegion)newRegion);
            CoordinateReferenceSystem locationCrs = JGrassCatalogUtilities.getLocationCrs(locationFile.getAbsolutePath());
            this.style.fAlpha = Float.parseFloat(this.forgroundAlphaText.getText());
            this.style.bAlpha = Float.parseFloat(this.backgroundAlphaText.getText());
            RGB bg = this.backgroundColour.getColorValue();
            this.style.backgroundColor = new Color(bg.red, bg.green, bg.blue);
            bg = this.foregroundColor.getColorValue();
            this.style.foregroundColor = new Color(bg.red, bg.green, bg.blue);
            this.style.doGrid = this.gridButton.getSelection();
            this.commitToBlackboards(newRegion, locationCrs, this.style.windPath);
            super.preApply();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void commitToBlackboards(JGrassRegion jgR, CoordinateReferenceSystem crs, String windPath) {
        this.blackboard = this.getLayer().getMap().getBlackboard();
        this.style.north = (float)jgR.getNorth();
        this.style.south = (float)jgR.getSouth();
        this.style.east = (float)jgR.getEast();
        this.style.west = (float)jgR.getWest();
        this.style.rows = jgR.getRows();
        this.style.cols = jgR.getCols();
        this.style.windPath = windPath;
        try {
            try {
                Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                this.style.crsString = "EPSG:" + epsg;
            }
            catch (Exception exception) {
                this.style.crsString = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
            }
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        this.blackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)this.style);
        this.getLayer().setStatus(0);
    }

    private synchronized void textModified(int type) {
        this.isWorking = true;
        String northstr = this.northText.getText();
        String southstr = this.southText.getText();
        String eaststr = this.eastText.getText();
        String weststr = this.westText.getText();
        String rowsstr = this.rowsText.getText();
        String colsstr = this.colsText.getText();
        String ewresstr = this.xresText.getText();
        String nsresstr = this.yresText.getText();
        if (northstr.length() == 0 || southstr.length() == 0 || eaststr.length() == 0 || weststr.length() == 0 || rowsstr.length() == 0 || colsstr.length() == 0 || ewresstr.length() == 0 || nsresstr.length() == 0) {
            this.isWorking = false;
            return;
        }
        if (type == 0) {
            int rownum = (int)Math.round((new Double(northstr) - new Double(southstr)) / new Double(nsresstr));
            int colnum = (int)Math.round((new Double(eaststr) - new Double(weststr)) / new Double(ewresstr));
            double newnsres = (new Double(northstr) - new Double(southstr)) / (double)rownum;
            double newewres = (new Double(eaststr) - new Double(weststr)) / (double)colnum;
            this.rowsText.setText(String.valueOf(rownum));
            this.colsText.setText(String.valueOf(colnum));
            this.yresText.setText(String.valueOf(newnsres));
            this.xresText.setText(String.valueOf(newewres));
        } else if (type == 1 || type == 2) {
            int rownum = 0;
            int colnum = 0;
            double newnsres = 0.0;
            double newewres = 0.0;
            if (type == 1) {
                newnsres = (Double.parseDouble(northstr) - Double.parseDouble(southstr)) / Double.parseDouble(rowsstr);
                rownum = (int)Math.round((Double.parseDouble(northstr) - Double.parseDouble(southstr)) / newnsres);
                newnsres = (Double.parseDouble(northstr) - Double.parseDouble(southstr)) / (double)rownum;
                newewres = (Double.parseDouble(eaststr) - Double.parseDouble(weststr)) / Double.parseDouble(colsstr);
                colnum = (int)Math.round((Double.parseDouble(eaststr) - Double.parseDouble(weststr)) / newewres);
                newewres = (Double.parseDouble(eaststr) - Double.parseDouble(weststr)) / (double)colnum;
                this.rowsText.setText(String.valueOf(rownum));
                this.yresText.setText(String.valueOf(newnsres));
                this.colsText.setText(String.valueOf(colnum));
                this.xresText.setText(String.valueOf(newewres));
            } else if (type == 2) {
                double deltaWE;
                double n = Double.parseDouble(northstr);
                double s = Double.parseDouble(southstr);
                double nsRes = Double.parseDouble(nsresstr);
                double e = Double.parseDouble(eaststr);
                double w = Double.parseDouble(weststr);
                double ewRes = Double.parseDouble(ewresstr);
                double deltaNS = (n - s) % nsRes;
                if (deltaNS > 1.0E-5) {
                    s = s + deltaNS - nsRes;
                }
                if ((deltaWE = (e - w) % ewRes) > 0.0) {
                    e = e - deltaWE + ewRes;
                }
                this.southText.setText(String.valueOf(s));
                this.eastText.setText(String.valueOf(e));
                rownum = (int)Math.round((n - s) / nsRes);
                colnum = (int)Math.round((e - w) / ewRes);
                this.rowsText.setText(String.valueOf(rownum));
                this.colsText.setText(String.valueOf(colnum));
            }
        }
        this.isWorking = false;
    }

    private void setWidgetsToWindow(JGrassRegion window) {
        this.northText.setText(String.valueOf(window.getNorth()));
        this.southText.setText(String.valueOf(window.getSouth()));
        this.westText.setText(String.valueOf(window.getWest()));
        this.eastText.setText(String.valueOf(window.getEast()));
        this.rowsText.setText(String.valueOf(window.getRows()));
        this.colsText.setText(String.valueOf(window.getCols()));
        this.xresText.setText(String.valueOf(window.getWEResolution()));
        this.yresText.setText(String.valueOf(window.getNSResolution()));
    }
}

