/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.db2.ui;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.db2.DB2Plugin;
import net.refractions.udig.catalog.db2.internal.Messages;
import net.refractions.udig.catalog.internal.db2.DB2ServiceExtension;
import net.refractions.udig.catalog.internal.db2.ui.DB2Preferences;
import net.refractions.udig.catalog.ui.preferences.AbstractProprietaryDatastoreWizardPage;
import net.refractions.udig.catalog.ui.preferences.AbstractProprietaryJarPreferencePage;
import net.refractions.udig.catalog.ui.wizard.DataBaseConnInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.db2.DB2NGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class DB2WizardPage
extends AbstractProprietaryDatastoreWizardPage {
    public final String IMAGE_KEY = "DB2PageImage";
    private static final String DB2_RECENT = "DB2_RECENT";
    private static final String DB2_WIZARD = "DB2_WIZARD";
    private static final DataBaseConnInfo DEFAULT_DB2_CONN_INFO = new DataBaseConnInfo("", "50000", "", "", "", "");
    private static DB2NGDataStoreFactory factory = DB2ServiceExtension.getFactory();
    ArrayList<DataBaseConnInfo> dbData;

    public DB2WizardPage() {
        super(Messages.DB2WizardPage_title);
        this.settings = DB2Plugin.getDefault().getDialogSettings().getSection(DB2_WIZARD);
        if (this.settings == null) {
            this.settings = DB2Plugin.getDefault().getDialogSettings().addNewSection(DB2_WIZARD);
        }
        this.settingsArrayName = DB2_RECENT;
        this.defaultDBCI.setParameters(DEFAULT_DB2_CONN_INFO);
        this.currentDBCI.setParameters(this.defaultDBCI);
        String[] recent = this.settings.getArray(DB2_RECENT);
        if (recent != null) {
            String[] stringArray = recent;
            int n = recent.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                DataBaseConnInfo dbs = new DataBaseConnInfo(s);
                if (!this.storedDBCIList.contains(dbs)) {
                    this.storedDBCIList.add(dbs);
                }
                ++n2;
            }
        }
    }

    protected boolean areAllFieldsFilled() {
        if (!DB2Preferences.isInstalled()) {
            return false;
        }
        return this.couldConnect();
    }

    private String emptyAsNull(String value) {
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    protected boolean excludeSchemaFromUserChoices(String schemaName) {
        return false;
    }

    protected DataSource getDataSource() {
        final String hostText = this.currentDBCI.getHostString();
        final String portText = this.currentDBCI.getPortString();
        final String userText = this.currentDBCI.getUserString();
        final String passText = this.currentDBCI.getPassString();
        final String db = this.currentDBCI.getDbString();
        if (!this.areAllFieldsFilled()) {
            return null;
        }
        if (this.dataSource == null) {
            this.runInPage(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    Connection connection = null;
                    try {
                        try {
                            monitor.beginTask(Messages.DB2WizardPage_connectionTask, -1);
                            if (DB2WizardPage.this.dataSource != null) {
                                try {
                                    DB2WizardPage.this.dataSource.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put(JDBCDataStoreFactory.HOST.key, hostText);
                            params.put(JDBCDataStoreFactory.PORT.key, (Integer)JDBCDataStoreFactory.PORT.parse(portText));
                            params.put(JDBCDataStoreFactory.DATABASE.key, db);
                            DB2WizardPage.this.dataSource = DB2ServiceExtension.getFactory().createDataSource(params);
                            DB2WizardPage.this.dataSource.setUsername(userText);
                            DB2WizardPage.this.dataSource.setPassword(passText);
                            DriverManager.setLoginTimeout(3);
                            monitor.worked(1);
                            monitor.subTask("establish connection");
                            if (monitor.isCanceled()) {
                                DB2WizardPage.this.dataSource.close();
                                DB2WizardPage.this.dataSource = null;
                            }
                            connection = DB2WizardPage.this.dataSource.getConnection();
                            monitor.subTask("connected");
                            monitor.worked(1);
                        }
                        catch (Throwable shame) {
                            if (DB2WizardPage.this.dataSource != null) {
                                try {
                                    DB2WizardPage.this.dataSource.close();
                                }
                                catch (SQLException sQLException) {}
                                DB2WizardPage.this.dataSource = null;
                            }
                            throw new InvocationTargetException(shame, shame.getLocalizedMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        throw throwable;
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            });
        }
        return this.dataSource;
    }

    protected DataStoreFactorySpi getDataStoreFactorySpi() {
        return factory;
    }

    public String getId() {
        return "net.refractions.udig.catalog.ui.db2";
    }

    public Map<String, Serializable> getParams() {
        if (!DB2Preferences.isInstalled()) {
            return null;
        }
        if (!this.couldConnect()) {
            return null;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(DB2NGDataStoreFactory.DBTYPE.key, (Serializable)DB2NGDataStoreFactory.DBTYPE.sample);
        params.put(JDBCDataStoreFactory.HOST.key, (Serializable)((Object)this.emptyAsNull(this.currentDBCI.getHostString())));
        String dbport = this.emptyAsNull(this.currentDBCI.getPortString());
        try {
            params.put(JDBCDataStoreFactory.PORT.key, (Serializable)((Object)this.emptyAsNull(dbport)));
        }
        catch (NumberFormatException numberFormatException) {
            params.put(JDBCDataStoreFactory.PORT.key, (Serializable)((Object)"50000"));
        }
        String db = this.currentDBCI.getDbString();
        params.put(JDBCDataStoreFactory.DATABASE.key, (Serializable)((Object)this.emptyAsNull(db)));
        String userName = this.currentDBCI.getUserString();
        params.put(JDBCDataStoreFactory.USER.key, (Serializable)((Object)this.emptyAsNull(userName)));
        String password = this.currentDBCI.getPassString();
        params.put(JDBCDataStoreFactory.PASSWD.key, (Serializable)((Object)this.emptyAsNull(password)));
        params.put(JDBCDataStoreFactory.SCHEMA.key, (Serializable)((Object)this.emptyAsNull(this.currentDBCI.getSchemaString())));
        return params;
    }

    public List<IService> getResources(IProgressMonitor monitor) throws Exception {
        if (!this.isPageComplete()) {
            return null;
        }
        DB2ServiceExtension creator = new DB2ServiceExtension();
        IService service = creator.createService(null, this.getParams());
        service.getInfo(monitor);
        ArrayList<IService> servers = new ArrayList<IService>();
        servers.add(service);
        return servers;
    }

    protected boolean dbmsUsesSchema() {
        return true;
    }

    public boolean doIsPageComplete() {
        boolean isComplete = false;
        if (this.areAllFieldsFilled()) {
            isComplete = factory.canProcess(this.getParams());
        }
        return isComplete;
    }

    protected ResultSet getSchemasResultSet(Connection c) throws SQLException {
        Statement statement = c.createStatement();
        return statement.executeQuery("SELECT DISTINCT table_schema FROM db2gse.st_geometry_columns");
    }

    protected void doCreateWizardPage(Composite parent) {
    }

    protected String getDriversMessage() {
        return Messages.DB2WizardPage_installDrivers;
    }

    protected AbstractProprietaryJarPreferencePage getPreferencePage() {
        return new DB2Preferences();
    }

    protected String getRestartMessage() {
        return Messages.DB2WizardPage_warning;
    }
}

