/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.db2;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.db2.DB2GeoResource;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.DataStore;
import org.geotools.data.db2.DB2NGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;

public class DB2Service
extends IService {
    private volatile JDBCDataStore ds;
    private volatile List<DB2GeoResource> members;
    private URL url;
    private Map<String, Serializable> params;
    Throwable msg;
    protected Lock rLock = new UDIGDisplaySafeLock();
    private Lock dsInstantiationLock = new UDIGDisplaySafeLock();

    public DB2Service(URL id, Map<String, Serializable> params2) {
        this.url = id;
        this.params = params2;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(DataStore.class) || super.canResolve(adaptee));
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(DataStore.class)) {
            return adaptee.cast(this.getDataStore(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.ds != null) {
            this.ds.dispose();
            this.ds = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<DB2GeoResource> resources(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            JDBCDataStore ds = this.getDataStore(monitor);
            if (ds == null) {
                return null;
            }
            this.rLock.lock();
            try {
                if (this.members != null) return this.members;
                this.members = new ArrayList<DB2GeoResource>();
                String[] names = ds.getTypeNames();
                if (names == null) {
                    List<DB2GeoResource> list = this.members;
                    return list;
                }
                int i = 0;
                while (i < names.length) {
                    this.members.add(new DB2GeoResource(this, names[i]));
                    ++i;
                }
                return this.members;
            }
            finally {
                this.rLock.unlock();
            }
        } else {
            monitor.done();
        }
        return this.members;
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public IResolve.Status getStatus() {
        if (this.ds == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.url;
    }

    public DB2ServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (DB2ServiceInfo)super.getInfo(monitor);
    }

    protected DB2ServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        JDBCDataStore ds = this.getDataStore(monitor);
        if (ds == null) {
            return null;
        }
        this.rLock.lock();
        try {
            DB2ServiceInfo dB2ServiceInfo = new DB2ServiceInfo(null);
            return dB2ServiceInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    JDBCDataStore getDataStore(IProgressMonitor monitor) throws IOException {
        block9: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (this.ds == null) {
                this.dsInstantiationLock.lock();
                try {
                    if (this.ds != null) break block9;
                    DB2NGDataStoreFactory dsf = new DB2NGDataStoreFactory();
                    try {
                        HashMap<String, String> paramsLocal = new HashMap<String, String>();
                        for (String key : this.params.keySet()) {
                            String value = this.params.get(key).toString();
                            paramsLocal.put(key, value);
                        }
                        if (dsf.canProcess(paramsLocal)) {
                            this.ds = dsf.createDataStore(paramsLocal);
                        }
                    }
                    catch (IOException e) {
                        this.msg = e;
                        throw e;
                    }
                }
                finally {
                    this.dsInstantiationLock.unlock();
                }
            }
        }
        return this.ds;
    }

    class DB2ServiceInfo
    extends IServiceInfo {
        public DB2ServiceInfo(IProgressMonitor monitor) {
            String[] tns = null;
            try {
                tns = DB2Service.this.getDataStore(monitor).getTypeNames();
            }
            catch (IOException e) {
                CatalogPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
                tns = new String[]{};
            }
            if (tns == null) {
                tns = new String[]{};
            }
            this.keywords = new String[tns.length + 1];
            System.arraycopy(tns, 0, this.keywords, 1, tns.length);
            this.keywords[0] = "db2";
            try {
                this.schema = new URI("jdbc://db2/gml");
            }
            catch (URISyntaxException e) {
                CatalogPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            }
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.catalog.db2", (String)"icons/obj16/db2_16.gif");
        }

        public String getDescription() {
            return DB2Service.this.getIdentifier().toString();
        }

        public URI getSource() {
            try {
                return DB2Service.this.getIdentifier().toURI();
            }
            catch (URISyntaxException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public String getTitle() {
            return "DB2 " + DB2Service.this.getIdentifier().getHost();
        }
    }
}

