/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.db2;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.db2.DB2Service;
import net.refractions.udig.ui.graphics.Glyph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2GeoResource
extends IGeoResource {
    DB2Service parent;
    String name;

    DB2GeoResource(DB2Service parent, String name) {
        this.service = parent;
        this.parent = parent;
        this.name = name;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || adaptee.isAssignableFrom(IService.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        FeatureSource fs;
        SimpleFeatureSource fs2;
        JDBCDataStore ds;
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureSource.class) && (ds = this.parent.getDataStore(monitor)) != null && (fs2 = ds.getFeatureSource(this.name)) != null) {
            return adaptee.cast(fs2);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class) && (fs = (FeatureSource)this.resolve(SimpleFeatureSource.class, monitor)) != null && fs instanceof SimpleFeatureStore) {
            return adaptee.cast(fs);
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast((Object)this.parent);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public IResolve.Status getStatus() {
        return this.parent.getStatus();
    }

    public Throwable getMessage() {
        return this.parent.getMessage();
    }

    public String getName() {
        return this.name;
    }

    public URL getIdentifier() {
        try {
            return new URL(this.parent.getIdentifier() + "#" + this.name);
        }
        catch (MalformedURLException malformedURLException) {
            return this.parent.getIdentifier();
        }
    }

    public DB2GeoResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (DB2GeoResourceInfo)super.getInfo(monitor);
    }

    protected DB2GeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        try {
            this.parent.rLock.lock();
            DB2GeoResourceInfo dB2GeoResourceInfo = new DB2GeoResourceInfo(monitor, this.name);
            return dB2GeoResourceInfo;
        }
        finally {
            this.parent.rLock.unlock();
        }
    }

    class DB2GeoResourceInfo
    extends IGeoResourceInfo {
        private SimpleFeatureType ft;

        DB2GeoResourceInfo(IProgressMonitor monitor, String nameArg) throws IOException {
            block11: {
                this.ft = null;
                JDBCDataStore ds = DB2GeoResource.this.parent.getDataStore(monitor);
                if (ds == null) {
                    return;
                }
                try {
                    this.ft = ds.getSchema(nameArg);
                }
                catch (DataSourceException dataSourceException) {
                    return;
                }
                try {
                    FeatureSource fs = DB2GeoResource.this.resolve(FeatureSource.class, null);
                    if (fs != null) {
                        this.bounds = fs.getBounds();
                    }
                    if (this.bounds != null) break block11;
                    CoordinateReferenceSystem crs = ((SimpleFeatureType)fs.getSchema()).getCoordinateReferenceSystem();
                    org.opengis.geometry.Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
                    if (envelope != null) {
                        this.bounds = new ReferencedEnvelope(new Envelope(envelope.getLowerCorner().getOrdinate(0), envelope.getLowerCorner().getOrdinate(1), envelope.getUpperCorner().getOrdinate(0), envelope.getUpperCorner().getOrdinate(1)), crs);
                        break block11;
                    }
                    FeatureIterator r = fs.getFeatures().features();
                    try {
                        SimpleFeature f = (SimpleFeature)r.next();
                        this.bounds = new ReferencedEnvelope(new Envelope(), crs);
                        this.bounds.init(f.getBounds());
                        while (r.hasNext()) {
                            f = (SimpleFeature)r.next();
                            this.bounds.include(f.getBounds());
                        }
                    }
                    finally {
                        r.close();
                    }
                }
                catch (Exception e) {
                    CatalogPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.icon = Glyph.icon((SimpleFeatureType)this.ft);
            this.keywords = new String[]{"db2", this.ft.getName().getLocalPart(), this.ft.getName().getNamespaceURI()};
        }

        public CoordinateReferenceSystem getCRS() {
            return this.ft.getCoordinateReferenceSystem();
        }

        public String getName() {
            return this.ft.getName().getLocalPart();
        }

        public URI getSchema() {
            try {
                return new URI(this.ft.getName().getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        public String getTitle() {
            return this.ft.getName().getLocalPart();
        }
    }
}

