/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BBOXImpl
extends AbstractPreparedGeometryFilter
implements BBOX {
    double minx;
    double miny;
    double maxx;
    double maxy;
    String srs;

    public BBOXImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)4;
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    public BBOXImpl(FilterFactoryImpl factory, Expression name, double minx, double miny, double maxx, double maxy, String srs) {
        this((FilterFactory)factory, name, factory.createBBoxExpression(new Envelope(minx, maxx, miny, maxy)));
        this.srs = srs;
    }

    public BBOXImpl(FilterFactory factory, Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(factory, e1, e2, matchAction);
        this.filterType = (short)4;
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    public BBOXImpl(FilterFactoryImpl factory, Expression name, double minx, double miny, double maxx, double maxy, String srs, MultiValuedFilter.MatchAction matchAction) {
        this((FilterFactory)factory, name, (Expression)factory.createBBoxExpression(BBOXImpl.buildEnvelope(minx, maxx, miny, maxy, srs)), matchAction);
        this.srs = srs;
    }

    public String getPropertyName() {
        if (this.getExpression1() instanceof PropertyName) {
            PropertyName propertyName = (PropertyName)this.getExpression1();
            return propertyName.getPropertyName();
        }
        if (this.getExpression2() instanceof PropertyName) {
            PropertyName propertyName = (PropertyName)this.getExpression2();
            return propertyName.getPropertyName();
        }
        return null;
    }

    public void setPropertyName(String propertyName) {
        this.setExpression1(new AttributeExpressionImpl(propertyName));
    }

    public String getSRS() {
        return this.srs;
    }

    public void setSRS(String srs) {
        this.srs = srs;
        this.updateExpression2();
    }

    public double getMinX() {
        return this.minx;
    }

    public void setMinX(double minx) {
        this.minx = minx;
        this.updateExpression2();
    }

    public double getMinY() {
        return this.miny;
    }

    public void setMinY(double miny) {
        this.miny = miny;
        this.updateExpression2();
    }

    public double getMaxX() {
        return this.maxx;
    }

    public void setMaxX(double maxx) {
        this.maxx = maxx;
        this.updateExpression2();
    }

    public double getMaxY() {
        return this.maxy;
    }

    public void setMaxY(double maxy) {
        this.maxy = maxy;
        this.updateExpression2();
    }

    private void updateExpression2() {
        this.setExpression2(new BBoxExpressionImpl(BBOXImpl.buildEnvelope(this.minx, this.maxx, this.miny, this.maxy, this.srs)){});
    }

    @Override
    public boolean evaluateInternal(Geometry left, Geometry right) {
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                return this.preppedEvaluate(this.rightPreppedGeom, left);
            }
            case LEFT: {
                return this.preppedEvaluate(this.leftPreppedGeom, right);
            }
        }
        return this.basicEvaluate(left, right);
    }

    @Override
    protected boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.intersects(envLeft)) {
            return left.intersects(right);
        }
        return false;
    }

    private boolean preppedEvaluate(PreparedGeometry prepped, Geometry other) {
        Envelope envLeft = prepped.getGeometry().getEnvelopeInternal();
        Envelope envRight = other.getEnvelopeInternal();
        if (envRight.intersects(envLeft)) {
            return prepped.intersects(other);
        }
        return false;
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((BBOX)this, extraData);
    }

    @Override
    public void setExpression1(Expression expression) {
        this.updateMinMaxFields(expression);
        super.setExpression1(expression);
    }

    @Override
    public void setExpression2(Expression expression) {
        this.updateMinMaxFields(expression);
        super.setExpression2(expression);
    }

    private void updateMinMaxFields(Expression expression) {
        if (expression instanceof Literal) {
            Literal bbox = (Literal)expression;
            Object value = bbox.getValue();
            if (value instanceof BoundingBox) {
                BoundingBox env = (BoundingBox)value;
                this.minx = env.getMinX();
                this.maxx = env.getMaxX();
                this.miny = env.getMinY();
                this.maxy = env.getMaxY();
                this.srs = CRS.toSRS((CoordinateReferenceSystem)env.getCoordinateReferenceSystem());
            } else {
                Envelope env = null;
                if (value instanceof Envelope) {
                    env = (Envelope)value;
                } else if (value instanceof Geometry) {
                    Geometry geom = (Geometry)value;
                    env = geom.getEnvelopeInternal();
                    if (geom.getUserData() != null) {
                        if (geom.getUserData() instanceof String) {
                            this.srs = (String)geom.getUserData();
                        } else if (geom.getUserData() instanceof CoordinateReferenceSystem) {
                            this.srs = CRS.toSRS((CoordinateReferenceSystem)((CoordinateReferenceSystem)geom.getUserData()));
                        }
                    }
                } else {
                    env = (Envelope)bbox.evaluate(null, Envelope.class);
                }
                if (env == null) {
                    return;
                }
                this.minx = env.getMinX();
                this.maxx = env.getMaxX();
                this.miny = env.getMinY();
                this.maxy = env.getMaxY();
            }
        }
    }

    private static ReferencedEnvelope buildEnvelope(double minx, double maxx, double miny, double maxy, String srs) {
        CoordinateReferenceSystem crs = null;
        if (srs != null && !"".equals(srs)) {
            try {
                try {
                    crs = CRS.decode((String)srs);
                }
                catch (MismatchedDimensionException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchAuthorityCodeException e) {
                    CRS.parseWKT((String)srs);
                }
            }
            catch (FactoryException e) {
                // empty catch block
            }
        }
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }

    public BoundingBox getBounds() {
        Object value = ((Literal)this.getExpression2()).getValue();
        if (value instanceof BoundingBox) {
            return (BoundingBox)value;
        }
        return BBOXImpl.buildEnvelope(this.minx, this.maxx, this.miny, this.maxy, this.srs);
    }
}

