/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.styling.Font;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.geotools.styling.builder.TextSymbolizerBuilder;
import org.opengis.filter.expression.Expression;

public class FontBuilder
extends AbstractStyleBuilder<Font> {
    private List<Expression> families = new ArrayList<Expression>();
    private Expression style;
    private Expression weight;
    private Expression size;

    public FontBuilder() {
        this((TextSymbolizerBuilder)null);
    }

    public FontBuilder(TextSymbolizerBuilder parent) {
        super(parent);
        this.reset();
    }

    @Override
    public Font build() {
        if (this.unset) {
            return null;
        }
        Font font = this.sf.font(this.families, this.style, this.weight, this.size);
        if (this.parent == null) {
            this.reset();
        }
        return font;
    }

    public FontBuilder family(Expression family) {
        this.families.add(family);
        return this;
    }

    public FontBuilder familyName(String family) {
        return this.family(this.literal(family));
    }

    public FontBuilder family(String cqlExpression) {
        return this.family(this.cqlExpression(cqlExpression));
    }

    public FontBuilder style(Expression style) {
        this.style = style;
        return this;
    }

    public FontBuilder styleName(String style) {
        return this.style(this.literal(style));
    }

    public FontBuilder style(String cqlExpression) {
        return this.style(this.cqlExpression(cqlExpression));
    }

    public FontBuilder weight(Expression weight) {
        this.weight = weight;
        return this;
    }

    public FontBuilder weightName(String weight) {
        return this.weight(this.literal(weight));
    }

    public FontBuilder weight(String cqlExpression) {
        return this.weight(this.cqlExpression(cqlExpression));
    }

    public FontBuilder size(Expression size) {
        this.size = size;
        return this;
    }

    public FontBuilder size(double size) {
        return this.size(this.literal(size));
    }

    public FontBuilder size(String cqlExpression) {
        return this.size(this.cqlExpression(cqlExpression));
    }

    public FontBuilder reset() {
        this.unset = false;
        return this;
    }

    public FontBuilder reset(Font font) {
        if (font == null) {
            return this.reset();
        }
        this.families = font.getFamily() != null ? font.getFamily() : new ArrayList<Expression>();
        this.size = font.getSize();
        this.style = font.getStyle();
        this.weight = font.getWeight();
        this.unset = false;
        return this;
    }

    @Override
    public FontBuilder unset() {
        return (FontBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().text().labelText("label").newFont().init(this);
    }
}

