/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.kml.wizard;

import eu.udig.catalog.kml.core.KmlUtils;
import eu.udig.catalog.kml.internal.Messages;
import eu.udig.catalog.kml.wizard.KmlImportWizard;
import java.io.File;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class KmlImportWizardPage
extends WizardPage {
    public static final String ID = "eu.udig.catalog.kml.wizard.KmlImportWizardPage";
    private File inFile = null;
    private boolean inIsOk = false;

    public KmlImportWizardPage(String pageName, Map<String, String> params) {
        super(ID);
        this.setTitle(pageName);
        this.setDescription(Messages.getString("KmlImportWizardPage.description"));
    }

    public void createControl(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        fileSelectionArea.setLayout((Layout)new GridLayout());
        Group inputGroup = new Group(fileSelectionArea, 0);
        inputGroup.setText(Messages.getString("KmlImportWizardPage.chooseFileTextLabel"));
        inputGroup.setLayout((Layout)new GridLayout(2, false));
        inputGroup.setLayoutData((Object)new GridData(768));
        GridData gridData1 = new GridData(768);
        gridData1.horizontalSpan = 2;
        final Text kmlText = new Text((Composite)inputGroup, 18436);
        kmlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        kmlText.setText("");
        final Button kmlButton = new Button((Composite)inputGroup, 8);
        kmlButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        kmlButton.setText(Messages.getString("KmlWizardPages.chooseFileButtonLabel"));
        kmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(kmlButton.getShell(), 4096);
                fileDialog.setFilterExtensions(KmlUtils.SUPPORTED_FILE_EXTENSIONS);
                String path = fileDialog.open();
                if (path != null) {
                    File f = new File(path);
                    if (f.exists()) {
                        KmlImportWizardPage.this.inIsOk = true;
                        kmlText.setText(path);
                        KmlImportWizardPage.this.inFile = f;
                    } else {
                        KmlImportWizardPage.this.inIsOk = false;
                    }
                }
                KmlImportWizardPage.this.checkFinish();
            }
        });
        this.setControl((Control)fileSelectionArea);
    }

    public void dispose() {
    }

    public File getKmlFile() {
        return this.inFile;
    }

    private void checkFinish() {
        KmlImportWizard.canFinish = this.inIsOk;
        this.getWizard().getContainer().updateButtons();
    }
}

