/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.kml.wizard;

import eu.udig.catalog.kml.core.KmlToolPlugin;
import eu.udig.catalog.kml.core.KmlUtils;
import eu.udig.catalog.kml.internal.Messages;
import eu.udig.catalog.kml.wizard.KmlImportWizardPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.geotools.data.FeatureStore;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class KmlImportWizard
extends Wizard
implements INewWizard {
    private KmlImportWizardPage mainPage;
    public static boolean canFinish = false;
    private final Map<String, String> params = new HashMap<String, String>();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.getString("KmlImportWizard.windowTitle"));
        this.setDefaultPageImageDescriptor(KmlToolPlugin.getDefault().getImageDescriptor("wizban/importkml_wiz.gif"));
        this.setNeedsProgressMonitor(true);
        this.mainPage = new KmlImportWizardPage(Messages.getString("KmlImportWizard.KmlFilImportPageName"), this.params);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return super.canFinish() && canFinish;
    }

    public boolean performFinish() {
        final File kmlFile = this.mainPage.getKmlFile();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                try {
                    FeatureCollection<SimpleFeatureType, SimpleFeature> collection = KmlUtils.kmlFile2FeatureCollection(kmlFile);
                    IGeoResource resource = CatalogPlugin.getDefault().getLocalCatalog().createTemporaryResource((Object)collection.getSchema());
                    FeatureStore store = (FeatureStore)resource.resolve(FeatureStore.class, pm);
                    store.addFeatures(collection);
                    ApplicationGIS.addLayersToMap((IMap)ApplicationGIS.getActiveMap(), Collections.singletonList(resource), (int)-1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = Messages.getString("KmlImportWizard.error.ExceptionDuringKMLToFeatureLayer");
                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.catalog.kml", (Throwable)e);
                }
            }
        };
        PlatformGIS.runInProgressDialog((String)Messages.getString("KmlImportWizard.taskImportKmlDataMessage"), (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
        return true;
    }
}

