/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.kml.wizard;

import eu.udig.catalog.kml.core.KmlUtils;
import eu.udig.catalog.kml.internal.Messages;
import eu.udig.catalog.kml.wizard.KmlExportWizard;
import java.io.File;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class KmlExportWizardPage
extends WizardPage {
    public static final String ID = "eu.udig.catalog.kml.wizard.KmlExportWizardPage";
    private IGeoResource geoResource;
    private String filePath;

    public KmlExportWizardPage() {
        super(ID);
        this.setTitle(Messages.getString("KmlExportWizardPage.windowTitle"));
        this.setDescription(Messages.getString("KmlExportWizardPage.description"));
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout());
        ILayer selectedLayer = ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer();
        this.geoResource = selectedLayer.getGeoResource();
        Label selectedLayerLabel = new Label(mainComposite, 0);
        GridData selectedLayerLabelGd = new GridData(1, 0x1000000, false, false);
        selectedLayerLabelGd.horizontalSpan = 3;
        selectedLayerLabel.setLayoutData((Object)selectedLayerLabelGd);
        selectedLayerLabel.setText(String.valueOf(Messages.getString("KmlExportWizardPage.selectedLayerToExportLabel")) + selectedLayer.getName());
        Group inputGroup = new Group(mainComposite, 0);
        inputGroup.setText(Messages.getString("KmlExportWizardPage.outFileLabel"));
        inputGroup.setLayout((Layout)new GridLayout(2, false));
        inputGroup.setLayoutData((Object)new GridData(768));
        GridData gridData1 = new GridData(768);
        gridData1.horizontalSpan = 2;
        final Text kmlText = new Text((Composite)inputGroup, 18436);
        kmlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        kmlText.setText("");
        kmlText.setEditable(false);
        final Button outFolderButton = new Button((Composite)inputGroup, 8);
        outFolderButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        outFolderButton.setText(Messages.getString("KmlWizardPages.chooseFileButtonLabel"));
        outFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog saveKmlDialog = new FileDialog(outFolderButton.getShell(), 8192);
                saveKmlDialog.setFilterExtensions(KmlUtils.SUPPORTED_FILE_EXTENSIONS);
                saveKmlDialog.setOverwrite(true);
                String path = saveKmlDialog.open();
                if (path == null || path.length() < 1) {
                    kmlText.setText("");
                } else {
                    kmlText.setText(path);
                    KmlExportWizardPage.this.filePath = path;
                }
                KmlExportWizardPage.this.checkFinish();
            }
        });
        this.setControl((Control)mainComposite);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public IGeoResource getGeoResource() {
        return this.geoResource;
    }

    public void dispose() {
        super.dispose();
    }

    private void checkFinish() {
        File file;
        File parentFolder;
        KmlExportWizard.canFinish = this.filePath == null ? false : (parentFolder = (file = new File(this.filePath)).getParentFile()).isDirectory();
        this.getWizard().getContainer().updateButtons();
    }
}

