/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.kml.wizard;

import eu.udig.catalog.kml.core.KmlToolPlugin;
import eu.udig.catalog.kml.core.KmlUtils;
import eu.udig.catalog.kml.internal.Messages;
import eu.udig.catalog.kml.wizard.KmlExportWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class KmlExportWizard
extends Wizard
implements IExportWizard {
    public static boolean canFinish = false;
    private KmlExportWizardPage mainPage;
    public static DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.getString("KmlExportWizard.windowTitle"));
        this.setDefaultPageImageDescriptor(KmlToolPlugin.getDefault().getImageDescriptor("wizban/exportkml_wiz.gif"));
        this.setNeedsProgressMonitor(true);
        this.mainPage = new KmlExportWizardPage();
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                IGeoResource geoResource = KmlExportWizard.this.mainPage.getGeoResource();
                String filePath = KmlExportWizard.this.mainPage.getFilePath();
                pm.beginTask(Messages.getString("KmlExportWizard.taskExportingMap"), -1);
                try {
                    if (!geoResource.canResolve(SimpleFeatureSource.class)) {
                        throw new IOException(String.valueOf(Messages.getString("KmlExportWizard.error.ResourceIsNotAFeatureLayer")) + geoResource.getTitle());
                    }
                    SimpleFeatureSource featureStore = (SimpleFeatureSource)geoResource.resolve(SimpleFeatureSource.class, pm);
                    KmlUtils.writeKml(new File(filePath), (FeatureCollection<SimpleFeatureType, SimpleFeature>)featureStore.getFeatures());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = String.valueOf(Messages.getString("KmlExportWizard.error.ErrorOccuredWhileExproting")) + geoResource.getTitle();
                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.catalog.kml", (Throwable)e);
                }
                pm.done();
            }
        };
        PlatformGIS.runInProgressDialog((String)Messages.getString("KmlExportWizard.taskExportingToKML"), (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
        return true;
    }

    public boolean canFinish() {
        return super.canFinish() && canFinish;
    }
}

