/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.h2.H2DialectBasic;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class H2DataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"h2");
    public static final DataAccessFactory.Param ASSOCIATIONS = new DataAccessFactory.Param("Associations", Boolean.class, "Associations", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param(JDBCDataStoreFactory.HOST.key, JDBCDataStoreFactory.HOST.type, JDBCDataStoreFactory.HOST.description, false, JDBCDataStoreFactory.HOST.sample);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param(JDBCDataStoreFactory.PORT.key, JDBCDataStoreFactory.PORT.type, JDBCDataStoreFactory.PORT.description, false, (Object)9902);
    File baseDirectory = null;

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(JDBCDataStoreFactory.HOST.key);
        parameters.remove(JDBCDataStoreFactory.PORT.key);
        parameters.put(H2DataStoreFactory.HOST.key, HOST);
        parameters.put(H2DataStoreFactory.PORT.key, PORT);
        parameters.remove(JDBCDataStoreFactory.USER.key);
        parameters.remove(H2DataStoreFactory.PASSWD.key);
        parameters.put(H2DataStoreFactory.USER.key, USER);
        parameters.put(H2DataStoreFactory.PASSWD.key, PASSWD);
        parameters.put(H2DataStoreFactory.ASSOCIATIONS.key, ASSOCIATIONS);
        parameters.put(H2DataStoreFactory.DBTYPE.key, DBTYPE);
    }

    public String getDisplayName() {
        return "H2";
    }

    public String getDescription() {
        return "H2 Embedded Database";
    }

    protected String getDatabaseID() {
        return (String)H2DataStoreFactory.DBTYPE.sample;
    }

    protected String getDriverClassName() {
        return "org.h2.Driver";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new H2DialectBasic(dataStore);
    }

    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        String password;
        String database = (String)DATABASE.lookUp(params);
        String host = (String)HOST.lookUp(params);
        BasicDataSource dataSource = new BasicDataSource();
        if (host != null && !host.equals("")) {
            Integer port = (Integer)PORT.lookUp(params);
            if (port != null && !port.equals("")) {
                dataSource.setUrl("jdbc:h2:tcp://" + host + ":" + port + "/" + database);
            } else {
                dataSource.setUrl("jdbc:h2:tcp://" + host + "/" + database);
            }
        } else if (this.baseDirectory == null) {
            dataSource.setUrl("jdbc:h2:" + database);
        } else {
            String location = !new File(database).isAbsolute() ? new File(this.baseDirectory, database).getAbsolutePath() : database;
            dataSource.setUrl("jdbc:h2:file:" + location);
        }
        String username = (String)USER.lookUp(params);
        if (username != null) {
            dataSource.setUsername(username);
        }
        if ((password = (String)PASSWD.lookUp(params)) != null) {
            dataSource.setPassword(password);
        }
        dataSource.setDriverClassName("org.h2.Driver");
        dataSource.setPoolPreparedStatements(false);
        return new DBCPDataSource(dataSource);
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        Boolean foreignKeys = (Boolean)ASSOCIATIONS.lookUp(params);
        if (foreignKeys != null) {
            dataStore.setAssociations(foreignKeys.booleanValue());
        }
        return dataStore;
    }

    protected String getValidationQuery() {
        return null;
    }
}

