/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.legend;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.style.jgrass.legend.Java2dDrawing;
import eu.udig.style.jgrass.legend.VectorLegendStyle;
import eu.udig.style.jgrass.legend.VectorLegendStyleContent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.internal.MapGraphicResource;
import net.refractions.udig.mapgraphic.style.FontStyle;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.SLDs;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.FeatureSource;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class VectorLegendGraphic
implements MapGraphic {
    private int verticalMargin;
    private int horizontalMargin;
    private int verticalSpacing;
    private int horizontalSpacing;
    private Color foregroundColour;
    private Color backgroundColour;
    private Color fontColour;
    private boolean isRounded = false;
    private int indentSize;
    private int boxWidth;
    private int boxHeight;
    private int maxHeight;
    private int maxWidth;
    private Display display;
    private static Java2dDrawing java2dDrawing = Java2dDrawing.create();

    public void draw(MapGraphicContext context) {
        FontStyle fontStyle;
        Rectangle locationStyle;
        IMap currentMap;
        IMap activeMap = ApplicationGIS.getActiveMap();
        if (!activeMap.equals(currentMap = context.getLayer().getMap())) {
            return;
        }
        IStyleBlackboard blackboard = context.getLayer().getStyleBlackboard();
        VectorLegendStyle legendStyle = (VectorLegendStyle)blackboard.get("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle");
        if (legendStyle == null) {
            legendStyle = VectorLegendStyleContent.createDefault();
            blackboard.put("eu.hydrologis.jgrass.rasterlegend.vectorlegendStyle", (Object)legendStyle);
        }
        if ((locationStyle = null) == null) {
            locationStyle = new Rectangle(-1, -1, -1, -1);
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)locationStyle);
        }
        if ((fontStyle = (FontStyle)blackboard.get("net.refractions.udig.mapgraphic.style.font")) == null) {
            fontStyle = new FontStyle();
            blackboard.put("net.refractions.udig.mapgraphic.style.font", (Object)fontStyle);
        }
        this.backgroundColour = legendStyle.backgroundColor;
        this.foregroundColour = legendStyle.foregroundColor;
        this.fontColour = legendStyle.fontColor;
        this.isRounded = legendStyle.isRoundedRectangle;
        this.horizontalMargin = 5;
        this.verticalMargin = 5;
        this.horizontalSpacing = 3;
        this.verticalSpacing = 3;
        this.indentSize = 5;
        this.boxHeight = legendStyle.boxWidth;
        this.boxWidth = legendStyle.boxWidth;
        this.maxHeight = legendStyle.legendHeight;
        this.maxWidth = legendStyle.legendWidth;
        locationStyle.x = legendStyle.xPos;
        locationStyle.y = legendStyle.yPos;
        final ViewportGraphics graphics = context.getGraphics();
        GC gc = (GC)graphics.getGraphics(GC.class);
        if (gc != null) {
            gc.setAntialias(1);
        }
        final int rowHeight = Math.max(this.boxHeight, graphics.getFontHeight());
        Font oldFont = fontStyle.getFont();
        int fontHeight = rowHeight < 12 ? 8 : rowHeight - 8;
        Font font = new Font(oldFont.getName(), fontStyle.getFont().getStyle(), fontHeight);
        if (font != null) {
            graphics.setFont(font);
        } else {
            graphics.setFont(fontStyle.getFont());
        }
        ArrayList<Map<ILayer, FeatureTypeStyle[]>> layers = new ArrayList<Map<ILayer, FeatureTypeStyle[]>>();
        int longestRow = 0;
        final int[] numberOfEntries = new int[]{0};
        int i = context.getMapLayers().size() - 1;
        while (i >= 0) {
            String layerName;
            ILayer layer = (ILayer)context.getMapLayers().get(i);
            IGeoResource geoResource = layer.getGeoResource();
            boolean isMapgraphic = geoResource.canResolve(MapGraphicResource.class);
            if (!isMapgraphic && layer.isVisible() && (layerName = layer.getName()) != null && layerName.length() != 0) {
                FeatureTypeStyle[] styles = this.locateStyle(layer);
                if (styles == null || this.rules(styles).size() <= 0) {
                    if (!layer.hasResource(MapGraphic.class)) {
                        // empty if block
                    }
                } else {
                    numberOfEntries[0] = numberOfEntries[0] + this.rules(styles).size();
                    List<Rule> rules = this.rules(styles);
                    for (Rule rule : rules) {
                        String text = this.getText(rule);
                        Rectangle2D bounds = graphics.getStringBounds(text);
                        int length = this.indentSize + this.boxWidth + this.horizontalSpacing + (int)bounds.getWidth();
                        if (length <= longestRow) continue;
                        longestRow = length;
                    }
                    Map<ILayer, FeatureTypeStyle[]> map = Collections.singletonMap(layer, styles);
                    layers.add(map);
                    if (styles != null && this.rules(styles).size() > 1) {
                        numberOfEntries[0] = numberOfEntries[0] + 1;
                    }
                    Rectangle2D bounds = graphics.getStringBounds(layerName);
                    int length = (int)bounds.getWidth();
                    if (styles != null && this.rules(styles).size() < 2) {
                        length += this.boxWidth + this.horizontalSpacing;
                    }
                    if (length > longestRow) {
                        longestRow = length;
                    }
                }
            }
            --i;
        }
        if (numberOfEntries[0] == 0) {
            return;
        }
        int width = longestRow + this.horizontalMargin * 2;
        if (this.maxWidth > 0 && this.maxWidth > width) {
            width = this.maxWidth;
        }
        int height = rowHeight * numberOfEntries[0] + this.verticalMargin * 2 + this.verticalSpacing * (numberOfEntries[0] - 1);
        if (this.maxHeight > 0 && this.maxHeight > height) {
            height = this.maxHeight;
        }
        if (locationStyle.width < 1 || locationStyle.getHeight() < 1.0) {
            int x = locationStyle.x;
            int y = locationStyle.y;
            locationStyle = new Rectangle();
            locationStyle.x = x;
            locationStyle.y = y;
            locationStyle.width = width;
            locationStyle.height = height;
        }
        Dimension displaySize = context.getMapDisplay().getDisplaySize();
        if (locationStyle.x < 0) {
            locationStyle.x = displaySize.width - locationStyle.width + locationStyle.x;
        }
        if (locationStyle.x + locationStyle.width + 6 > displaySize.width) {
            locationStyle.x = displaySize.width - width - 5;
        }
        if (locationStyle.y < 0) {
            locationStyle.y = displaySize.height - locationStyle.height - 5 + locationStyle.y;
        }
        if (locationStyle.y + height + 6 > displaySize.height) {
            locationStyle.y = displaySize.height - locationStyle.height - 5;
        }
        graphics.setClip(new Rectangle(locationStyle.x, locationStyle.y, locationStyle.width + 1, locationStyle.height + 1));
        this.drawOutline(graphics, context, locationStyle);
        final int[] rowsDrawn = new int[]{0};
        final int[] x = new int[]{locationStyle.x + this.horizontalMargin};
        final int[] y = new int[]{locationStyle.y + this.verticalMargin};
        int i2 = 0;
        while (i2 < layers.size()) {
            Map map = (Map)layers.get(i2);
            final ILayer layer = (ILayer)map.keySet().iterator().next();
            final FeatureTypeStyle[] styles = (FeatureTypeStyle[])map.values().iterator().next();
            final String layerName = layer.getName();
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (styles != null && VectorLegendGraphic.this.rules(styles).size() > 1) {
                        VectorLegendGraphic.this.drawRow(graphics, x[0], y[0], null, layerName, false);
                        y[0] = y[0] + rowHeight;
                        if (rowsDrawn[0] + 1 < numberOfEntries[0]) {
                            y[0] = y[0] + VectorLegendGraphic.this.verticalSpacing;
                        }
                        rowsDrawn[0] = rowsDrawn[0] + 1;
                        List rules = VectorLegendGraphic.this.rules(styles);
                        for (Rule rule : rules) {
                            SimpleFeatureType type;
                            GeometryDescriptor geom;
                            BufferedImage awtIcon = null;
                            if (layer.hasResource(FeatureSource.class) && rule != null && (geom = (type = layer.getSchema()).getGeometryDescriptor()) != null) {
                                Class geom_type = geom.getType().getBinding();
                                if (geom_type == Point.class || geom_type == MultiPoint.class) {
                                    awtIcon = VectorLegendGraphic.this.point(rule, VectorLegendGraphic.this.boxWidth, VectorLegendGraphic.this.boxHeight);
                                } else if (geom_type == LineString.class || geom_type == MultiLineString.class) {
                                    awtIcon = VectorLegendGraphic.this.line(rule, VectorLegendGraphic.this.boxWidth, VectorLegendGraphic.this.boxHeight);
                                } else if (geom_type == Polygon.class || geom_type == MultiPolygon.class) {
                                    awtIcon = VectorLegendGraphic.this.polygon(rule, VectorLegendGraphic.this.boxWidth, VectorLegendGraphic.this.boxHeight);
                                } else {
                                    if (geom_type != Geometry.class && geom_type != GeometryCollection.class) continue;
                                    awtIcon = VectorLegendGraphic.this.geometry(rule, VectorLegendGraphic.this.boxWidth, VectorLegendGraphic.this.boxHeight);
                                }
                            }
                            VectorLegendGraphic.this.drawRow(graphics, x[0], y[0], awtIcon, VectorLegendGraphic.this.getText(rule), true);
                            y[0] = y[0] + rowHeight;
                            if (rowsDrawn[0] + 1 < numberOfEntries[0]) {
                                y[0] = y[0] + VectorLegendGraphic.this.verticalSpacing;
                            }
                            rowsDrawn[0] = rowsDrawn[0] + 1;
                        }
                    } else {
                        BufferedImage awtIcon = VectorLegendGraphic.this.generateIcon((Layer)layer, VectorLegendGraphic.this.boxWidth, VectorLegendGraphic.this.boxHeight);
                        VectorLegendGraphic.this.drawRow(graphics, x[0], y[0], awtIcon, layerName, false);
                        y[0] = y[0] + rowHeight;
                        if (rowsDrawn[0] + 1 < numberOfEntries[0]) {
                            y[0] = y[0] + VectorLegendGraphic.this.verticalSpacing;
                        }
                        rowsDrawn[0] = rowsDrawn[0] + 1;
                    }
                }
            });
            ++i2;
        }
        graphics.setClip(null);
    }

    private List<Rule> rules(FeatureTypeStyle[] styles) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        FeatureTypeStyle[] featureTypeStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureTypeStyle featureTypeStyle = featureTypeStyleArray[n2];
            rules.addAll(Arrays.asList(featureTypeStyle.getRules()));
            ++n2;
        }
        return rules;
    }

    private String getText(Rule rule) {
        String text = "";
        if (rule.getTitle() != null && !"".equals(rule.getTitle())) {
            text = rule.getTitle();
        } else if (rule.getName() != null && !"".equals(rule.getName())) {
            text = rule.getName();
        } else if (rule.getFilter() != null) {
            text = rule.getFilter().toString();
        }
        if (text.length() > 19) {
            return String.valueOf(text.substring(0, 18)) + "...";
        }
        return text;
    }

    private void drawRow(ViewportGraphics graphics, int x, int y, RenderedImage icon, String text, boolean indent) {
        Rectangle2D stringBounds = graphics.getStringBounds(text);
        int textVerticalOffset = 0;
        int iconVerticalOffset = 0;
        if (this.boxHeight != (int)stringBounds.getHeight()) {
            if (this.boxHeight > (int)stringBounds.getHeight()) {
                int difference = this.boxHeight - (int)stringBounds.getHeight();
                textVerticalOffset = difference / 2;
            } else if (this.boxHeight < (int)stringBounds.getHeight()) {
                int difference = (int)stringBounds.getHeight() - this.boxHeight;
                iconVerticalOffset = difference / 2;
            }
        }
        if (indent) {
            x += this.indentSize;
        }
        if (icon != null) {
            graphics.drawImage(icon, x, y + iconVerticalOffset);
            x += this.boxWidth;
        }
        if (text != null && text.length() != 0) {
            graphics.setColor(this.fontColour);
            graphics.drawString(text, x + this.horizontalMargin, y + graphics.getFontAscent() + textVerticalOffset, -1, -1);
        }
    }

    private FeatureTypeStyle[] locateStyle(ILayer layer) {
        StyleBlackboard blackboard = (StyleBlackboard)layer.getStyleBlackboard();
        if (blackboard == null) {
            return null;
        }
        Style sld = (Style)blackboard.lookup(Style.class);
        if (sld == null) {
            return null;
        }
        ArrayList<FeatureTypeStyle> styles = new ArrayList<FeatureTypeStyle>();
        FeatureTypeStyle[] featureTypeStyleArray = sld.getFeatureTypeStyles();
        int n = featureTypeStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureTypeStyle style = featureTypeStyleArray[n2];
            if (style.getFeatureTypeName() == null || style.getFeatureTypeName().equals("Feature")) {
                styles.add(style);
            } else if (layer.getSchema() != null && layer.getSchema().getTypeName() != null && layer.getSchema().getTypeName().equals(style.getFeatureTypeName())) {
                styles.add(style);
            }
            ++n2;
        }
        return styles.toArray(new FeatureTypeStyle[0]);
    }

    private void drawOutline(ViewportGraphics graphics, MapGraphicContext context, Rectangle locationStyle) {
        Rectangle outline = new Rectangle(locationStyle.x, locationStyle.y, locationStyle.width, locationStyle.height);
        context.getLabelPainter().put((Rectangle2D)outline);
        if (this.isRounded) {
            graphics.setColor(this.backgroundColour);
            graphics.fillRoundRect(locationStyle.x, locationStyle.y, locationStyle.width, locationStyle.height, 15, 15);
            graphics.setColor(this.foregroundColour);
            graphics.setBackground(this.backgroundColour);
            graphics.drawRoundRect(locationStyle.x, locationStyle.y, locationStyle.width, locationStyle.height, 15, 15);
        } else {
            graphics.setColor(this.backgroundColour);
            graphics.fillRect(locationStyle.x, locationStyle.y, locationStyle.width, locationStyle.height);
            graphics.setColor(this.foregroundColour);
            graphics.setBackground(this.backgroundColour);
            graphics.drawRect(locationStyle.x, locationStyle.y, locationStyle.width, locationStyle.height);
        }
    }

    public BufferedImage geometry(Rule rule, int width, int height) {
        BufferedImage bI = new BufferedImage(width, height, 2);
        java2dDrawing.drawDirect(bI, this.display, java2dDrawing.feature(java2dDrawing.line(new int[]{this.scale(0), this.scale(12), this.scale(6), this.scale(3), this.scale(11), this.scale(12), this.scale(15), this.scale(3)})), rule);
        java2dDrawing.drawDirect(bI, this.display, java2dDrawing.feature(java2dDrawing.point(this.scale(4), this.scale(4))), rule);
        return bI;
    }

    public BufferedImage point(Rule rule, int width, int height) {
        BufferedImage bI = new BufferedImage(width, height, 2);
        java2dDrawing.drawDirect(bI, this.display, java2dDrawing.feature(java2dDrawing.point(this.scale(7), this.scale(7))), rule);
        return bI;
    }

    public BufferedImage line(Rule rule, int width, int height) {
        BufferedImage bI = new BufferedImage(width, height, 2);
        int[] coords = new int[]{this.scale(1), this.scale(14), this.scale(6), this.scale(0), this.scale(11), this.scale(14), this.scale(15), this.scale(1)};
        SimpleFeature feature = java2dDrawing.feature(java2dDrawing.line(coords));
        java2dDrawing.drawDirect(bI, this.display, feature, rule);
        return bI;
    }

    public BufferedImage polygon(Rule rule, int width, int height) {
        BufferedImage bI = new BufferedImage(width, height, 2);
        int[] coords = new int[]{this.scale(1), this.scale(14), this.scale(3), this.scale(9), this.scale(4), this.scale(6), this.scale(6), this.scale(4), this.scale(9), this.scale(3), this.scale(14), this.scale(1), this.scale(14), this.scale(14)};
        java2dDrawing.drawDirect(bI, this.display, java2dDrawing.feature(java2dDrawing.polygon(coords)), rule);
        return bI;
    }

    public BufferedImage generateIcon(Layer layer, int width, int height) {
        BufferedImage icon;
        StyleBlackboard style = layer.getStyleBlackboard();
        if (style != null && !style.getContent().isEmpty() && (icon = this.generateStyledIcon(layer)) != null) {
            return icon;
        }
        return null;
    }

    public BufferedImage generateStyledIcon(Layer layer) {
        StyleBlackboard blackboard = layer.getStyleBlackboard();
        if (blackboard == null) {
            return null;
        }
        Style sld = (Style)blackboard.lookup(Style.class);
        if (sld != null) {
            SimpleFeatureType type;
            GeometryDescriptor geom;
            Rule rule = this.getRule(sld);
            BufferedImage swtIcon = null;
            if (layer.hasResource(FeatureSource.class) && rule != null && (geom = (type = layer.getSchema()).getGeometryDescriptor()) != null) {
                Class geom_type = geom.getType().getBinding();
                if (geom_type == Point.class || geom_type == MultiPoint.class) {
                    swtIcon = this.point(rule, this.boxWidth, this.boxHeight);
                } else if (geom_type == LineString.class || geom_type == MultiLineString.class) {
                    swtIcon = this.line(rule, this.boxWidth, this.boxHeight);
                } else if (geom_type == Polygon.class || geom_type == MultiPolygon.class) {
                    swtIcon = this.polygon(rule, this.boxWidth, this.boxHeight);
                } else if (geom_type == Geometry.class || geom_type == GeometryCollection.class) {
                    swtIcon = this.geometry(rule, this.boxWidth, this.boxHeight);
                } else {
                    return null;
                }
            }
            return swtIcon;
        }
        return null;
    }

    private Rule getRule(Style sld) {
        Rule rule = null;
        int size = 0;
        FeatureTypeStyle[] featureTypeStyleArray = sld.getFeatureTypeStyles();
        int n = featureTypeStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureTypeStyle style = featureTypeStyleArray[n2];
            Rule[] ruleArray = style.getRules();
            int n3 = ruleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Rule potentialRule = ruleArray[n4];
                if (potentialRule != null) {
                    Symbolizer[] symbs = potentialRule.getSymbolizers();
                    int m = 0;
                    while (m < symbs.length) {
                        int newSize;
                        if (symbs[m] instanceof PointSymbolizer) {
                            newSize = SLDs.pointSize((PointSymbolizer)((PointSymbolizer)symbs[m]));
                            if (newSize > 16 && size != 0) {
                                return rule;
                            }
                        } else {
                            return potentialRule;
                        }
                        size = newSize;
                        rule = potentialRule;
                        ++m;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return rule;
    }

    private int scale(int value) {
        float scaled = (float)(value * this.boxHeight) / 16.0f;
        return Math.round(scaled);
    }
}

