/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.core;

import eu.udig.style.jgrass.core.ColorTable;
import eu.udig.style.jgrass.core.PredefinedColorRules;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.core.color.JlsTokenizer;

public class GrassColorTable
extends ColorTable {
    private File colrFile;
    private int alpha = 255;

    public GrassColorTable(String mapsetPath, String mapName, double[] dataRange) throws IOException {
        this(String.valueOf(mapsetPath) + File.separator + "colr" + File.separator + mapName, dataRange);
    }

    /*
     * Unable to fully structure code
     */
    public GrassColorTable(String colorFilePath, double[] dataRange) throws IOException {
        super();
        this.colrFile = new File(colorFilePath);
        if (this.colrFile.exists()) {
            rdr = null;
            try {
                rdr = new BufferedReader(new InputStreamReader(new FileInputStream(this.colrFile)));
                line = rdr.readLine();
                if (line == null) {
                    this.colorTableEmpty = true;
                    rdr.close();
                    if (this.colrFile.delete()) {
                        System.out.println("removed empty color file");
                    }
                    return;
                }
                if ((line = line.trim()) == null) ** continue;
                if (line.charAt(0) == '%') {
                    stringValues = line.split("\\s+");
                    if (stringValues.length == 4) {
                        try {
                            this.alpha = Integer.parseInt(stringValues[3]);
                        }
                        catch (NumberFormatException v0) {
                            this.alpha = 255;
                        }
                    } else {
                        this.alpha = 255;
                    }
                    while ((line = rdr.readLine()) != null) {
                        if (line.charAt(0) == '%') continue;
                        this.processGrass4ColorRule(line.trim());
                    }
                } else if (line.charAt(0) == '#') {
                    catNumber = Integer.parseInt(line.substring(1, 2));
                    this.processGrass3ColorRule(-1, rdr.readLine());
                    while ((line = rdr.readLine()) != null) {
                        this.processGrass3ColorRule(catNumber++, line.trim());
                    }
                } else {
                    catNumber = 0;
                    while ((line = rdr.readLine()) != null) {
                        this.processGrass3ColorRule(catNumber++, line.trim());
                    }
                }
            }
            finally {
                rdr.close();
            }
            this.colorTableEmpty = false;
        } else {
            this.colorTableEmpty = true;
        }
    }

    private void processGrass3ColorRule(int lineNumber, String line) {
        if (line == null) {
            return;
        }
        try {
            JlsTokenizer tk = new JlsTokenizer(line, " ");
            if (lineNumber < 0) {
                if (tk.hasMoreTokens()) {
                    String b;
                    String g = b = tk.nextToken();
                    String r = b;
                    if (tk.hasMoreTokens()) {
                        g = tk.nextToken();
                    }
                    if (tk.hasMoreTokens()) {
                        b = tk.nextToken();
                    }
                    if (r.indexOf(46) == -1) {
                        this.setBackgroundColor(new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b)));
                    } else {
                        this.setBackgroundColor(new Color(Float.parseFloat(r), Float.parseFloat(g), Float.parseFloat(b)));
                    }
                }
            } else {
                String b;
                String g = b = tk.nextToken();
                String r = b;
                if (tk.hasMoreTokens()) {
                    g = tk.nextToken();
                }
                if (tk.hasMoreTokens()) {
                    b = tk.nextToken();
                }
                if (r.indexOf(46) == -1) {
                    this.addColorRule(lineNumber, Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
                } else {
                    this.addColorRule(lineNumber, (int)(Float.parseFloat(r) * 255.0f), (int)(Float.parseFloat(g) * 255.0f), (int)(Float.parseFloat(b) * 255.0f));
                }
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    private void processGrass4ColorRule(String line) {
        int r0 = -1;
        int g0 = -1;
        int b0 = -1;
        int r1 = -1;
        int g1 = -1;
        int b1 = -1;
        float cat0 = 0.0f;
        float cat1 = 0.0f;
        if (line == null) {
            return;
        }
        try {
            JlsTokenizer tk = new JlsTokenizer(line, " ");
            if (tk.hasMoreTokens()) {
                JlsTokenizer tk1 = new JlsTokenizer(tk.nextToken(), ":");
                cat0 = Float.parseFloat(tk1.nextToken());
                g0 = b0 = Integer.parseInt(tk1.nextToken());
                r0 = b0;
                if (tk1.hasMoreTokens()) {
                    g0 = b0 = Integer.parseInt(tk1.nextToken());
                }
                if (tk1.hasMoreTokens()) {
                    b0 = Integer.parseInt(tk1.nextToken());
                }
                if (tk.hasMoreTokens()) {
                    tk1 = new JlsTokenizer(tk.nextToken(), ":");
                    cat1 = Float.parseFloat(tk1.nextToken());
                    g1 = b1 = Integer.parseInt(tk1.nextToken());
                    r1 = b1;
                    if (tk1.hasMoreTokens()) {
                        g1 = b1 = Integer.parseInt(tk1.nextToken());
                    }
                    if (tk1.hasMoreTokens()) {
                        b1 = Integer.parseInt(tk1.nextToken());
                    }
                }
                if (r1 == -1) {
                    this.addColorRule((int)cat0, r0, g0, b0);
                } else {
                    this.addColorRule(cat0, r0, g0, b0, cat1, r1, g1, b1);
                }
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void createDefaultColorTable(double[] dataRange) throws IOException {
        String[][] rainbow = PredefinedColorRules.rainbow;
        ArrayList<String> rules = new ArrayList<String>();
        float rinc = (float)(dataRange[1] - dataRange[0]) / 5.0f;
        int i = 0;
        while (i < 4) {
            this.addColorRule((float)(dataRange[0] + (double)((float)i * rinc)), Integer.parseInt(rainbow[i][0]), Integer.parseInt(rainbow[i][1]), Integer.parseInt(rainbow[i][2]), (float)(dataRange[0] + (double)((float)(i + 1) * rinc)), Integer.parseInt(rainbow[i + 1][0]), Integer.parseInt(rainbow[i + 1][1]), Integer.parseInt(rainbow[i + 1][2]));
            StringBuffer rule = new StringBuffer();
            rule.append(String.valueOf(dataRange[0] + (double)((float)i * rinc)) + ":");
            rule.append(String.valueOf(rainbow[i][0]) + ":" + rainbow[i][1] + ":" + rainbow[i][2] + " ");
            rule.append(String.valueOf(dataRange[0] + (double)((float)(i + 1) * rinc)) + ":");
            rule.append(String.valueOf(rainbow[i + 1][0]) + ":" + rainbow[i + 1][1] + ":" + rainbow[i + 1][2] + " ");
            rules.add(rule.toString());
            ++i;
        }
        this.addColorRule((float)(dataRange[1] - (double)rinc), Integer.parseInt(rainbow[4][0]), Integer.parseInt(rainbow[4][1]), Integer.parseInt(rainbow[4][2]), (float)dataRange[1], Integer.parseInt(rainbow[5][0]), Integer.parseInt(rainbow[5][1]), Integer.parseInt(rainbow[5][2]));
        StringBuffer rule = new StringBuffer();
        rule.append(String.valueOf(dataRange[1] - (double)rinc) + ":");
        rule.append(String.valueOf(rainbow[4][0]) + ":" + rainbow[4][1] + ":" + rainbow[4][2] + " ");
        rule.append(String.valueOf(dataRange[1]) + ":");
        rule.append(String.valueOf(rainbow[5][0]) + ":" + rainbow[5][1] + ":" + rainbow[5][2] + " ");
        rules.add(rule.toString());
        if (!this.colrFile.exists()) {
            BufferedWriter bw = null;
            File colFolder = this.colrFile.getParentFile();
            if (!colFolder.exists() && !colFolder.mkdirs()) {
                throw new IOException("Could nto create folder: " + colFolder.getAbsolutePath());
            }
            bw = new BufferedWriter(new FileWriter(this.colrFile));
            String header = "% " + dataRange[0] + "   " + dataRange[1] + "   255";
            bw.write(String.valueOf(header) + "\n");
            for (String string : rules) {
                bw.write(String.valueOf(string) + "\n");
            }
            bw.close();
        }
    }

    public static String setColorTableFromRules(File colrFile, double[] dataRange, String[][] colorRules) throws IOException {
        String name = colrFile.getName();
        File mapsetFile = colrFile.getParentFile().getParentFile();
        JGrassMapEnvironment jGrassMapEnvironment = new JGrassMapEnvironment(mapsetFile, name);
        if (colorRules[0].length == 3) {
            if (dataRange == null) {
                dataRange = jGrassMapEnvironment.getRangeFromRangeFile();
                if (dataRange == null) {
                    dataRange = jGrassMapEnvironment.getRangeFromColorTable();
                }
                if (dataRange == null) {
                    dataRange = jGrassMapEnvironment.getRangeFromMapScan();
                }
            }
            float rinc = (float)(dataRange[1] - dataRange[0]) / (float)(colorRules.length - 1);
            StringBuffer rule = new StringBuffer();
            rule.append("% " + dataRange[0] + "   " + dataRange[1] + "   255\n");
            int i = 0;
            while (i < colorRules.length - 2) {
                rule.append(String.valueOf(dataRange[0] + (double)((float)i * rinc)) + ":");
                rule.append(String.valueOf(colorRules[i][0]) + ":" + colorRules[i][1] + ":" + colorRules[i][2] + " ");
                rule.append(String.valueOf(dataRange[0] + (double)((float)(i + 1) * rinc)) + ":");
                rule.append(String.valueOf(colorRules[i + 1][0]) + ":" + colorRules[i + 1][1] + ":" + colorRules[i + 1][2] + "\n");
                ++i;
            }
            rule.append(String.valueOf(dataRange[1] - (double)rinc) + ":");
            rule.append(String.valueOf(colorRules[colorRules.length - 2][0]) + ":" + colorRules[colorRules.length - 2][1] + ":" + colorRules[colorRules.length - 2][2] + " ");
            rule.append(String.valueOf(dataRange[1]) + ":");
            rule.append(String.valueOf(colorRules[colorRules.length - 1][0]) + ":" + colorRules[colorRules.length - 1][1] + ":" + colorRules[colorRules.length - 1][2] + "\n");
            BufferedWriter bw = new BufferedWriter(new FileWriter(colrFile));
            bw.write(rule.toString());
            bw.close();
            return rule.toString();
        }
        if (colorRules[0].length != 8) {
            throw new IOException("The colortable can have records of 3 or 8 columns. Check your colortables.");
        }
        StringBuffer rule = new StringBuffer();
        rule.append("% " + colorRules[0][0] + "   " + colorRules[colorRules.length - 1][0] + "   255\n");
        int i = 0;
        while (i < colorRules.length) {
            System.out.println(i);
            rule.append(String.valueOf(colorRules[i][0]) + ":");
            rule.append(String.valueOf(colorRules[i][1]) + ":" + colorRules[i][2] + ":" + colorRules[i][3] + " ");
            rule.append(String.valueOf(colorRules[i][4]) + ":");
            rule.append(String.valueOf(colorRules[i][5]) + ":" + colorRules[i][6] + ":" + colorRules[i][7] + "\n");
            ++i;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(colrFile));
        bw.write(rule.toString());
        bw.close();
        return rule.toString();
    }

    public String createDefaultColorRulesString(double[] dataRange, boolean writeToDisk) throws IOException {
        String[][] rainbow = PredefinedColorRules.rainbow;
        if (dataRange == null) {
            dataRange = new double[2];
            String name = this.colrFile.getName();
            File mapsetFile = this.colrFile.getParentFile().getParentFile();
            JGrassMapEnvironment jGrassMapEnvironment = new JGrassMapEnvironment(mapsetFile, name);
            File rangeFile = jGrassMapEnvironment.getCELLMISC_RANGE();
            boolean fileok = true;
            int testread = 0;
            if (rangeFile.exists()) {
                FileInputStream is = new FileInputStream(rangeFile);
                byte[] numbers = new byte[16];
                testread = ((InputStream)is).read(numbers);
                ((InputStream)is).close();
                if (testread == 16) {
                    ByteBuffer rangeBuffer = ByteBuffer.wrap(numbers);
                    dataRange[0] = rangeBuffer.getDouble();
                    dataRange[1] = rangeBuffer.getDouble();
                } else {
                    fileok = false;
                }
            } else {
                fileok = false;
            }
            if (!fileok) {
                double min = JGrassMapEnvironment.defaultMapMin;
                double max = JGrassMapEnvironment.defaultMapMax;
                dataRange[0] = min;
                dataRange[1] = max;
            }
        }
        float rinc = (float)(dataRange[1] - dataRange[0]) / 5.0f;
        StringBuffer rule = new StringBuffer();
        rule.append("% " + dataRange[0] + "   " + dataRange[1] + "   255\n");
        int i = 0;
        while (i < 4) {
            rule.append(String.valueOf(dataRange[0] + (double)((float)i * rinc)) + ":");
            rule.append(String.valueOf(rainbow[i][0]) + ":" + rainbow[i][1] + ":" + rainbow[i][2] + " ");
            rule.append(String.valueOf(dataRange[0] + (double)((float)(i + 1) * rinc)) + ":");
            rule.append(String.valueOf(rainbow[i + 1][0]) + ":" + rainbow[i + 1][1] + ":" + rainbow[i + 1][2] + "\n");
            ++i;
        }
        rule.append(String.valueOf(dataRange[1] - (double)rinc) + ":");
        rule.append(String.valueOf(rainbow[4][0]) + ":" + rainbow[4][1] + ":" + rainbow[4][2] + " ");
        rule.append(String.valueOf(dataRange[1]) + ":");
        rule.append(String.valueOf(rainbow[5][0]) + ":" + rainbow[5][1] + ":" + rainbow[5][2] + "\n");
        if (writeToDisk) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.colrFile));
            bw.write(rule.toString());
            bw.close();
        }
        return rule.toString();
    }

    public File getColrFile() {
        return this.colrFile;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }
}

