/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.colors;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.style.jgrass.JGrassrasterStyleActivator;
import eu.udig.style.jgrass.colors.ColorEditor;
import eu.udig.style.jgrass.colors.Rule;
import eu.udig.style.jgrass.core.ColorTable;
import eu.udig.style.jgrass.core.GrassColorTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.gce.grassraster.core.color.ColorRule;

public class JGrassRasterStyleEditorPage
extends StyleEditorPage {
    public static String ID = "eu.udig.style.jgrass.color";
    private ColorEditor colorRulesEditor = null;
    private boolean editorSupported = false;
    private String type = "unknown";

    public JGrassRasterStyleEditorPage() {
        this.setSize(new Point(500, 450));
    }

    public void createPageContent(Composite parent) {
        StyleLayer layer = this.getSelectedLayer();
        IGeoResource resource = layer.getGeoResource();
        if (resource.canResolve(JGrassMapGeoResource.class)) {
            try {
                JGrassMapGeoResource grassMapGeoResource = (JGrassMapGeoResource)resource.resolve(JGrassMapGeoResource.class, null);
                this.editorSupported = grassMapGeoResource.getType().equals("grassbinaryraster");
                this.type = grassMapGeoResource.getType();
            }
            catch (IOException e) {
                JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e);
                e.printStackTrace();
            }
        } else {
            this.editorSupported = false;
        }
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        if (this.editorSupported) {
            this.colorRulesEditor = new ColorEditor(parent, 0);
            String[] mapsetPathAndMapName = JGrassCatalogUtilities.getMapsetpathAndMapnameFromJGrassMapGeoResource((IGeoResource)resource);
            ColorTable ctable = null;
            Enumeration<ColorRule> rules = null;
            try {
                while (rules == null || !rules.hasMoreElements()) {
                    try {
                        ctable = new GrassColorTable(mapsetPathAndMapName[0], mapsetPathAndMapName[1], null);
                    }
                    catch (IOException e1) {
                        JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e1);
                        e1.printStackTrace();
                    }
                    rules = ctable.getColorRules();
                    if (rules != null && rules.hasMoreElements()) continue;
                    ((GrassColorTable)ctable).createDefaultColorRulesString(null, true);
                }
            }
            catch (Exception e) {
                JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem: eu.hydrologis.jgrass.style.jgrassraster.colors#JGrassRasterStyleEditorPage#createPageContent", e);
                e.printStackTrace();
            }
            ArrayList<Rule> listOfRules = new ArrayList<Rule>();
            while (rules.hasMoreElements()) {
                ColorRule element = rules.nextElement();
                float lowvalue = element.getLowCategoryValue();
                float highvalue = element.getLowCategoryValue() + element.getCategoryRange();
                byte[] lowcatcol = element.getColor(lowvalue);
                byte[] highcatcol = element.getColor(highvalue);
                float[] lowHigh = new float[]{lowvalue, highvalue};
                Color lowColor = new Color((Device)Display.getDefault(), lowcatcol[0] & 0xFF, lowcatcol[1] & 0xFF, lowcatcol[2] & 0xFF);
                Color highColor = new Color((Device)Display.getDefault(), highcatcol[0] & 0xFF, highcatcol[1] & 0xFF, highcatcol[2] & 0xFF);
                listOfRules.add(new Rule(lowHigh, lowColor, highColor, true));
            }
            this.colorRulesEditor.setLayer((Layer)layer);
            this.colorRulesEditor.setAlphaValue(((GrassColorTable)ctable).getAlpha());
            this.colorRulesEditor.setRulesList(listOfRules);
        } else {
            Label problemLabel = new Label(parent, 0);
            problemLabel.setText("No support for map styling of map type: \"" + this.type + "\"");
        }
    }

    public String getErrorMessage() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public void gotFocus() {
        System.out.println("colr got focus");
    }

    public boolean performCancel() {
        return false;
    }

    public boolean okToLeave() {
        return true;
    }

    public boolean performApply() {
        if (this.editorSupported) {
            this.colorRulesEditor.makePersistent();
        }
        return true;
    }

    public boolean performOk() {
        if (this.editorSupported) {
            this.colorRulesEditor.makePersistent();
        }
        return false;
    }

    public void refresh() {
    }

    public void dispose() {
        if (this.editorSupported) {
            this.colorRulesEditor = null;
        }
        super.dispose();
    }

    public void styleChanged(Object source) {
    }
}

