/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.jgrass.categories;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.style.jgrass.JGrassrasterStyleActivator;
import eu.udig.style.jgrass.categories.CategoryEditor;
import java.io.File;
import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JGrassRasterCategoryEditorPage
extends StyleEditorPage {
    public static String JGRASSRASTERSTYLEID = "eu.udig.style.jgrass.cats";
    private CategoryEditor categoryRulesEditor = null;
    private boolean editorSupported = false;
    private String type = "unknown";

    public JGrassRasterCategoryEditorPage() {
        this.setSize(new Point(500, 450));
    }

    public void createPageContent(Composite parent) {
        StyleLayer layer = this.getSelectedLayer();
        IGeoResource resource = layer.getGeoResource();
        if (resource.canResolve(JGrassMapGeoResource.class)) {
            try {
                JGrassMapGeoResource grassMapGeoResource = (JGrassMapGeoResource)resource.resolve(JGrassMapGeoResource.class, null);
                this.editorSupported = grassMapGeoResource.getType().equals("grassbinaryraster");
                this.type = grassMapGeoResource.getType();
            }
            catch (IOException e) {
                JGrassrasterStyleActivator.log("JGrassrasterStyleActivator problem", e);
                e.printStackTrace();
            }
        } else {
            this.editorSupported = false;
        }
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        if (this.editorSupported) {
            this.categoryRulesEditor = new CategoryEditor(parent, 0);
            String[] mapsetPathAndMapName = JGrassCatalogUtilities.getMapsetpathAndMapnameFromJGrassMapGeoResource((IGeoResource)resource);
            this.categoryRulesEditor.setLayer((Layer)layer);
            this.categoryRulesEditor.makeSomeCategories(String.valueOf(mapsetPathAndMapName[0]) + File.separator + "cats" + File.separator + mapsetPathAndMapName[1]);
        } else {
            Label problemLabel = new Label(parent, 0);
            problemLabel.setText("No support for map styling of map type: \"" + this.type + "\"");
        }
    }

    public String getErrorMessage() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public void gotFocus() {
    }

    public boolean performCancel() {
        return false;
    }

    public boolean okToLeave() {
        return true;
    }

    public boolean performApply() {
        if (this.editorSupported) {
            this.categoryRulesEditor.makePersistent();
        }
        return true;
    }

    public boolean performOk() {
        if (this.editorSupported) {
            this.categoryRulesEditor.makePersistent();
        }
        return false;
    }

    public void refresh() {
    }

    public void dispose() {
        if (this.editorSupported) {
            this.categoryRulesEditor = null;
        }
        super.dispose();
    }

    public void styleChanged(Object source) {
    }
}

